/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.hunspell;

import java.util.regex.PatternSyntaxException;
import org.apache.lucene.analysis.hunspell.AffixKind;
import org.apache.lucene.util.automaton.CharacterRunAutomaton;
import org.apache.lucene.util.automaton.RegExp;

interface AffixCondition {
    public static final String ALWAYS_TRUE_KEY = ".*";
    public static final AffixCondition ALWAYS_TRUE = (word, offset, length) -> true;
    public static final AffixCondition ALWAYS_FALSE = (word, offset, length) -> false;

    default public boolean acceptsStem(String stem) {
        return this.acceptsStem(stem.toCharArray(), 0, stem.length());
    }

    public boolean acceptsStem(char[] var1, int var2, int var3);

    public static String uniqueKey(AffixKind kind, String strip, String condition) {
        if (".".equals(condition) || kind == AffixKind.PREFIX && strip.startsWith(condition) || kind == AffixKind.SUFFIX && strip.endsWith(condition) && !AffixCondition.isRegexp(condition)) {
            return ALWAYS_TRUE_KEY;
        }
        return condition + " " + kind + " " + strip;
    }

    public static AffixCondition compile(AffixKind kind, String strip, String condition, String line) {
        if (!AffixCondition.isRegexp((String)condition)) {
            if (kind == AffixKind.SUFFIX && ((String)condition).endsWith(strip)) {
                return AffixCondition.substringCondition(kind, ((String)condition).substring(0, ((String)condition).length() - strip.length()));
            }
            if (kind == AffixKind.PREFIX && ((String)condition).startsWith(strip)) {
                return AffixCondition.substringCondition(kind, ((String)condition).substring(strip.length()));
            }
            return ALWAYS_FALSE;
        }
        int lastBracket = ((String)condition).lastIndexOf(91);
        if (lastBracket >= 0 && ((String)condition).indexOf(93, lastBracket + 1) < 0) {
            condition = (String)condition + "]";
        }
        try {
            int conditionChars = AffixCondition.countCharPatterns((String)condition);
            if (conditionChars <= strip.length()) {
                String regex = kind == AffixKind.PREFIX ? ALWAYS_TRUE_KEY + (String)condition : (String)condition + ALWAYS_TRUE_KEY;
                return strip.matches(regex) ? ALWAYS_TRUE : ALWAYS_FALSE;
            }
            if (kind == AffixKind.PREFIX) {
                int split = AffixCondition.skipCharPatterns((String)condition, strip.length());
                if (!strip.matches(((String)condition).substring(0, split))) {
                    return ALWAYS_FALSE;
                }
                return AffixCondition.regexpCondition(kind, ((String)condition).substring(split), conditionChars - strip.length());
            }
            int split = AffixCondition.skipCharPatterns((String)condition, conditionChars - strip.length());
            if (!strip.matches(((String)condition).substring(split))) {
                return ALWAYS_FALSE;
            }
            return AffixCondition.regexpCondition(kind, ((String)condition).substring(0, split), conditionChars - strip.length());
        }
        catch (PatternSyntaxException e2) {
            return ALWAYS_FALSE;
        }
        catch (Throwable e3) {
            throw new IllegalArgumentException("On line: " + line, e3);
        }
    }

    private static int skipCharPatterns(String condition, int count) {
        int pos = 0;
        for (int i = 0; i < count; ++i) {
            pos = AffixCondition.skipCharPattern(condition, pos);
        }
        return pos;
    }

    private static int countCharPatterns(String condition) {
        int conditionChars = 0;
        int i = 0;
        while (i < condition.length()) {
            ++conditionChars;
            i = AffixCondition.skipCharPattern(condition, i);
        }
        return conditionChars;
    }

    private static int skipCharPattern(String condition, int pos) {
        if (condition.charAt(pos) == '[' && (pos = condition.indexOf(93, pos + 1)) < 0) {
            throw new AssertionError((Object)("Malformed condition " + condition));
        }
        return pos + 1;
    }

    private static boolean isRegexp(String condition) {
        return condition.contains("[") || condition.contains(".") || condition.contains("-");
    }

    private static AffixCondition substringCondition(AffixKind kind, String stemCondition) {
        boolean forSuffix = kind == AffixKind.SUFFIX;
        int condLength = stemCondition.length();
        return (word, offset, length) -> {
            if (length < condLength) {
                return false;
            }
            int matchStart = forSuffix ? offset + length - condLength : offset;
            for (int i = 0; i < condLength; ++i) {
                if (stemCondition.charAt(i) == word[matchStart + i]) continue;
                return false;
            }
            return true;
        };
    }

    private static AffixCondition regexpCondition(AffixKind kind, String condition, int charCount) {
        boolean forSuffix = kind == AffixKind.SUFFIX;
        CharacterRunAutomaton automaton = new CharacterRunAutomaton(new RegExp(AffixCondition.escapeDash(condition), 0).toAutomaton());
        return (word, offset, length) -> length >= charCount && automaton.run(word, forSuffix ? offset + length - charCount : offset, charCount);
    }

    private static String escapeDash(String re) {
        if (!re.contains("-")) {
            return re;
        }
        StringBuilder escaped = new StringBuilder();
        for (int i = 0; i < re.length(); ++i) {
            char c = re.charAt(i);
            if (c == '-') {
                escaped.append("\\-");
                continue;
            }
            escaped.append(c);
            if (c != '\\' || i + 1 >= re.length()) continue;
            escaped.append(re.charAt(i + 1));
            ++i;
        }
        return escaped.toString();
    }
}

