/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.expr;

import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprEvalException;
import org.apache.jena.sparql.expr.ExprFunction2;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.expr.nodevalue.XSDFuncOp;
import org.apache.jena.sparql.function.FunctionEnv;

public class E_LogicalOr
extends ExprFunction2 {
    private static final String functionName = "or";
    private static final String symbol = "||";

    public E_LogicalOr(Expr left, Expr right) {
        super(left, right, functionName, symbol);
    }

    @Override
    public NodeValue evalSpecial(Binding binding, FunctionEnv env) {
        ExprEvalException error = null;
        try {
            NodeValue x = this.getArg1().eval(binding, env);
            if (XSDFuncOp.booleanEffectiveValue(x)) {
                return NodeValue.TRUE;
            }
        }
        catch (ExprEvalException eee) {
            error = eee;
        }
        try {
            NodeValue y = this.getArg2().eval(binding, env);
            if (XSDFuncOp.booleanEffectiveValue(y)) {
                return NodeValue.TRUE;
            }
            if (error != null) {
                throw error;
            }
            return NodeValue.FALSE;
        }
        catch (ExprEvalException eee) {
            if (error != null) {
                throw error;
            }
            throw eee;
        }
    }

    @Override
    public NodeValue eval(NodeValue x, NodeValue y) {
        if (!x.isBoolean()) {
            throw new ExprEvalException("Not a boolean: " + x);
        }
        if (!y.isBoolean()) {
            throw new ExprEvalException("Not a boolean: " + y);
        }
        boolean boolX = x.getBoolean();
        boolean boolY = y.getBoolean();
        return NodeValue.makeBoolean(boolX || boolY);
    }

    @Override
    public Expr copy(Expr e1, Expr e2) {
        return new E_LogicalOr(e1, e2);
    }
}

