/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot;

import org.apache.jena.query.ARQ;
import org.apache.jena.riot.IO_Jena;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.riot.RDFParserRegistry;
import org.apache.jena.riot.RDFWriterRegistry;
import org.apache.jena.riot.resultset.ResultSetLang;
import org.apache.jena.sparql.SystemARQ;
import org.apache.jena.sparql.mgt.SystemInfo;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.sparql.util.MappingRegistry;
import org.apache.jena.sparql.util.Symbol;
import org.apache.jena.sys.JenaSystem;

public class RIOT {
    private static volatile boolean initialized = false;
    private static Object initLock = new Object();
    public static final String riotIRI = "http://jena.apache.org/#riot";
    public static final String NAME = "RIOT";
    public static String VERSION;
    public static String BUILD_DATE;
    public static final String PATH = "org.apache.jena.riot";
    public static final Symbol multilineLiterals;
    private static Context systemGlobalContext;
    private static boolean registered;
    private static String TURTLE_SYMBOL_BASE;
    public static final Symbol symTurtleDirectiveStyle;
    public static final Symbol symTurtleOmitBase;

    public static Context getContext() {
        return systemGlobalContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init() {
        if (initialized) {
            return;
        }
        Object object = initLock;
        synchronized (object) {
            if (initialized) {
                JenaSystem.logLifecycle("RIOT.init - skip", new Object[0]);
                return;
            }
            initialized = true;
            JenaSystem.logLifecycle("RIOT.init - start", new Object[0]);
            if (systemGlobalContext == null) {
                JenaSystem.logLifecycle("RIOT.init - Warning: initializing systemGlobalContext in RIOT.init", new Object[0]);
                systemGlobalContext = new Context();
            }
            RIOT.setRIOTSettings();
            RDFLanguages.init();
            RDFParserRegistry.init();
            RDFWriterRegistry.init();
            ResultSetLang.init();
            MappingRegistry.addPrefixMapping("ttl", TURTLE_SYMBOL_BASE);
            MappingRegistry.addPrefixMapping("trig", TURTLE_SYMBOL_BASE);
            IO_Jena.wireIntoJena();
            JenaSystem.logLifecycle("RIOT.init - finish", new Object[0]);
        }
    }

    private static void setRIOTSettings() {
    }

    public static void register() {
        if (registered) {
            return;
        }
        registered = true;
        VERSION = RIOT.getVersion();
        BUILD_DATE = RIOT.getBuildDate();
        SystemInfo sysInfo2 = new SystemInfo(riotIRI, PATH, VERSION, BUILD_DATE);
        SystemARQ.registerSubSystem(sysInfo2);
    }

    public static String getVersion() {
        return ARQ.VERSION;
    }

    public static String getBuildDate() {
        return ARQ.BUILD_DATE;
    }

    static {
        multilineLiterals = Symbol.create("riot.multiline_literals");
        systemGlobalContext = new Context();
        registered = false;
        TURTLE_SYMBOL_BASE = "http://jena.apache.org/riot/turtle#";
        symTurtleDirectiveStyle = SystemARQ.allocSymbol(TURTLE_SYMBOL_BASE, "directiveStyle");
        symTurtleOmitBase = SystemARQ.allocSymbol(TURTLE_SYMBOL_BASE, "omitBase");
    }
}

