/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.rdfpatch.system;

import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.UUID;
import org.apache.jena.atlas.lib.Bytes;
import org.apache.jena.atlas.lib.InternalErrorException;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.rdf.model.impl.Util;
import org.apache.jena.rdfpatch.system.URNs;

public final class Id {
    private static final String SCHEME = "id:";
    private static final String nilStr = "00000000-0000-0000-0000-000000000000";
    private static final Id nilId = Id.fromUUID(UUID.fromString("00000000-0000-0000-0000-000000000000"));
    private final UUID uuid;
    private final String string;

    public static int lenStrUUID() {
        return nilStr.length();
    }

    public static boolean maybeUUID(String str2) {
        return str2.length() == nilStr.length() && str2.charAt(8) == '-';
    }

    public static Id nullId() {
        return nilId;
    }

    public static Id create() {
        return new Id(URNs.genUUID());
    }

    public static Id fromBytes(byte[] bytes) {
        if (bytes.length == 16) {
            long mostSig = Bytes.getLong(bytes, 0);
            long leastSig = Bytes.getLong(bytes, 8);
            UUID uuid2 = new UUID(mostSig, leastSig);
            return Id.fromUUID(uuid2);
        }
        String str2 = new String(bytes, StandardCharsets.UTF_8);
        return new Id(str2);
    }

    public static String str(Node node) {
        if (node == null) {
            return "<null>";
        }
        return Id.fromNode(node).toString();
    }

    public static Id fromNode(Node node) {
        if (node == null) {
            return null;
        }
        String s = null;
        if (node.isURI()) {
            s = node.getURI();
        } else if (Util.isSimpleString(node)) {
            s = node.getLiteralLexicalForm();
        }
        if (s == null) {
            throw new IllegalArgumentException("Id input is not a URI or a string");
        }
        return Id.fromString$(s);
    }

    public static Id fromUUID(UUID uuid2) {
        return new Id(uuid2);
    }

    private static Id fromString$(String str2) {
        if (str2.startsWith("uuid:")) {
            str2 = str2.substring("uuid:".length());
        } else if (str2.startsWith("urn:uuid:")) {
            str2 = str2.substring("urn:uuid:".length());
        }
        return Id.fromString(str2);
    }

    public static Id fromStringOrNull(String str2) {
        return str2 == null ? null : Id.fromString(str2);
    }

    public static Id fromString(String str2) {
        Objects.requireNonNull(str2);
        switch (str2) {
            case "00000000-0000-0000-0000-000000000000": 
            case "id:nil": {
                return Id.nullId();
            }
        }
        if (str2.startsWith(SCHEME)) {
            str2 = str2.substring(SCHEME.length());
        }
        try {
            UUID uuid2 = UUID.fromString(str2);
            return new Id(uuid2);
        }
        catch (IllegalArgumentException ex) {
            throw new IllegalArgumentException("String for id does not match a UUID: '" + str2 + "'");
        }
    }

    public static UUID parseUUID(String patchStr, UUID dft) {
        try {
            return UUID.fromString(patchStr);
        }
        catch (IllegalArgumentException ex) {
            return dft;
        }
    }

    public static Id parseId(String uuidStr, Id dft) {
        try {
            return Id.fromUUID(UUID.fromString(uuidStr));
        }
        catch (IllegalArgumentException ex) {
            return dft;
        }
    }

    private Id(UUID id) {
        this.uuid = Objects.requireNonNull(id);
        this.string = null;
    }

    private Id(String id) {
        this.uuid = null;
        this.string = Objects.requireNonNull(id);
    }

    public boolean isNil() {
        return this.equals(nilId);
    }

    public String asParam() {
        if (this.uuid != null) {
            return this.uuid.toString();
        }
        return this.string;
    }

    public byte[] asBytes() {
        if (this.uuid != null) {
            byte[] bytes = new byte[16];
            Bytes.setLong(this.uuid.getMostSignificantBits(), bytes, 0);
            Bytes.setLong(this.uuid.getLeastSignificantBits(), bytes, 8);
            return bytes;
        }
        return this.string.getBytes(StandardCharsets.UTF_8);
    }

    public String asPlainString() {
        if (this.uuid != null) {
            return this.uuid.toString();
        }
        if (this.string != null) {
            return this.string;
        }
        throw new InternalErrorException("Id has null UUID and string");
    }

    public String asString() {
        if (this.uuid != null) {
            return SCHEME + this.uuid.toString();
        }
        if (this.string != null) {
            return this.string;
        }
        throw new InternalErrorException("Id has null UUID and null string");
    }

    public Node asNode() {
        if (this.uuid != null) {
            return NodeFactory.createURI("uuid:" + this.uuid.toString());
        }
        return NodeFactory.createLiteral(this.string);
    }

    public String toString() {
        return this.toSchemeString(SCHEME);
    }

    public String toSchemeString(String scheme) {
        if (this == nilId) {
            return "id:nil";
        }
        if (this.uuid != null) {
            return scheme + Id.shortUUIDstr(this.uuid);
        }
        return scheme + "\"" + this.string + "\"";
    }

    public static String shortUUIDstr(UUID uuid2) {
        String str2 = uuid2.toString();
        int version2 = uuid2.version();
        if (version2 == 1) {
            return uuid2.toString().substring(0, 6);
        }
        if (version2 == 4) {
            return uuid2.toString().substring(0, 6);
        }
        return uuid2.toString().substring(0, 8);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.string == null ? 0 : this.string.hashCode());
        result = 31 * result + (this.uuid == null ? 0 : this.uuid.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Id other = (Id)obj;
        if (this.string == null ? other.string != null : !this.string.equals(other.string)) {
            return false;
        }
        return !(this.uuid == null ? other.uuid != null : !this.uuid.equals(other.uuid));
    }
}

