/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.server;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.StringJoiner;
import org.apache.jena.atlas.lib.DateTimeUtils;
import org.apache.jena.atlas.logging.FmtLog;
import org.apache.jena.fuseki.Fuseki;
import org.apache.jena.fuseki.auth.AuthPolicy;
import org.apache.jena.fuseki.server.DataAccessPoint;
import org.apache.jena.fuseki.server.DataAccessPointRegistry;
import org.apache.jena.fuseki.server.DataService;
import org.apache.jena.fuseki.server.Operation;
import org.apache.jena.fuseki.server.PlatformInfo;
import org.slf4j.Logger;

public class FusekiCoreInfo {
    static List<Operation> stdOperations = Arrays.asList(Operation.Query, Operation.Update, Operation.GSP_RW, Operation.GSP_R);

    public static void logCode(Logger log2) {
        String version2 = Fuseki.VERSION;
        String buildDate = Fuseki.BUILD_DATE;
        String serverName = "Apache Jena Fuseki";
        if (version2 != null && version2.equals("${project.version}")) {
            version2 = null;
        }
        if (buildDate != null && buildDate.equals("${build.time.xsd}")) {
            buildDate = DateTimeUtils.nowAsXSDDateTimeString();
        }
        if (version2 != null) {
            if (Fuseki.developmentMode && buildDate != null) {
                FmtLog.info(log2, "%s %s %s", serverName, version2, buildDate);
            } else {
                FmtLog.info(log2, "%s %s", serverName, version2);
            }
        }
    }

    public static void logServerCmdSetup(Logger log2, boolean verbose, DataAccessPointRegistry dapRegistry, String datasetPath, String datasetDescription, String serverConfigFile, String staticFiles) {
        if (datasetPath != null) {
            FmtLog.info(log2, "Database: %s", datasetDescription);
        }
        if (serverConfigFile != null) {
            FmtLog.info(log2, "Configuration file: %s", serverConfigFile);
        }
        FusekiCoreInfo.logDataAccessPointRegistry(log2, dapRegistry, verbose);
        if (staticFiles != null) {
            FmtLog.info(log2, "Static files: %s", staticFiles);
        }
        if (verbose) {
            PlatformInfo.logDetailsSystem(log2);
            PlatformInfo.logDetailsJVM(log2);
        } else {
            PlatformInfo.logDetailsSystemPlain(log2);
        }
    }

    public static void logDataAccessPointRegistry(Logger log2, DataAccessPointRegistry dapRegistry, boolean longForm) {
        if (longForm) {
            FusekiCoreInfo.infoPathsOperations(log2, dapRegistry);
        } else {
            FusekiCoreInfo.infoPaths(log2, dapRegistry);
        }
    }

    private static void infoPaths(Logger log2, DataAccessPointRegistry reg) {
        reg.keys().stream().sorted().forEach(datasetPath -> log2.info("Path = " + datasetPath));
    }

    private static void infoPathsOperations(Logger log2, DataAccessPointRegistry reg) {
        reg.keys().stream().sorted().forEach(datasetPath -> {
            log2.info("Path = " + datasetPath);
            DataAccessPoint dap = reg.get((String)datasetPath);
            FusekiCoreInfo.logDataAccessPoint(log2, dap);
        });
    }

    public static void logDataAccessPoint(Logger log2, DataAccessPoint dap) {
        FusekiCoreInfo.operations(dap.getDataService()).forEach(operation -> {
            StringBuilder sb = new StringBuilder();
            sb.append(String.format("  Operation = %-6s", operation.getName()));
            sb.append("  Endpoints = ");
            StringJoiner sj = new StringJoiner(", ", "[ ", " ]");
            dap.getDataService().getEndpoints((Operation)operation).stream().map(ep -> "\"" + ep.getName() + "\"").sorted().forEach(sj::add);
            sb.append(sj.toString());
            FmtLog.info(log2, sb.toString(), new Object[0]);
        });
    }

    private static List<Operation> operations(DataService dataService) {
        Collection<Operation> registered = dataService.getOperations();
        ArrayList<Operation> nice = new ArrayList<Operation>();
        for (Operation operation : stdOperations) {
            if (!registered.contains(operation)) continue;
            nice.add(operation);
        }
        ArrayList<Operation> others = new ArrayList<Operation>();
        for (Operation op : registered) {
            if (nice.contains(op)) continue;
            others.add(op);
        }
        Comparator comparator = (o1, o2) -> o1.getName().compareTo(o2.getName());
        others.stream().sorted(comparator).forEach(nice::add);
        return nice;
    }

    private static /* synthetic */ String lambda$logDataAccessPoint$3(AuthPolicy auth) {
        return auth == null ? "*" : auth.toString();
    }
}

