/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.observation;

import io.micrometer.observation.Observation;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public interface ObservationHandler<T extends Observation.Context> {
    default public void onStart(T context2) {
    }

    default public void onError(T context2) {
    }

    default public void onEvent(Observation.Event event, T context2) {
    }

    default public void onScopeOpened(T context2) {
    }

    default public void onScopeClosed(T context2) {
    }

    default public void onStop(T context2) {
    }

    public boolean supportsContext(Observation.Context var1);

    public static class AllMatchingCompositeObservationHandler
    implements CompositeObservationHandler {
        private final List<ObservationHandler<Observation.Context>> handlers;

        @SafeVarargs
        public AllMatchingCompositeObservationHandler(ObservationHandler<? extends Observation.Context> ... handlers) {
            this(Arrays.asList(handlers));
        }

        public AllMatchingCompositeObservationHandler(List<? extends ObservationHandler<? extends Observation.Context>> handlers) {
            this.handlers = handlers.stream().map(handler -> handler).collect(Collectors.toList());
        }

        @Override
        public List<ObservationHandler<Observation.Context>> getHandlers() {
            return this.handlers;
        }

        @Override
        public void onStart(Observation.Context context2) {
            this.getAllApplicableHandlers(context2).forEach(handler -> handler.onStart(context2));
        }

        @Override
        public void onError(Observation.Context context2) {
            this.getAllApplicableHandlers(context2).forEach(handler -> handler.onError(context2));
        }

        @Override
        public void onEvent(Observation.Event event, Observation.Context context2) {
            this.getAllApplicableHandlers(context2).forEach(handler -> handler.onEvent(event, context2));
        }

        @Override
        public void onScopeOpened(Observation.Context context2) {
            this.getAllApplicableHandlers(context2).forEach(handler -> handler.onScopeOpened(context2));
        }

        @Override
        public void onScopeClosed(Observation.Context context2) {
            this.getAllApplicableHandlers(context2).forEach(handler -> handler.onScopeClosed(context2));
        }

        @Override
        public void onStop(Observation.Context context2) {
            this.getAllApplicableHandlers(context2).forEach(handler -> handler.onStop(context2));
        }

        @Override
        public boolean supportsContext(Observation.Context context2) {
            return this.getAllApplicableHandlers(context2).findAny().isPresent();
        }

        private Stream<ObservationHandler<Observation.Context>> getAllApplicableHandlers(Observation.Context context2) {
            return this.handlers.stream().filter(handler -> handler.supportsContext(context2));
        }
    }

    public static class FirstMatchingCompositeObservationHandler
    implements CompositeObservationHandler {
        private final List<ObservationHandler<Observation.Context>> handlers;

        @SafeVarargs
        public FirstMatchingCompositeObservationHandler(ObservationHandler<? extends Observation.Context> ... handlers) {
            this(Arrays.asList(handlers));
        }

        public FirstMatchingCompositeObservationHandler(List<? extends ObservationHandler<? extends Observation.Context>> handlers) {
            this.handlers = handlers.stream().map(handler -> handler).collect(Collectors.toList());
        }

        @Override
        public List<ObservationHandler<Observation.Context>> getHandlers() {
            return this.handlers;
        }

        @Override
        public void onStart(Observation.Context context2) {
            this.getFirstApplicableHandler(context2).ifPresent(handler -> handler.onStart(context2));
        }

        @Override
        public void onError(Observation.Context context2) {
            this.getFirstApplicableHandler(context2).ifPresent(handler -> handler.onError(context2));
        }

        @Override
        public void onEvent(Observation.Event event, Observation.Context context2) {
            this.getFirstApplicableHandler(context2).ifPresent(handler -> handler.onEvent(event, context2));
        }

        @Override
        public void onScopeOpened(Observation.Context context2) {
            this.getFirstApplicableHandler(context2).ifPresent(handler -> handler.onScopeOpened(context2));
        }

        @Override
        public void onScopeClosed(Observation.Context context2) {
            this.getFirstApplicableHandler(context2).ifPresent(handler -> handler.onScopeClosed(context2));
        }

        @Override
        public void onStop(Observation.Context context2) {
            this.getFirstApplicableHandler(context2).ifPresent(handler -> handler.onStop(context2));
        }

        @Override
        public boolean supportsContext(Observation.Context context2) {
            return this.getFirstApplicableHandler(context2).isPresent();
        }

        private Optional<ObservationHandler<Observation.Context>> getFirstApplicableHandler(Observation.Context context2) {
            return this.handlers.stream().filter(handler -> handler.supportsContext(context2)).findFirst();
        }
    }

    public static interface CompositeObservationHandler
    extends ObservationHandler<Observation.Context> {
        public List<ObservationHandler<Observation.Context>> getHandlers();
    }
}

