/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.core.io.doubleparser;

import com.fasterxml.jackson.core.io.doubleparser.FloatBitsFromCharArray;
import com.fasterxml.jackson.core.io.doubleparser.FloatBitsFromCharSequence;

public class FastFloatParser {
    private FastFloatParser() {
    }

    public static float parseFloat(CharSequence str2) throws NumberFormatException {
        return FastFloatParser.parseFloat(str2, 0, str2.length());
    }

    public static float parseFloat(CharSequence str2, int offset, int length) throws NumberFormatException {
        long bitPattern = new FloatBitsFromCharSequence().parseFloatingPointLiteral(str2, offset, length);
        if (bitPattern == -1L) {
            throw new NumberFormatException("Illegal input");
        }
        return Float.intBitsToFloat((int)bitPattern);
    }

    public static float parseFloat(char[] str2) throws NumberFormatException {
        return FastFloatParser.parseFloat(str2, 0, str2.length);
    }

    public static float parseFloat(char[] str2, int offset, int length) throws NumberFormatException {
        long bitPattern = new FloatBitsFromCharArray().parseFloatingPointLiteral(str2, offset, length);
        if (bitPattern == -1L) {
            throw new NumberFormatException("Illegal input");
        }
        return Float.intBitsToFloat((int)bitPattern);
    }

    public static long parseFloatBits(CharSequence str2, int offset, int length) {
        return new FloatBitsFromCharSequence().parseFloatingPointLiteral(str2, offset, length);
    }

    public static long parseFloatBits(char[] str2, int offset, int length) {
        return new FloatBitsFromCharArray().parseFloatingPointLiteral(str2, offset, length);
    }
}

