/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.geo;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.geo.GeoEncodingUtils;
import org.apache.lucene.geo.GeoUtils;
import org.apache.lucene.geo.Geometry;
import org.apache.lucene.geo.Point;
import org.apache.lucene.geo.Polygon;
import org.apache.lucene.geo.Rectangle;
import org.apache.lucene.geo.XYEncodingUtils;
import org.apache.lucene.geo.XYPolygon;
import org.apache.lucene.util.BitUtil;

public final class Tessellator {
    private static final int VERTEX_THRESHOLD = 80;

    private Tessellator() {
    }

    public static List<Triangle> tessellate(Polygon polygon, boolean checkSelfIntersections) {
        return Tessellator.tessellate(polygon, checkSelfIntersections, null);
    }

    public static List<Triangle> tessellate(Polygon polygon, boolean checkSelfIntersections, Monitor monitor) {
        List<Triangle> result;
        boolean mortonOptimized;
        Node outerNode = Tessellator.createDoublyLinkedList(polygon.getPolyLons(), polygon.getPolyLats(), polygon.getWindingOrder(), true, 0, GeoUtils.WindingOrder.CW);
        if (outerNode == null) {
            throw new IllegalArgumentException("Malformed shape detected in Tessellator!");
        }
        if (outerNode == outerNode.next || outerNode == outerNode.next.next) {
            throw new IllegalArgumentException("at least three non-collinear points required");
        }
        if (polygon.numHoles() > 0) {
            outerNode = Tessellator.eliminateHoles(polygon, outerNode);
        }
        int threshold = 80 - polygon.numPoints();
        for (int i = 0; threshold >= 0 && i < polygon.numHoles(); threshold -= polygon.getHole(i).numPoints(), ++i) {
        }
        boolean bl = mortonOptimized = threshold < 0;
        if (mortonOptimized) {
            Tessellator.sortByMorton(outerNode);
        }
        if (checkSelfIntersections) {
            Tessellator.checkIntersection(outerNode, mortonOptimized);
        }
        if ((result = Tessellator.earcutLinkedList(polygon, outerNode, new ArrayList<Triangle>(), State.INIT, mortonOptimized, monitor, 0)).size() == 0) {
            Tessellator.notifyMonitor("FAILED", monitor, null, result);
            throw new IllegalArgumentException("Unable to Tessellate shape. Possible malformed shape detected.");
        }
        Tessellator.notifyMonitor("COMPLETED", monitor, null, result);
        return result;
    }

    public static List<Triangle> tessellate(XYPolygon polygon, boolean checkSelfIntersections) {
        return Tessellator.tessellate(polygon, checkSelfIntersections, null);
    }

    public static List<Triangle> tessellate(XYPolygon polygon, boolean checkSelfIntersections, Monitor monitor) {
        List<Triangle> result;
        boolean mortonOptimized;
        Node outerNode = Tessellator.createDoublyLinkedList(XYEncodingUtils.floatArrayToDoubleArray(polygon.getPolyX()), XYEncodingUtils.floatArrayToDoubleArray(polygon.getPolyY()), polygon.getWindingOrder(), false, 0, GeoUtils.WindingOrder.CW);
        if (outerNode == null) {
            throw new IllegalArgumentException("Malformed shape detected in Tessellator!");
        }
        if (outerNode == outerNode.next || outerNode == outerNode.next.next) {
            throw new IllegalArgumentException("at least three non-collinear points required");
        }
        if (polygon.numHoles() > 0) {
            outerNode = Tessellator.eliminateHoles(polygon, outerNode);
        }
        int threshold = 80 - polygon.numPoints();
        for (int i = 0; threshold >= 0 && i < polygon.numHoles(); threshold -= polygon.getHole(i).numPoints(), ++i) {
        }
        boolean bl = mortonOptimized = threshold < 0;
        if (mortonOptimized) {
            Tessellator.sortByMorton(outerNode);
        }
        if (checkSelfIntersections) {
            Tessellator.checkIntersection(outerNode, mortonOptimized);
        }
        if ((result = Tessellator.earcutLinkedList(polygon, outerNode, new ArrayList<Triangle>(), State.INIT, mortonOptimized, monitor, 0)).size() == 0) {
            Tessellator.notifyMonitor("FAILED", monitor, null, result);
            throw new IllegalArgumentException("Unable to Tessellate shape. Possible malformed shape detected.");
        }
        Tessellator.notifyMonitor("COMPLETED", monitor, null, result);
        return result;
    }

    private static final Node createDoublyLinkedList(double[] x, double[] y, GeoUtils.WindingOrder polyWindingOrder, boolean isGeo, int startIndex, GeoUtils.WindingOrder windingOrder) {
        Node lastNode = null;
        if (windingOrder == polyWindingOrder) {
            for (int i = 0; i < x.length; ++i) {
                lastNode = Tessellator.insertNode(x, y, startIndex++, i, lastNode, isGeo);
            }
        } else {
            for (int i = x.length - 1; i >= 0; --i) {
                lastNode = Tessellator.insertNode(x, y, startIndex++, i, lastNode, isGeo);
            }
        }
        if (lastNode != null && Tessellator.isVertexEquals(lastNode, lastNode.next)) {
            Tessellator.removeNode(lastNode, true);
            lastNode = lastNode.next;
        }
        return Tessellator.filterPoints(lastNode, null);
    }

    private static final Node eliminateHoles(XYPolygon polygon, Node outerNode) {
        ArrayList<Node> holeList = new ArrayList<Node>();
        HashMap<Node, XYPolygon> holeListPolygons = new HashMap<Node, XYPolygon>();
        XYPolygon[] holes = polygon.getHoles();
        int nodeIndex = polygon.numPoints();
        for (int i = 0; i < polygon.numHoles(); ++i) {
            Node list = Tessellator.createDoublyLinkedList(XYEncodingUtils.floatArrayToDoubleArray(holes[i].getPolyX()), XYEncodingUtils.floatArrayToDoubleArray(holes[i].getPolyY()), holes[i].getWindingOrder(), false, nodeIndex, GeoUtils.WindingOrder.CCW);
            if (list != null) {
                Node leftMost = Tessellator.fetchLeftmost(list);
                holeList.add(leftMost);
                holeListPolygons.put(leftMost, holes[i]);
            }
            nodeIndex += holes[i].numPoints();
        }
        return Tessellator.eliminateHoles(holeList, holeListPolygons, outerNode);
    }

    private static final Node eliminateHoles(Polygon polygon, Node outerNode) {
        ArrayList<Node> holeList = new ArrayList<Node>();
        HashMap<Node, Polygon> holeListPolygons = new HashMap<Node, Polygon>();
        Polygon[] holes = polygon.getHoles();
        int nodeIndex = polygon.numPoints();
        for (int i = 0; i < polygon.numHoles(); ++i) {
            Node list = Tessellator.createDoublyLinkedList(holes[i].getPolyLons(), holes[i].getPolyLats(), holes[i].getWindingOrder(), true, nodeIndex, GeoUtils.WindingOrder.CCW);
            if (list == list.next) {
                throw new IllegalArgumentException("Points are all coplanar in hole: " + holes[i]);
            }
            Node leftMost = Tessellator.fetchLeftmost(list);
            holeList.add(leftMost);
            holeListPolygons.put(leftMost, holes[i]);
            nodeIndex += holes[i].numPoints();
        }
        return Tessellator.eliminateHoles(holeList, holeListPolygons, outerNode);
    }

    private static final Node eliminateHoles(List<Node> holeList, Map<Node, ?> holeListPolygons, Node outerNode) {
        holeList.sort((pNodeA, pNodeB) -> {
            double diff = pNodeA.getX() - pNodeB.getX();
            if (diff == 0.0 && (diff = pNodeA.getY() - pNodeB.getY()) == 0.0) {
                double a = Math.min(pNodeA.previous.getY(), pNodeA.next.getY());
                double b = Math.min(pNodeB.previous.getY(), pNodeB.next.getY());
                diff = a - b;
            }
            return diff < 0.0 ? -1 : (diff > 0.0 ? 1 : 0);
        });
        for (int i = 0; i < holeList.size(); ++i) {
            double holeMaxY;
            double holeMinY;
            double holeMaxX;
            double holeMinX;
            Geometry holePoly;
            Node holeNode = holeList.get(i);
            Object h = holeListPolygons.get(holeNode);
            if (h instanceof Polygon) {
                holePoly = (Polygon)h;
                holeMinX = holePoly.minLon;
                holeMaxX = holePoly.maxLon;
                holeMinY = holePoly.minLat;
                holeMaxY = holePoly.maxLat;
            } else {
                holePoly = (XYPolygon)h;
                holeMinX = ((XYPolygon)holePoly).minX;
                holeMaxX = ((XYPolygon)holePoly).maxX;
                holeMinY = ((XYPolygon)holePoly).minY;
                holeMaxY = ((XYPolygon)holePoly).maxY;
            }
            Tessellator.eliminateHole(holeNode, outerNode, holeMinX, holeMaxX, holeMinY, holeMaxY);
            outerNode = Tessellator.filterPoints(outerNode, outerNode.next);
        }
        return outerNode;
    }

    private static final void eliminateHole(Node holeNode, Node outerNode, double holeMinX, double holeMaxX, double holeMinY, double holeMaxY) {
        Node next = outerNode;
        do {
            Node sharedVertex;
            if (!Rectangle.containsPoint(next.getY(), next.getX(), holeMinY, holeMaxY, holeMinX, holeMaxX) || (sharedVertex = Tessellator.getSharedVertex(holeNode, next)) == null) continue;
            Node node = Tessellator.splitPolygon(next, sharedVertex, true);
            Tessellator.filterPoints(node, node.next);
            return;
        } while ((next = next.next) != outerNode);
        if ((outerNode = Tessellator.fetchHoleBridge(holeNode, outerNode)) != null) {
            boolean fromPolygon = Tessellator.isPointInLine(outerNode, outerNode.next, holeNode) || Tessellator.isPointInLine(holeNode, holeNode.next, outerNode);
            Node node = Tessellator.splitPolygon(outerNode, holeNode, fromPolygon);
            Tessellator.filterPoints(node, node.next);
        }
    }

    private static final Node fetchHoleBridge(Node holeNode, Node outerNode) {
        Node p = outerNode;
        double qx = Double.NEGATIVE_INFINITY;
        double hx = holeNode.getX();
        double hy = holeNode.getY();
        Node connection = null;
        do {
            double x;
            if (!(hy <= p.getY()) || !(hy >= p.next.getY()) || p.next.getY() == p.getY() || !((x = p.getX() + (hy - p.getY()) * (p.next.getX() - p.getX()) / (p.next.getY() - p.getY())) <= hx) || !(x > qx)) continue;
            qx = x;
            if (x == hx) {
                if (hy == p.getY()) {
                    return p;
                }
                if (hy == p.next.getY()) {
                    return p.next;
                }
            }
            Node node = connection = p.getX() < p.next.getX() ? p : p.next;
        } while ((p = p.next) != outerNode);
        if (connection == null) {
            return null;
        }
        if (hx == qx) {
            return connection.previous;
        }
        Node stop = connection;
        double mx = connection.getX();
        double my = connection.getY();
        double tanMin = Double.POSITIVE_INFINITY;
        p = connection.next;
        while (p != stop) {
            if (hx >= p.getX() && p.getX() >= mx && hx != p.getX() && Tessellator.pointInEar(p.getX(), p.getY(), hy < my ? hx : qx, hy, mx, my, hy < my ? qx : hx, hy)) {
                double tan2 = Math.abs(hy - p.getY()) / (hx - p.getX());
                if (Tessellator.isVertexEquals(p, connection) && Tessellator.isLocallyInside(p, holeNode)) {
                    boolean crosses = GeoUtils.lineCrossesLine(p.getX(), p.getY(), holeNode.getX(), holeNode.getY(), connection.next.getX(), connection.next.getY(), connection.previous.getX(), connection.previous.getY());
                    if (!crosses) {
                        connection = p;
                        tanMin = tan2;
                    }
                } else if ((tan2 < tanMin || tan2 == tanMin && p.getX() > connection.getX()) && Tessellator.isLocallyInside(p, holeNode)) {
                    connection = p;
                    tanMin = tan2;
                }
            }
            p = p.next;
        }
        return connection;
    }

    private static Node getSharedVertex(Node polygon, Node vertex) {
        Node next = polygon;
        do {
            boolean crosses;
            if (!Tessellator.isVertexEquals(next, vertex) || (crosses = GeoUtils.lineCrossesLine(next.previous.getX(), next.previous.getY(), vertex.next.getX(), vertex.next.getY(), next.next.getX(), next.next.getY(), vertex.previous.getX(), vertex.previous.getY()))) continue;
            return next;
        } while ((next = next.next) != polygon);
        return null;
    }

    private static final Node fetchLeftmost(Node start) {
        Node node = start;
        Node leftMost = start;
        do {
            if (!(node.getX() < leftMost.getX()) && (node.getX() != leftMost.getX() || !(node.getY() < leftMost.getY()))) continue;
            leftMost = node;
        } while ((node = node.next) != start);
        return leftMost;
    }

    private static final List<Triangle> earcutLinkedList(Object polygon, Node currEar, List<Triangle> tessellation, State state, boolean mortonOptimized, Monitor monitor, int depth) {
        block9: {
            block5: while (true) {
                if (currEar == null || currEar.previous == currEar.next) {
                    return tessellation;
                }
                Node stop = currEar;
                do {
                    boolean isReflex;
                    Tessellator.notifyMonitor(state, depth, monitor, currEar, tessellation);
                    Node prevNode = currEar.previous;
                    Node nextNode = currEar.next;
                    boolean bl = isReflex = Tessellator.area(prevNode.getX(), prevNode.getY(), currEar.getX(), currEar.getY(), nextNode.getX(), nextNode.getY()) >= 0.0;
                    if (!isReflex && Tessellator.isEar(currEar, mortonOptimized)) {
                        boolean abFromPolygon = prevNode.isNextEdgeFromPolygon;
                        boolean bcFromPolygon = currEar.isNextEdgeFromPolygon;
                        boolean caFromPolygon = Tessellator.isEdgeFromPolygon(prevNode, nextNode, mortonOptimized);
                        tessellation.add(new Triangle(prevNode, abFromPolygon, currEar, bcFromPolygon, nextNode, caFromPolygon));
                        Tessellator.removeNode(currEar, caFromPolygon);
                        currEar = nextNode.next;
                        stop = nextNode.next;
                        continue;
                    }
                    currEar = nextNode;
                    if (currEar != stop) continue;
                    switch (state) {
                        case INIT: {
                            currEar = Tessellator.filterPoints(currEar, null);
                            state = State.CURE;
                            continue block5;
                        }
                        case CURE: {
                            currEar = Tessellator.cureLocalIntersections(currEar, tessellation, mortonOptimized);
                            state = State.SPLIT;
                            continue block5;
                        }
                        case SPLIT: {
                            if (Tessellator.splitEarcut(polygon, currEar, tessellation, mortonOptimized, monitor, depth + 1)) break;
                            Tessellator.notifyMonitor(state.name() + "[FAILED]", monitor, currEar, tessellation);
                            throw new IllegalArgumentException("Unable to Tessellate shape. Possible malformed shape detected.");
                        }
                    }
                    break block9;
                } while (currEar.previous != currEar.next);
                break;
            }
        }
        return tessellation;
    }

    private static final boolean isEar(Node ear, boolean mortonOptimized) {
        if (mortonOptimized) {
            return Tessellator.mortonIsEar(ear);
        }
        Node node = ear.next.next;
        while (node != ear.previous) {
            if (Tessellator.pointInEar(node.getX(), node.getY(), ear.previous.getX(), ear.previous.getY(), ear.getX(), ear.getY(), ear.next.getX(), ear.next.getY()) && Tessellator.area(node.previous.getX(), node.previous.getY(), node.getX(), node.getY(), node.next.getX(), node.next.getY()) >= 0.0) {
                return false;
            }
            node = node.next;
        }
        return true;
    }

    private static final boolean mortonIsEar(Node ear) {
        int minTX = StrictMath.min(StrictMath.min(ear.previous.x, ear.x), ear.next.x) ^ Integer.MIN_VALUE;
        int minTY = StrictMath.min(StrictMath.min(ear.previous.y, ear.y), ear.next.y) ^ Integer.MIN_VALUE;
        int maxTX = StrictMath.max(StrictMath.max(ear.previous.x, ear.x), ear.next.x) ^ Integer.MIN_VALUE;
        int maxTY = StrictMath.max(StrictMath.max(ear.previous.y, ear.y), ear.next.y) ^ Integer.MIN_VALUE;
        long minZ = BitUtil.interleave(minTX, minTY);
        long maxZ = BitUtil.interleave(maxTX, maxTY);
        Node p = ear.previousZ;
        Node n = ear.nextZ;
        while (p != null && Long.compareUnsigned(p.morton, minZ) >= 0 && n != null && Long.compareUnsigned(n.morton, maxZ) <= 0) {
            if (p.idx != ear.previous.idx && p.idx != ear.next.idx && Tessellator.pointInEar(p.getX(), p.getY(), ear.previous.getX(), ear.previous.getY(), ear.getX(), ear.getY(), ear.next.getX(), ear.next.getY()) && Tessellator.area(p.previous.getX(), p.previous.getY(), p.getX(), p.getY(), p.next.getX(), p.next.getY()) >= 0.0) {
                return false;
            }
            p = p.previousZ;
            if (n.idx != ear.previous.idx && n.idx != ear.next.idx && Tessellator.pointInEar(n.getX(), n.getY(), ear.previous.getX(), ear.previous.getY(), ear.getX(), ear.getY(), ear.next.getX(), ear.next.getY()) && Tessellator.area(n.previous.getX(), n.previous.getY(), n.getX(), n.getY(), n.next.getX(), n.next.getY()) >= 0.0) {
                return false;
            }
            n = n.nextZ;
        }
        while (p != null && Long.compareUnsigned(p.morton, minZ) >= 0) {
            if (p.idx != ear.previous.idx && p.idx != ear.next.idx && Tessellator.pointInEar(p.getX(), p.getY(), ear.previous.getX(), ear.previous.getY(), ear.getX(), ear.getY(), ear.next.getX(), ear.next.getY()) && Tessellator.area(p.previous.getX(), p.previous.getY(), p.getX(), p.getY(), p.next.getX(), p.next.getY()) >= 0.0) {
                return false;
            }
            p = p.previousZ;
        }
        while (n != null && Long.compareUnsigned(n.morton, maxZ) <= 0) {
            if (n.idx != ear.previous.idx && n.idx != ear.next.idx && Tessellator.pointInEar(n.getX(), n.getY(), ear.previous.getX(), ear.previous.getY(), ear.getX(), ear.getY(), ear.next.getX(), ear.next.getY()) && Tessellator.area(n.previous.getX(), n.previous.getY(), n.getX(), n.getY(), n.next.getX(), n.next.getY()) >= 0.0) {
                return false;
            }
            n = n.nextZ;
        }
        return true;
    }

    private static final Node cureLocalIntersections(Node startNode, List<Triangle> tessellation, boolean mortonOptimized) {
        Node node = startNode;
        do {
            Node nextNode = node.next;
            Node a = node.previous;
            Node b = nextNode.next;
            if (Tessellator.isVertexEquals(a, b) || Tessellator.isIntersectingPolygon(a, a.getX(), a.getY(), b.getX(), b.getY()) || !Tessellator.linesIntersect(a.getX(), a.getY(), node.getX(), node.getY(), nextNode.getX(), nextNode.getY(), b.getX(), b.getY()) || !Tessellator.isLocallyInside(a, b) || !Tessellator.isLocallyInside(b, a)) continue;
            boolean abFromPolygon = a.next == node ? a.isNextEdgeFromPolygon : Tessellator.isEdgeFromPolygon(a, node, mortonOptimized);
            boolean bcFromPolygon = node.next == b ? node.isNextEdgeFromPolygon : Tessellator.isEdgeFromPolygon(node, b, mortonOptimized);
            boolean caFromPolygon = b.next == a ? b.isNextEdgeFromPolygon : Tessellator.isEdgeFromPolygon(a, b, mortonOptimized);
            tessellation.add(new Triangle(a, abFromPolygon, node, bcFromPolygon, b, caFromPolygon));
            tessellation.add(new Triangle(a, abFromPolygon, node, bcFromPolygon, b, caFromPolygon));
            Tessellator.removeNode(node, caFromPolygon);
            Tessellator.removeNode(node.next, caFromPolygon);
            node = startNode = b;
        } while ((node = node.next) != startNode);
        return node;
    }

    private static final boolean splitEarcut(Object polygon, Node start, List<Triangle> tessellation, boolean mortonOptimized, Monitor monitor, int depth) {
        Node searchNode = start;
        do {
            Node nextNode = searchNode.next;
            Node diagonal = nextNode.next;
            while (diagonal != searchNode.previous) {
                if (searchNode.idx != diagonal.idx && Tessellator.isValidDiagonal(searchNode, diagonal)) {
                    Node splitNode = Tessellator.splitPolygon(searchNode, diagonal, Tessellator.isEdgeFromPolygon(searchNode, diagonal, mortonOptimized));
                    searchNode = Tessellator.filterPoints(searchNode, searchNode.next);
                    splitNode = Tessellator.filterPoints(splitNode, splitNode.next);
                    if (mortonOptimized) {
                        Tessellator.sortByMortonWithReset(searchNode);
                        Tessellator.sortByMortonWithReset(splitNode);
                    }
                    Tessellator.notifyMonitorSplit(depth, monitor, searchNode, splitNode);
                    Tessellator.earcutLinkedList(polygon, searchNode, tessellation, State.INIT, mortonOptimized, monitor, depth);
                    Tessellator.earcutLinkedList(polygon, splitNode, tessellation, State.INIT, mortonOptimized, monitor, depth);
                    Tessellator.notifyMonitorSplitEnd(depth, monitor);
                    return true;
                }
                diagonal = diagonal.next;
            }
        } while ((searchNode = searchNode.next) != start);
        return Tessellator.signedArea(start, start) == 0.0;
    }

    private static void checkIntersection(Node a, boolean isMorton) {
        Node next = a.next;
        do {
            Node innerNext = next.next;
            if (isMorton) {
                Tessellator.mortonCheckIntersection(next, innerNext);
                continue;
            }
            do {
                Tessellator.checkIntersectionPoint(next, innerNext);
            } while ((innerNext = innerNext.next) != next.previous);
        } while ((next = next.next) != a.previous);
    }

    private static final void mortonCheckIntersection(Node a, Node b) {
        int minTX = StrictMath.min(a.x, a.next.x) ^ Integer.MIN_VALUE;
        int minTY = StrictMath.min(a.y, a.next.y) ^ Integer.MIN_VALUE;
        int maxTX = StrictMath.max(a.x, a.next.x) ^ Integer.MIN_VALUE;
        int maxTY = StrictMath.max(a.y, a.next.y) ^ Integer.MIN_VALUE;
        long minZ = BitUtil.interleave(minTX, minTY);
        long maxZ = BitUtil.interleave(maxTX, maxTY);
        Node p = b.previousZ;
        Node n = b.nextZ;
        while (p != null && Long.compareUnsigned(p.morton, minZ) >= 0 && n != null && Long.compareUnsigned(n.morton, maxZ) <= 0) {
            Tessellator.checkIntersectionPoint(p, a);
            p = p.previousZ;
            Tessellator.checkIntersectionPoint(n, a);
            n = n.nextZ;
        }
        while (p != null && Long.compareUnsigned(p.morton, minZ) >= 0) {
            Tessellator.checkIntersectionPoint(p, a);
            p = p.previousZ;
        }
        while (n != null && Long.compareUnsigned(n.morton, maxZ) <= 0) {
            Tessellator.checkIntersectionPoint(n, a);
            n = n.nextZ;
        }
    }

    private static void checkIntersectionPoint(Node a, Node b) {
        if (a == b) {
            return;
        }
        if (Math.max(a.getY(), a.next.getY()) <= Math.min(b.getY(), b.next.getY()) || Math.min(a.getY(), a.next.getY()) >= Math.max(b.getY(), b.next.getY()) || Math.max(a.getX(), a.next.getX()) <= Math.min(b.getX(), b.next.getX()) || Math.min(a.getX(), a.next.getX()) >= Math.max(b.getX(), b.next.getX())) {
            return;
        }
        if (GeoUtils.lineCrossesLine(a.getX(), a.getY(), a.next.getX(), a.next.getY(), b.getX(), b.getY(), b.next.getX(), b.next.getY())) {
            double a1 = a.next.getY() - a.getY();
            double b1 = a.getX() - a.next.getX();
            double c1 = a1 * a.getX() + b1 * a.getY();
            double a2 = b.next.getY() - b.getY();
            double b2 = b.getX() - b.next.getX();
            double c2 = a2 * b.getX() + b2 * b.getY();
            double determinant = a1 * b2 - a2 * b1;
            assert (determinant != 0.0);
            double x = (b2 * c1 - b1 * c2) / determinant;
            double y = (a1 * c2 - a2 * c1) / determinant;
            throw new IllegalArgumentException("Polygon self-intersection at lat=" + y + " lon=" + x);
        }
        if (a.isNextEdgeFromPolygon && b.isNextEdgeFromPolygon && GeoUtils.lineOverlapLine(a.getX(), a.getY(), a.next.getX(), a.next.getY(), b.getX(), b.getY(), b.next.getX(), b.next.getY())) {
            throw new IllegalArgumentException("Polygon ring self-intersection at lat=" + a.getY() + " lon=" + a.getX());
        }
    }

    private static boolean isEdgeFromPolygon(Node a, Node b, boolean isMorton) {
        if (isMorton) {
            return Tessellator.isMortonEdgeFromPolygon(a, b);
        }
        Node next = a;
        do {
            if (Tessellator.isPointInLine(next, next.next, a) && Tessellator.isPointInLine(next, next.next, b)) {
                return next.isNextEdgeFromPolygon;
            }
            if (!Tessellator.isPointInLine(next, next.previous, a) || !Tessellator.isPointInLine(next, next.previous, b)) continue;
            return next.previous.isNextEdgeFromPolygon;
        } while ((next = next.next) != a);
        return false;
    }

    private static final boolean isMortonEdgeFromPolygon(Node a, Node b) {
        int minTX = StrictMath.min(a.x, b.x) ^ Integer.MIN_VALUE;
        int minTY = StrictMath.min(a.y, b.y) ^ Integer.MIN_VALUE;
        int maxTX = StrictMath.max(a.x, b.x) ^ Integer.MIN_VALUE;
        int maxTY = StrictMath.max(a.y, b.y) ^ Integer.MIN_VALUE;
        long minZ = BitUtil.interleave(minTX, minTY);
        long maxZ = BitUtil.interleave(maxTX, maxTY);
        Node p = a.previousZ;
        Node n = a.nextZ;
        while (p != null && Long.compareUnsigned(p.morton, minZ) >= 0 && n != null && Long.compareUnsigned(n.morton, maxZ) <= 0) {
            if (Tessellator.isPointInLine(p, p.next, a) && Tessellator.isPointInLine(p, p.next, b)) {
                return p.isNextEdgeFromPolygon;
            }
            if (Tessellator.isPointInLine(p, p.previous, a) && Tessellator.isPointInLine(p, p.previous, b)) {
                return p.previous.isNextEdgeFromPolygon;
            }
            p = p.previousZ;
            if (Tessellator.isPointInLine(n, n.next, a) && Tessellator.isPointInLine(n, n.next, b)) {
                return n.isNextEdgeFromPolygon;
            }
            if (Tessellator.isPointInLine(n, n.previous, a) && Tessellator.isPointInLine(n, n.previous, b)) {
                return n.previous.isNextEdgeFromPolygon;
            }
            n = n.nextZ;
        }
        while (p != null && Long.compareUnsigned(p.morton, minZ) >= 0) {
            if (Tessellator.isPointInLine(p, p.next, a) && Tessellator.isPointInLine(p, p.next, b)) {
                return p.isNextEdgeFromPolygon;
            }
            if (Tessellator.isPointInLine(p, p.previous, a) && Tessellator.isPointInLine(p, p.previous, b)) {
                return p.previous.isNextEdgeFromPolygon;
            }
            p = p.previousZ;
        }
        while (n != null && Long.compareUnsigned(n.morton, maxZ) <= 0) {
            if (Tessellator.isPointInLine(n, n.next, a) && Tessellator.isPointInLine(n, n.next, b)) {
                return n.isNextEdgeFromPolygon;
            }
            if (Tessellator.isPointInLine(n, n.previous, a) && Tessellator.isPointInLine(n, n.previous, b)) {
                return n.previous.isNextEdgeFromPolygon;
            }
            n = n.nextZ;
        }
        return false;
    }

    private static boolean isPointInLine(Node a, Node b, Node point) {
        return Tessellator.isPointInLine(a, b, point.getX(), point.getY());
    }

    private static boolean isPointInLine(Node a, Node b, double lon, double lat) {
        double dxc = lon - a.getX();
        double dyc = lat - a.getY();
        double dxl = b.getX() - a.getX();
        double dyl = b.getY() - a.getY();
        if (dxc * dyl - dyc * dxl == 0.0) {
            if (Math.abs(dxl) >= Math.abs(dyl)) {
                return dxl > 0.0 ? a.getX() <= lon && lon <= b.getX() : b.getX() <= lon && lon <= a.getX();
            }
            return dyl > 0.0 ? a.getY() <= lat && lat <= b.getY() : b.getY() <= lat && lat <= a.getY();
        }
        return false;
    }

    private static final Node splitPolygon(Node a, Node b, boolean edgeFromPolygon) {
        Node a2 = new Node(a);
        Node b2 = new Node(b);
        Node an = a.next;
        Node bp = b.previous;
        a.next = b;
        a.isNextEdgeFromPolygon = edgeFromPolygon;
        a.nextZ = b;
        b.previous = a;
        b.previousZ = a;
        a2.next = an;
        a2.nextZ = an;
        an.previous = a2;
        an.previousZ = a2;
        b2.next = a2;
        b2.isNextEdgeFromPolygon = edgeFromPolygon;
        b2.nextZ = a2;
        a2.previous = b2;
        a2.previousZ = b2;
        bp.next = b2;
        bp.nextZ = b2;
        return b2;
    }

    private static final boolean isValidDiagonal(Node a, Node b) {
        if (Tessellator.isVertexEquals(a, b)) {
            return Tessellator.isCWPolygon(a, b);
        }
        return a.next.idx != b.idx && a.previous.idx != b.idx && !Tessellator.isIntersectingPolygon(a, a.getX(), a.getY(), b.getX(), b.getY()) && Tessellator.isLocallyInside(a, b) && Tessellator.isLocallyInside(b, a) && Tessellator.isLocallyInside(a.previous, b) && Tessellator.isLocallyInside(b.next, a) && Tessellator.middleInsert(a, a.getX(), a.getY(), b.getX(), b.getY()) && Tessellator.area(a.previous.getX(), a.previous.getY(), a.getX(), a.getY(), b.getX(), b.getY()) != 0.0 && Tessellator.area(a.getX(), a.getY(), b.getX(), b.getY(), b.next.getX(), b.next.getY()) != 0.0 && Tessellator.area(a.next.getX(), a.next.getY(), a.getX(), a.getY(), b.getX(), b.getY()) != 0.0 && Tessellator.area(a.getX(), a.getY(), b.getX(), b.getY(), b.previous.getX(), b.previous.getY()) != 0.0;
    }

    private static boolean isCWPolygon(Node start, Node end) {
        return Tessellator.signedArea(start, end) < 0.0;
    }

    private static double signedArea(Node start, Node end) {
        Node next = start;
        double windingSum = 0.0;
        do {
            windingSum += Tessellator.area(next.getX(), next.getY(), next.next.getX(), next.next.getY(), end.getX(), end.getY());
            next = next.next;
        } while (next.next != end);
        return windingSum;
    }

    private static final boolean isLocallyInside(Node a, Node b) {
        double area = Tessellator.area(a.previous.getX(), a.previous.getY(), a.getX(), a.getY(), a.next.getX(), a.next.getY());
        if (area == 0.0) {
            return false;
        }
        if (area < 0.0) {
            return Tessellator.area(a.getX(), a.getY(), b.getX(), b.getY(), a.next.getX(), a.next.getY()) >= 0.0 && Tessellator.area(a.getX(), a.getY(), a.previous.getX(), a.previous.getY(), b.getX(), b.getY()) >= 0.0;
        }
        return Tessellator.area(a.getX(), a.getY(), b.getX(), b.getY(), a.previous.getX(), a.previous.getY()) < 0.0 || Tessellator.area(a.getX(), a.getY(), a.next.getX(), a.next.getY(), b.getX(), b.getY()) < 0.0;
    }

    private static final boolean middleInsert(Node start, double x0, double y0, double x1, double y1) {
        Node node = start;
        boolean lIsInside = false;
        double lDx = (x0 + x1) / 2.0;
        double lDy = (y0 + y1) / 2.0;
        do {
            Node nextNode = node.next;
            if (node.getY() > lDy == nextNode.getY() > lDy || !(lDx < (nextNode.getX() - node.getX()) * (lDy - node.getY()) / (nextNode.getY() - node.getY()) + node.getX())) continue;
            boolean bl = lIsInside = !lIsInside;
        } while ((node = node.next) != start);
        return lIsInside;
    }

    private static final boolean isIntersectingPolygon(Node start, double x0, double y0, double x1, double y1) {
        Node nextNode;
        Node node = start;
        do {
            nextNode = node.next;
            if (Tessellator.isVertexEquals(node, x0, y0) || Tessellator.isVertexEquals(node, x1, y1) || !Tessellator.linesIntersect(node.getX(), node.getY(), nextNode.getX(), nextNode.getY(), x0, y0, x1, y1)) continue;
            return true;
        } while ((node = nextNode) != start);
        return false;
    }

    public static final boolean linesIntersect(double aX0, double aY0, double aX1, double aY1, double bX0, double bY0, double bX1, double bY1) {
        return Tessellator.area(aX0, aY0, aX1, aY1, bX0, bY0) > 0.0 != Tessellator.area(aX0, aY0, aX1, aY1, bX1, bY1) > 0.0 && Tessellator.area(bX0, bY0, bX1, bY1, aX0, aY0) > 0.0 != Tessellator.area(bX0, bY0, bX1, bY1, aX1, aY1) > 0.0;
    }

    private static final void sortByMortonWithReset(Node start) {
        Node next = start;
        do {
            next.previousZ = next.previous;
            next.nextZ = next.next;
        } while ((next = next.next) != start);
        Tessellator.sortByMorton(start);
    }

    private static final void sortByMorton(Node start) {
        start.previousZ.nextZ = null;
        start.previousZ = null;
        Tessellator.tathamSort(start);
    }

    private static final void tathamSort(Node list) {
        int numMerges;
        int inSize = 1;
        if (list == null) {
            return;
        }
        do {
            Node p = list;
            list = null;
            Node tail = null;
            numMerges = 0;
            while (p != null) {
                ++numMerges;
                Node q = p;
                int i = 0;
                int pSize = 0;
                while (i < inSize && q != null) {
                    ++i;
                    ++pSize;
                    q = q.nextZ;
                }
                int qSize = inSize;
                while (pSize > 0 || qSize > 0 && q != null) {
                    Node e2;
                    if (pSize != 0 && (qSize == 0 || q == null || Long.compareUnsigned(p.morton, q.morton) <= 0)) {
                        e2 = p;
                        p = p.nextZ;
                        --pSize;
                    } else {
                        e2 = q;
                        q = q.nextZ;
                        --qSize;
                    }
                    if (tail != null) {
                        tail.nextZ = e2;
                    } else {
                        list = e2;
                    }
                    e2.previousZ = tail;
                    tail = e2;
                }
                p = q;
            }
            tail.nextZ = null;
            inSize *= 2;
        } while (numMerges > 1);
    }

    private static final Node filterPoints(Node start, Node end) {
        boolean continueIteration;
        if (start == null) {
            return start;
        }
        if (end == null) {
            end = start;
        }
        Node node = start;
        do {
            continueIteration = false;
            Node nextNode = node.next;
            Node prevNode = node.previous;
            if (Tessellator.isVertexEquals(node, nextNode) || Tessellator.isVertexEquals(prevNode, nextNode) || (prevNode.isNextEdgeFromPolygon == node.isNextEdgeFromPolygon || Tessellator.isPointInLine(prevNode, node, nextNode.getX(), nextNode.getY())) && Tessellator.area(prevNode.getX(), prevNode.getY(), node.getX(), node.getY(), nextNode.getX(), nextNode.getY()) == 0.0) {
                Tessellator.removeNode(node, prevNode.isNextEdgeFromPolygon);
                node = end = prevNode;
                if (node == nextNode) break;
                continueIteration = true;
                continue;
            }
            node = nextNode;
        } while (continueIteration || node != end);
        return end;
    }

    private static final Node insertNode(double[] x, double[] y, int index, int vertexIndex, Node lastNode, boolean isGeo) {
        Node node = new Node(x, y, index, vertexIndex, isGeo);
        if (lastNode == null) {
            node.previous = node;
            node.previousZ = node;
            node.next = node;
            node.nextZ = node;
        } else {
            node.next = lastNode.next;
            node.nextZ = lastNode.next;
            node.previous = lastNode;
            node.previousZ = lastNode;
            lastNode.next.previous = node;
            lastNode.nextZ.previousZ = node;
            lastNode.next = node;
            lastNode.nextZ = node;
        }
        return node;
    }

    private static final void removeNode(Node node, boolean edgeFromPolygon) {
        node.next.previous = node.previous;
        node.previous.next = node.next;
        node.previous.isNextEdgeFromPolygon = edgeFromPolygon;
        if (node.previousZ != null) {
            node.previousZ.nextZ = node.nextZ;
        }
        if (node.nextZ != null) {
            node.nextZ.previousZ = node.previousZ;
        }
    }

    private static final boolean isVertexEquals(Node a, Node b) {
        return Tessellator.isVertexEquals(a, b.getX(), b.getY());
    }

    private static final boolean isVertexEquals(Node a, double x, double y) {
        return a.getX() == x && a.getY() == y;
    }

    private static double area(double aX, double aY, double bX, double bY, double cX, double cY) {
        return (bY - aY) * (cX - bX) - (bX - aX) * (cY - bY);
    }

    private static boolean pointInEar(double x, double y, double ax, double ay, double bx, double by, double cx, double cy) {
        return (cx - x) * (ay - y) - (ax - x) * (cy - y) >= 0.0 && (ax - x) * (by - y) - (bx - x) * (ay - y) >= 0.0 && (bx - x) * (cy - y) - (cx - x) * (by - y) >= 0.0;
    }

    public static boolean pointInTriangle(double x, double y, double ax, double ay, double bx, double by, double cx, double cy) {
        double minX = StrictMath.min(ax, StrictMath.min(bx, cx));
        double minY = StrictMath.min(ay, StrictMath.min(by, cy));
        double maxX = StrictMath.max(ax, StrictMath.max(bx, cx));
        double maxY = StrictMath.max(ay, StrictMath.max(by, cy));
        if (x >= minX && x <= maxX && y >= minY && y <= maxY) {
            int a = GeoUtils.orient(x, y, ax, ay, bx, by);
            int b = GeoUtils.orient(x, y, bx, by, cx, cy);
            if (a == 0 || b == 0 || a < 0 == b < 0) {
                int c = GeoUtils.orient(x, y, cx, cy, ax, ay);
                return c == 0 || c < 0 == (b < 0 || a < 0);
            }
            return false;
        }
        return false;
    }

    public static final boolean pointInPolygon(List<Triangle> tessellation, double lat, double lon) {
        for (int i = 0; i < tessellation.size(); ++i) {
            if (!tessellation.get(i).containsPoint(lat, lon)) continue;
            return true;
        }
        return false;
    }

    private static List<Point> getPoints(Node start) {
        Node node = start;
        ArrayList<Point> points = new ArrayList<Point>();
        do {
            points.add(new Point(node.getY(), node.getX()));
        } while ((node = node.next) != start);
        return points;
    }

    private static void notifyMonitorSplit(int depth, Monitor monitor, Node searchNode, Node diagonalNode) {
        if (monitor != null) {
            if (searchNode == null || diagonalNode == null) {
                throw new IllegalStateException("Invalid split provided to monitor");
            }
            monitor.startSplit("SPLIT[" + depth + "]", Tessellator.getPoints(searchNode), Tessellator.getPoints(diagonalNode));
        }
    }

    private static void notifyMonitorSplitEnd(int depth, Monitor monitor) {
        if (monitor != null) {
            monitor.endSplit("SPLIT[" + depth + "]");
        }
    }

    private static void notifyMonitor(State state, int depth, Monitor monitor, Node start, List<Triangle> tessellation) {
        if (monitor != null) {
            Tessellator.notifyMonitor(state.name() + (String)(depth == 0 ? "" : "[" + depth + "]"), monitor, start, tessellation);
        }
    }

    private static void notifyMonitor(String status, Monitor monitor, Node start, List<Triangle> tessellation) {
        if (monitor != null) {
            if (start == null) {
                monitor.currentState(status, null, tessellation);
            } else {
                monitor.currentState(status, Tessellator.getPoints(start), tessellation);
            }
        }
    }

    public static final class Triangle {
        Node[] vertex;
        boolean[] edgeFromPolygon;

        protected Triangle(Node a, boolean isABfromPolygon, Node b, boolean isBCfromPolygon, Node c, boolean isCAfromPolygon) {
            this.vertex = new Node[]{a, b, c};
            this.edgeFromPolygon = new boolean[]{isABfromPolygon, isBCfromPolygon, isCAfromPolygon};
        }

        public int getEncodedX(int vertex) {
            return this.vertex[vertex].x;
        }

        public int getEncodedY(int vertex) {
            return this.vertex[vertex].y;
        }

        public double getY(int vertex) {
            return this.vertex[vertex].getY();
        }

        public double getX(int vertex) {
            return this.vertex[vertex].getX();
        }

        public boolean isEdgefromPolygon(int startVertex) {
            return this.edgeFromPolygon[startVertex];
        }

        protected boolean containsPoint(double lat, double lon) {
            return Tessellator.pointInTriangle(lon, lat, this.vertex[0].getX(), this.vertex[0].getY(), this.vertex[1].getX(), this.vertex[1].getY(), this.vertex[2].getX(), this.vertex[2].getY());
        }

        public String toString() {
            String result = this.vertex[0].x + ", " + this.vertex[0].y + " [" + this.edgeFromPolygon[0] + "] " + this.vertex[1].x + ", " + this.vertex[1].y + " [" + this.edgeFromPolygon[1] + "] " + this.vertex[2].x + ", " + this.vertex[2].y + " [" + this.edgeFromPolygon[2] + "]";
            return result;
        }
    }

    protected static class Node {
        private final int idx;
        private final int vrtxIdx;
        private final double[] polyX;
        private final double[] polyY;
        private final int x;
        private final int y;
        private final long morton;
        private Node previous;
        private Node next;
        private Node previousZ;
        private Node nextZ;
        private boolean isNextEdgeFromPolygon;

        protected Node(double[] x, double[] y, int index, int vertexIndex, boolean isGeo) {
            this.idx = index;
            this.vrtxIdx = vertexIndex;
            this.polyX = x;
            this.polyY = y;
            this.y = isGeo ? GeoEncodingUtils.encodeLatitude(this.polyY[this.vrtxIdx]) : XYEncodingUtils.encode((float)this.polyY[this.vrtxIdx]);
            this.x = isGeo ? GeoEncodingUtils.encodeLongitude(this.polyX[this.vrtxIdx]) : XYEncodingUtils.encode((float)this.polyX[this.vrtxIdx]);
            this.morton = BitUtil.interleave(this.x ^ Integer.MIN_VALUE, this.y ^ Integer.MIN_VALUE);
            this.previous = null;
            this.next = null;
            this.previousZ = null;
            this.nextZ = null;
            this.isNextEdgeFromPolygon = true;
        }

        protected Node(Node other) {
            this.idx = other.idx;
            this.vrtxIdx = other.vrtxIdx;
            this.polyX = other.polyX;
            this.polyY = other.polyY;
            this.morton = other.morton;
            this.x = other.x;
            this.y = other.y;
            this.previous = other.previous;
            this.next = other.next;
            this.previousZ = other.previousZ;
            this.nextZ = other.nextZ;
            this.isNextEdgeFromPolygon = other.isNextEdgeFromPolygon;
        }

        public final double getX() {
            return this.polyX[this.vrtxIdx];
        }

        public final double getY() {
            return this.polyY[this.vrtxIdx];
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            if (this.previous == null) {
                builder.append("||-");
            } else {
                builder.append(this.previous.idx).append(" <- ");
            }
            builder.append(this.idx);
            if (this.next == null) {
                builder.append(" -||");
            } else {
                builder.append(" -> ").append(this.next.idx);
            }
            return builder.toString();
        }
    }

    public static interface Monitor {
        public static final String FAILED = "FAILED";
        public static final String COMPLETED = "COMPLETED";

        public void currentState(String var1, List<Point> var2, List<Triangle> var3);

        public void startSplit(String var1, List<Point> var2, List<Point> var3);

        public void endSplit(String var1);
    }

    private static enum State {
        INIT,
        CURE,
        SPLIT;

    }
}

