/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.backward_codecs.lucene90;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.SplittableRandom;
import org.apache.lucene.backward_codecs.lucene90.Lucene90OnHeapHnswGraph;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.KnnVectorsReader;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.RandomAccessVectorValues;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.VectorSimilarityFunction;
import org.apache.lucene.index.VectorValues;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TotalHits;
import org.apache.lucene.store.ChecksumIndexInput;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.hnsw.HnswGraph;
import org.apache.lucene.util.hnsw.NeighborQueue;

public final class Lucene90HnswVectorsReader
extends KnnVectorsReader {
    private final FieldInfos fieldInfos;
    private final Map<String, FieldEntry> fields;
    private final IndexInput vectorData;
    private final IndexInput vectorIndex;
    private final long checksumSeed;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Lucene90HnswVectorsReader(SegmentReadState state) throws IOException {
        long[] checksumRef;
        block3: {
            this.fields = new HashMap<String, FieldEntry>();
            this.fieldInfos = state.fieldInfos;
            int versionMeta = this.readMetadata(state);
            checksumRef = new long[1];
            boolean success = false;
            try {
                this.vectorData = Lucene90HnswVectorsReader.openDataInput(state, versionMeta, "vec", "Lucene90HnswVectorsFormatData", checksumRef);
                this.vectorIndex = Lucene90HnswVectorsReader.openDataInput(state, versionMeta, "vex", "Lucene90HnswVectorsFormatIndex", checksumRef);
                success = true;
                if (success) break block3;
            }
            catch (Throwable throwable) {
                if (!success) {
                    IOUtils.closeWhileHandlingException(this);
                }
                throw throwable;
            }
            IOUtils.closeWhileHandlingException(this);
        }
        this.checksumSeed = checksumRef[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int readMetadata(SegmentReadState state) throws IOException {
        int versionMeta;
        block11: {
            String metaFileName = IndexFileNames.segmentFileName(state.segmentInfo.name, state.segmentSuffix, "vem");
            versionMeta = -1;
            try (ChecksumIndexInput meta = state.directory.openChecksumInput(metaFileName, state.context);){
                Throwable priorE = null;
                try {
                    versionMeta = CodecUtil.checkIndexHeader(meta, "Lucene90HnswVectorsFormatMeta", 0, 0, state.segmentInfo.getId(), state.segmentSuffix);
                    this.readFields(meta, state.fieldInfos);
                }
                catch (Throwable exception) {
                    try {
                        priorE = exception;
                        break block11;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        CodecUtil.checkFooter(meta, priorE);
                    }
                }
                CodecUtil.checkFooter(meta, priorE);
            }
        }
        return versionMeta;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IndexInput openDataInput(SegmentReadState state, int versionMeta, String fileExtension, String codecName, long[] checksumRef) throws IOException {
        IndexInput indexInput;
        block4: {
            String fileName = IndexFileNames.segmentFileName(state.segmentInfo.name, state.segmentSuffix, fileExtension);
            IndexInput in = state.directory.openInput(fileName, state.context);
            boolean success = false;
            try {
                int versionVectorData = CodecUtil.checkIndexHeader(in, codecName, 0, 0, state.segmentInfo.getId(), state.segmentSuffix);
                if (versionMeta != versionVectorData) {
                    throw new CorruptIndexException("Format versions mismatch: meta=" + versionMeta + ", " + codecName + "=" + versionVectorData, in);
                }
                checksumRef[0] = CodecUtil.retrieveChecksum(in);
                success = true;
                indexInput = in;
                if (success) break block4;
            }
            catch (Throwable throwable) {
                if (!success) {
                    IOUtils.closeWhileHandlingException(in);
                }
                throw throwable;
            }
            IOUtils.closeWhileHandlingException(in);
        }
        return indexInput;
    }

    private void readFields(ChecksumIndexInput meta, FieldInfos infos) throws IOException {
        int fieldNumber = meta.readInt();
        while (fieldNumber != -1) {
            FieldInfo info = infos.fieldInfo(fieldNumber);
            if (info == null) {
                throw new CorruptIndexException("Invalid field number: " + fieldNumber, meta);
            }
            FieldEntry fieldEntry = this.readField(meta);
            this.validateFieldEntry(info, fieldEntry);
            this.fields.put(info.name, fieldEntry);
            fieldNumber = meta.readInt();
        }
    }

    private void validateFieldEntry(FieldInfo info, FieldEntry fieldEntry) {
        int dimension = info.getVectorDimension();
        if (dimension != fieldEntry.dimension) {
            throw new IllegalStateException("Inconsistent vector dimension for field=\"" + info.name + "\"; " + dimension + " != " + fieldEntry.dimension);
        }
        long numBytes = (long)fieldEntry.size() * (long)dimension * 4L;
        if (numBytes != fieldEntry.vectorDataLength) {
            throw new IllegalStateException("Vector data length " + fieldEntry.vectorDataLength + " not matching size=" + fieldEntry.size() + " * dim=" + dimension + " * 4 = " + numBytes);
        }
    }

    private VectorSimilarityFunction readSimilarityFunction(DataInput input) throws IOException {
        int similarityFunctionId = input.readInt();
        if (similarityFunctionId < 0 || similarityFunctionId >= VectorSimilarityFunction.values().length) {
            throw new CorruptIndexException("Invalid similarity function id: " + similarityFunctionId, input);
        }
        return VectorSimilarityFunction.values()[similarityFunctionId];
    }

    private FieldEntry readField(DataInput input) throws IOException {
        VectorSimilarityFunction similarityFunction = this.readSimilarityFunction(input);
        return new FieldEntry(input, similarityFunction);
    }

    @Override
    public long ramBytesUsed() {
        long totalBytes = RamUsageEstimator.shallowSizeOfInstance(Lucene90HnswVectorsReader.class);
        totalBytes += RamUsageEstimator.sizeOfMap(this.fields, RamUsageEstimator.shallowSizeOfInstance(FieldEntry.class));
        for (FieldEntry entry : this.fields.values()) {
            totalBytes += RamUsageEstimator.sizeOf(entry.ordToDoc);
        }
        return totalBytes;
    }

    @Override
    public void checkIntegrity() throws IOException {
        CodecUtil.checksumEntireFile(this.vectorData);
        CodecUtil.checksumEntireFile(this.vectorIndex);
    }

    @Override
    public VectorValues getVectorValues(String field) throws IOException {
        FieldEntry fieldEntry = this.fields.get(field);
        return this.getOffHeapVectorValues(fieldEntry);
    }

    @Override
    public TopDocs search(String field, float[] target, int k, Bits acceptDocs, int visitedLimit) throws IOException {
        FieldEntry fieldEntry = this.fields.get(field);
        if (fieldEntry.size() == 0) {
            return new TopDocs(new TotalHits(0L, TotalHits.Relation.EQUAL_TO), new ScoreDoc[0]);
        }
        k = Math.min(k, fieldEntry.size());
        OffHeapVectorValues vectorValues = this.getOffHeapVectorValues(fieldEntry);
        SplittableRandom random = new SplittableRandom(this.checksumSeed);
        NeighborQueue results = Lucene90OnHeapHnswGraph.search(target, k, k, vectorValues, fieldEntry.similarityFunction, this.getGraphValues(fieldEntry), this.getAcceptOrds(acceptDocs, fieldEntry), visitedLimit, random);
        int i = 0;
        ScoreDoc[] scoreDocs = new ScoreDoc[Math.min(results.size(), k)];
        while (results.size() > 0) {
            int node = results.topNode();
            float minSimilarity = results.topScore();
            results.pop();
            scoreDocs[scoreDocs.length - ++i] = new ScoreDoc(fieldEntry.ordToDoc[node], minSimilarity);
        }
        TotalHits.Relation relation = results.incomplete() ? TotalHits.Relation.GREATER_THAN_OR_EQUAL_TO : TotalHits.Relation.EQUAL_TO;
        return new TopDocs(new TotalHits(results.visitedCount(), relation), scoreDocs);
    }

    private OffHeapVectorValues getOffHeapVectorValues(FieldEntry fieldEntry) throws IOException {
        IndexInput bytesSlice = this.vectorData.slice("vector-data", fieldEntry.vectorDataOffset, fieldEntry.vectorDataLength);
        return new OffHeapVectorValues(fieldEntry.dimension, fieldEntry.ordToDoc, bytesSlice);
    }

    private Bits getAcceptOrds(final Bits acceptDocs, final FieldEntry fieldEntry) {
        if (acceptDocs == null) {
            return null;
        }
        return new Bits(){

            @Override
            public boolean get(int index) {
                return acceptDocs.get(fieldEntry.ordToDoc[index]);
            }

            @Override
            public int length() {
                return fieldEntry.ordToDoc.length;
            }
        };
    }

    public HnswGraph getGraphValues(String field) throws IOException {
        FieldInfo info = this.fieldInfos.fieldInfo(field);
        if (info == null) {
            throw new IllegalArgumentException("No such field '" + field + "'");
        }
        FieldEntry entry = this.fields.get(field);
        if (entry != null && entry.indexDataLength > 0L) {
            return this.getGraphValues(entry);
        }
        return HnswGraph.EMPTY;
    }

    private HnswGraph getGraphValues(FieldEntry entry) throws IOException {
        IndexInput bytesSlice = this.vectorIndex.slice("graph-data", entry.indexDataOffset, entry.indexDataLength);
        return new OffHeapHnswGraph(entry, bytesSlice);
    }

    @Override
    public void close() throws IOException {
        IOUtils.close(this.vectorData, this.vectorIndex);
    }

    private static final class OffHeapHnswGraph
    extends HnswGraph {
        final FieldEntry entry;
        final IndexInput dataIn;
        int arcCount;
        int arcUpTo;
        int arc;

        OffHeapHnswGraph(FieldEntry entry, IndexInput dataIn) {
            this.entry = entry;
            this.dataIn = dataIn;
        }

        @Override
        public void seek(int level, int targetOrd) throws IOException {
            this.dataIn.seek(this.entry.ordOffsets[targetOrd]);
            this.arcCount = this.dataIn.readInt();
            this.arc = -1;
            this.arcUpTo = 0;
        }

        @Override
        public int size() {
            return this.entry.size();
        }

        @Override
        public int nextNeighbor() throws IOException {
            if (this.arcUpTo >= this.arcCount) {
                return Integer.MAX_VALUE;
            }
            ++this.arcUpTo;
            this.arc += this.dataIn.readVInt();
            return this.arc;
        }

        @Override
        public int numLevels() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int entryNode() {
            throw new UnsupportedOperationException();
        }

        @Override
        public HnswGraph.NodesIterator getNodesOnLevel(int level) {
            throw new UnsupportedOperationException();
        }
    }

    static class OffHeapVectorValues
    extends VectorValues
    implements RandomAccessVectorValues {
        final int dimension;
        final int[] ordToDoc;
        final IndexInput dataIn;
        final BytesRef binaryValue;
        final ByteBuffer byteBuffer;
        final int byteSize;
        final float[] value;
        int ord = -1;
        int doc = -1;

        OffHeapVectorValues(int dimension, int[] ordToDoc, IndexInput dataIn) {
            this.dimension = dimension;
            this.ordToDoc = ordToDoc;
            this.dataIn = dataIn;
            this.byteSize = 4 * dimension;
            this.byteBuffer = ByteBuffer.allocate(this.byteSize);
            this.value = new float[dimension];
            this.binaryValue = new BytesRef(this.byteBuffer.array(), this.byteBuffer.arrayOffset(), this.byteSize);
        }

        @Override
        public int dimension() {
            return this.dimension;
        }

        @Override
        public int size() {
            return this.ordToDoc.length;
        }

        @Override
        public float[] vectorValue() throws IOException {
            this.dataIn.seek((long)this.ord * (long)this.byteSize);
            this.dataIn.readFloats(this.value, 0, this.value.length);
            return this.value;
        }

        @Override
        public BytesRef binaryValue() throws IOException {
            this.dataIn.seek((long)this.ord * (long)this.byteSize);
            this.dataIn.readBytes(this.byteBuffer.array(), this.byteBuffer.arrayOffset(), this.byteSize, false);
            return this.binaryValue;
        }

        @Override
        public int docID() {
            return this.doc;
        }

        @Override
        public int nextDoc() {
            this.doc = ++this.ord >= this.size() ? Integer.MAX_VALUE : this.ordToDoc[this.ord];
            return this.doc;
        }

        @Override
        public int advance(int target) {
            assert (this.docID() < target);
            this.ord = Arrays.binarySearch(this.ordToDoc, this.ord + 1, this.ordToDoc.length, target);
            if (this.ord < 0) {
                this.ord = -(this.ord + 1);
            }
            assert (this.ord <= this.ordToDoc.length);
            this.doc = this.ord == this.ordToDoc.length ? Integer.MAX_VALUE : this.ordToDoc[this.ord];
            return this.doc;
        }

        @Override
        public long cost() {
            return this.ordToDoc.length;
        }

        @Override
        public RandomAccessVectorValues copy() {
            return new OffHeapVectorValues(this.dimension, this.ordToDoc, this.dataIn.clone());
        }

        @Override
        public float[] vectorValue(int targetOrd) throws IOException {
            this.dataIn.seek((long)targetOrd * (long)this.byteSize);
            this.dataIn.readFloats(this.value, 0, this.value.length);
            return this.value;
        }

        @Override
        public BytesRef binaryValue(int targetOrd) throws IOException {
            this.readValue(targetOrd);
            return this.binaryValue;
        }

        private void readValue(int targetOrd) throws IOException {
            this.dataIn.seek((long)targetOrd * (long)this.byteSize);
            this.dataIn.readBytes(this.byteBuffer.array(), this.byteBuffer.arrayOffset(), this.byteSize);
        }
    }

    private static class FieldEntry {
        final int dimension;
        final VectorSimilarityFunction similarityFunction;
        final long vectorDataOffset;
        final long vectorDataLength;
        final long indexDataOffset;
        final long indexDataLength;
        final int[] ordToDoc;
        final long[] ordOffsets;

        FieldEntry(DataInput input, VectorSimilarityFunction similarityFunction) throws IOException {
            this.similarityFunction = similarityFunction;
            this.vectorDataOffset = input.readVLong();
            this.vectorDataLength = input.readVLong();
            this.indexDataOffset = input.readVLong();
            this.indexDataLength = input.readVLong();
            this.dimension = input.readInt();
            int size = input.readInt();
            this.ordToDoc = new int[size];
            for (int i = 0; i < size; ++i) {
                int doc;
                this.ordToDoc[i] = doc = input.readVInt();
            }
            this.ordOffsets = new long[this.size()];
            long offset = 0L;
            for (int i = 0; i < this.ordOffsets.length; ++i) {
                this.ordOffsets[i] = offset += input.readVLong();
            }
        }

        int size() {
            return this.ordToDoc.length;
        }
    }
}

