/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.async;

import java.util.concurrent.Callable;
import org.apache.jena.atlas.lib.DateTimeUtils;
import org.apache.jena.atlas.lib.InternalErrorException;
import org.apache.jena.atlas.logging.FmtLog;
import org.apache.jena.fuseki.Fuseki;
import org.apache.jena.fuseki.async.AsyncPool;
import org.apache.jena.fuseki.server.DataService;
import org.slf4j.Logger;

public class AsyncTask
implements Callable<Object> {
    private static Logger log = Fuseki.serverLog;
    private final Callable<Object> callable;
    private final AsyncPool pool;
    private final String displayName;
    private final DataService dataService;
    private String startPoint = null;
    private String finishPoint = null;
    private final String taskId;
    private long requestId;
    private Boolean success = null;

    AsyncTask(Callable<Object> callable, AsyncPool pool, String taskId, String displayName, DataService dataService, long requestId) {
        this.callable = callable;
        this.pool = pool;
        this.taskId = taskId;
        this.displayName = displayName;
        this.dataService = dataService;
        this.requestId = requestId;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public long getOriginatingRequestId() {
        return this.requestId;
    }

    public String displayName() {
        return this.displayName;
    }

    public DataService getDataService() {
        return this.dataService;
    }

    private void start() {
        if (this.startPoint != null) {
            FmtLog.warn(Fuseki.serverLog, "[Task %s] Async task has already been started", this.taskId);
            throw new InternalErrorException("Finish has already been called [" + this.getTaskId() + "]");
        }
        Fuseki.serverLog.info(String.format("[Task %s] starts : %s", this.taskId, this.displayName));
        this.startPoint = DateTimeUtils.nowAsXSDDateTimeString();
    }

    public void finish() {
        if (this.finishPoint != null) {
            FmtLog.warn(Fuseki.serverLog, "[Task %s] Async task has already been finished", this.taskId);
            throw new InternalErrorException("Finish has already been called [" + this.getTaskId() + "]");
        }
        this.finishPoint = DateTimeUtils.nowAsXSDDateTimeString();
        Fuseki.serverLog.info(String.format("[Task %s] finishes : %s", this.taskId, this.displayName));
    }

    @Override
    public Object call() {
        try {
            this.start();
            Object result = this.callable.call();
            this.success = true;
            Object object = result;
            return object;
        }
        catch (Throwable ex) {
            this.success = false;
            Object var2_4 = null;
            return var2_4;
        }
        finally {
            this.finish();
            this.pool.finished(this);
        }
    }

    public String getStartPoint() {
        return this.startPoint;
    }

    public String getFinishPoint() {
        return this.finishPoint;
    }

    public Boolean wasSuccessful() {
        return this.success;
    }
}

