/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.core.io.doubleparser;

import com.fasterxml.jackson.core.io.doubleparser.DoubleBitsFromCharArray;
import com.fasterxml.jackson.core.io.doubleparser.DoubleBitsFromCharSequence;

public class FastDoubleParser {
    private FastDoubleParser() {
    }

    public static double parseDouble(CharSequence str2) throws NumberFormatException {
        return FastDoubleParser.parseDouble(str2, 0, str2.length());
    }

    public static double parseDouble(CharSequence str2, int offset, int length) throws NumberFormatException {
        long bitPattern = new DoubleBitsFromCharSequence().parseFloatingPointLiteral(str2, offset, length);
        if (bitPattern == -1L) {
            throw new NumberFormatException("Illegal input");
        }
        return Double.longBitsToDouble(bitPattern);
    }

    public static double parseDouble(char[] str2) throws NumberFormatException {
        return FastDoubleParser.parseDouble(str2, 0, str2.length);
    }

    public static double parseDouble(char[] str2, int offset, int length) throws NumberFormatException {
        long bitPattern = new DoubleBitsFromCharArray().parseFloatingPointLiteral(str2, offset, length);
        if (bitPattern == -1L) {
            throw new NumberFormatException("Illegal input");
        }
        return Double.longBitsToDouble(bitPattern);
    }

    public static long parseDoubleBits(CharSequence str2, int offset, int length) {
        return new DoubleBitsFromCharSequence().parseFloatingPointLiteral(str2, offset, length);
    }

    public static long parseDoubleBits(char[] str2, int offset, int length) {
        return new DoubleBitsFromCharArray().parseFloatingPointLiteral(str2, offset, length);
    }
}

