/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.jsonld.processor;

import com.apicatalog.jsonld.JsonLdError;
import com.apicatalog.jsonld.JsonLdErrorCode;
import com.apicatalog.jsonld.JsonLdOptions;
import com.apicatalog.jsonld.compaction.Compaction;
import com.apicatalog.jsonld.context.ActiveContext;
import com.apicatalog.jsonld.document.Document;
import com.apicatalog.jsonld.json.JsonUtils;
import com.apicatalog.jsonld.loader.DocumentLoaderOptions;
import com.apicatalog.jsonld.processor.ExpansionProcessor;
import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonObject;
import jakarta.json.JsonValue;
import java.net.URI;

public final class CompactionProcessor {
    private CompactionProcessor() {
    }

    public static final JsonObject compact(URI input, URI context2, JsonLdOptions options) throws JsonLdError {
        if (options.getDocumentLoader() == null) {
            throw new JsonLdError(JsonLdErrorCode.LOADING_DOCUMENT_FAILED, "Document loader is null. Cannot fetch [" + context2 + "].");
        }
        Document contextDocument = options.getDocumentLoader().loadDocument(context2, new DocumentLoaderOptions());
        if (contextDocument == null) {
            throw new JsonLdError(JsonLdErrorCode.INVALID_REMOTE_CONTEXT, "Context[" + context2 + "] is null.");
        }
        return CompactionProcessor.compact(input, contextDocument, options);
    }

    public static final JsonObject compact(URI input, Document context2, JsonLdOptions options) throws JsonLdError {
        if (options.getDocumentLoader() == null) {
            throw new JsonLdError(JsonLdErrorCode.LOADING_DOCUMENT_FAILED, "Document loader is null. Cannot fetch [" + input + "].");
        }
        DocumentLoaderOptions loaderOptions = new DocumentLoaderOptions();
        loaderOptions.setExtractAllScripts(options.isExtractAllScripts());
        Document remoteDocument = options.getDocumentLoader().loadDocument(input, loaderOptions);
        if (remoteDocument == null) {
            throw new JsonLdError(JsonLdErrorCode.LOADING_DOCUMENT_FAILED, "Returned document is null [" + input + "].");
        }
        return CompactionProcessor.compact(remoteDocument, context2, options);
    }

    public static final JsonObject compact(Document input, URI context2, JsonLdOptions options) throws JsonLdError {
        if (options.getDocumentLoader() == null) {
            throw new JsonLdError(JsonLdErrorCode.LOADING_DOCUMENT_FAILED, "Document loader is null. Cannot fetch [" + context2 + "].");
        }
        Document contextDocument = options.getDocumentLoader().loadDocument(context2, new DocumentLoaderOptions());
        if (contextDocument == null) {
            throw new JsonLdError(JsonLdErrorCode.INVALID_REMOTE_CONTEXT, "Returned context is null [" + context2 + "] is null.");
        }
        return CompactionProcessor.compact(input, contextDocument, options);
    }

    public static final JsonObject compact(Document input, Document context2, JsonLdOptions options) throws JsonLdError {
        JsonValue compactedOutput;
        JsonLdOptions expansionOptions = new JsonLdOptions(options);
        expansionOptions.setOrdered(false);
        expansionOptions.setExtractAllScripts(false);
        JsonArray expandedInput = ExpansionProcessor.expand(input, expansionOptions, false);
        URI contextBase = input.getDocumentUrl();
        if (contextBase == null) {
            contextBase = options.getBase();
        }
        JsonValue contextValue = context2.getJsonContent().map(ctx -> JsonUtils.flatten(ctx, "@context")).orElse(JsonValue.EMPTY_JSON_OBJECT);
        ActiveContext activeContext = new ActiveContext(options).newContext().create(contextValue, contextBase);
        if (activeContext.getBaseUri() == null) {
            if (options.getBase() != null) {
                activeContext.setBaseUri(options.getBase());
            } else if (options.isCompactToRelative()) {
                activeContext.setBaseUri(input.getDocumentUrl());
            }
        }
        if (JsonUtils.isEmptyArray(compactedOutput = Compaction.with(activeContext).compactArrays(options.isCompactArrays()).ordered(options.isOrdered()).compact(expandedInput))) {
            compactedOutput = JsonValue.EMPTY_JSON_OBJECT;
        } else if (JsonUtils.isArray(compactedOutput)) {
            compactedOutput = Json.createObjectBuilder().add(activeContext.uriCompaction().vocab(true).compact("@graph"), compactedOutput).build();
        }
        if (JsonUtils.isNull(compactedOutput) || compactedOutput.asJsonObject().isEmpty()) {
            return JsonValue.EMPTY_JSON_OBJECT;
        }
        if (JsonUtils.isNotNull(contextValue) && !JsonUtils.isEmptyArray(contextValue) && !JsonUtils.isEmptyObject(contextValue)) {
            compactedOutput = Json.createObjectBuilder(compactedOutput.asJsonObject()).add("@context", contextValue).build();
        }
        return compactedOutput.asJsonObject();
    }
}

