/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.nio.file.Path;
import java.util.Locale;
import java.util.logging.Logger;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.FSLockFactory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.LockFactory;
import org.apache.lucene.store.MappedByteBufferIndexInputProvider;
import org.apache.lucene.util.Constants;

public class MMapDirectory
extends FSDirectory {
    private boolean useUnmapHack = UNMAP_SUPPORTED;
    private boolean preload;
    public static final long DEFAULT_MAX_CHUNK_SIZE;
    final int chunkSizePower;
    static final MMapIndexInputProvider PROVIDER;
    public static final boolean UNMAP_SUPPORTED;
    public static final String UNMAP_NOT_SUPPORTED_REASON;

    public MMapDirectory(Path path, LockFactory lockFactory) throws IOException {
        this(path, lockFactory, DEFAULT_MAX_CHUNK_SIZE);
    }

    public MMapDirectory(Path path) throws IOException {
        this(path, FSLockFactory.getDefault());
    }

    @Deprecated
    public MMapDirectory(Path path, int maxChunkSize) throws IOException {
        this(path, (long)maxChunkSize);
    }

    public MMapDirectory(Path path, long maxChunkSize) throws IOException {
        this(path, (LockFactory)FSLockFactory.getDefault(), maxChunkSize);
    }

    @Deprecated
    public MMapDirectory(Path path, LockFactory lockFactory, int maxChunkSize) throws IOException {
        this(path, lockFactory, (long)maxChunkSize);
    }

    public MMapDirectory(Path path, LockFactory lockFactory, long maxChunkSize) throws IOException {
        super(path, lockFactory);
        if (maxChunkSize <= 0L) {
            throw new IllegalArgumentException("Maximum chunk size for mmap must be >0");
        }
        this.chunkSizePower = 63 - Long.numberOfLeadingZeros(maxChunkSize);
        assert (1L << this.chunkSizePower <= maxChunkSize);
        assert (1L << this.chunkSizePower > maxChunkSize / 2L);
    }

    public void setUseUnmap(boolean useUnmapHack) {
        if (useUnmapHack && !UNMAP_SUPPORTED) {
            throw new IllegalArgumentException(UNMAP_NOT_SUPPORTED_REASON);
        }
        this.useUnmapHack = useUnmapHack;
    }

    public boolean getUseUnmap() {
        return this.useUnmapHack;
    }

    public void setPreload(boolean preload) {
        this.preload = preload;
    }

    public boolean getPreload() {
        return this.preload;
    }

    public final long getMaxChunkSize() {
        return 1L << this.chunkSizePower;
    }

    @Override
    public IndexInput openInput(String name, IOContext context2) throws IOException {
        this.ensureOpen();
        this.ensureCanRead(name);
        Path path = this.directory.resolve(name);
        return PROVIDER.openInput(path, context2, this.chunkSizePower, this.preload, this.useUnmapHack);
    }

    private static MMapIndexInputProvider lookupProvider() {
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        try {
            Class<?> cls = lookup.findClass("org.apache.lucene.store.MemorySegmentIndexInputProvider");
            MethodHandle constr = lookup.findConstructor(cls, MethodType.methodType(Void.TYPE));
            try {
                return constr.invoke();
            }
            catch (Error | RuntimeException e2) {
                throw e2;
            }
            catch (Throwable th) {
                throw new AssertionError((Object)th);
            }
        }
        catch (ClassNotFoundException e3) {
            return new MappedByteBufferIndexInputProvider();
        }
        catch (UnsupportedClassVersionError e4) {
            Logger log2 = Logger.getLogger(lookup.lookupClass().getName());
            if (Runtime.version().feature() == 19) {
                log2.warning("You are running with Java 19. To make full use of MMapDirectory, please pass '--enable-preview' to the Java command line.");
            } else {
                log2.warning("You are running with Java 20 or later. To make full use of MMapDirectory, please update Apache Lucene.");
            }
            return new MappedByteBufferIndexInputProvider();
        }
        catch (IllegalAccessException | NoSuchMethodException e5) {
            throw new LinkageError("MemorySegmentIndexInputProvider is missing correctly typed constructor", e5);
        }
    }

    static {
        PROVIDER = MMapDirectory.lookupProvider();
        DEFAULT_MAX_CHUNK_SIZE = PROVIDER.getDefaultMaxChunkSize();
        UNMAP_SUPPORTED = PROVIDER.isUnmapSupported();
        UNMAP_NOT_SUPPORTED_REASON = PROVIDER.getUnmapNotSupportedReason();
    }

    static interface MMapIndexInputProvider {
        public IndexInput openInput(Path var1, IOContext var2, int var3, boolean var4, boolean var5) throws IOException;

        public long getDefaultMaxChunkSize();

        public boolean isUnmapSupported();

        public String getUnmapNotSupportedReason();

        default public IOException convertMapFailedIOException(IOException ioe, String resourceDescription, long bufSize) {
            Throwable originalCause;
            String originalMessage;
            if (ioe.getCause() instanceof OutOfMemoryError) {
                originalMessage = "Map failed";
                originalCause = null;
            } else {
                originalMessage = ioe.getMessage();
                originalCause = ioe.getCause();
            }
            String moreInfo = !Constants.JRE_IS_64BIT ? "MMapDirectory should only be used on 64bit platforms, because the address space on 32bit operating systems is too small. " : (Constants.WINDOWS ? "Windows is unfortunately very limited on virtual address space. If your index size is several hundred Gigabytes, consider changing to Linux. " : (Constants.LINUX ? "Please review 'ulimit -v', 'ulimit -m' (both should return 'unlimited'), and 'sysctl vm.max_map_count'. " : "Please review 'ulimit -v', 'ulimit -m' (both should return 'unlimited'). "));
            IOException newIoe = new IOException(String.format(Locale.ENGLISH, "%s: %s [this may be caused by lack of enough unfragmented virtual address space or too restrictive virtual memory limits enforced by the operating system, preventing us to map a chunk of %d bytes. %sMore information: https://blog.thetaphi.de/2012/07/use-lucenes-mmapdirectory-on-64bit.html]", originalMessage, resourceDescription, bufSize, moreInfo), originalCause);
            newIoe.setStackTrace(ioe.getStackTrace());
            return newIoe;
        }
    }
}

