/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.rdfpatch.system;

import java.util.Iterator;
import java.util.function.Consumer;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.query.ReadWrite;
import org.apache.jena.query.TxnType;
import org.apache.jena.rdfpatch.RDFChanges;
import org.apache.jena.rdfpatch.system.GraphChanges;
import org.apache.jena.sparql.JenaTransactionException;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetGraphWrapper;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.core.Transactional;

public class DatasetGraphChanges
extends DatasetGraphWrapper {
    protected final Runnable syncHandler;
    protected final Consumer<ReadWrite> txnSyncHandler;
    protected final RDFChanges changesMonitor;
    private static Runnable identityRunnable = () -> {};
    private static final int DeleteBufferSize = 10000;
    private ThreadLocal<Boolean> insideBegin = ThreadLocal.withInitial(() -> false);

    private static <X> Consumer<X> identityConsumer() {
        return x -> {};
    }

    public DatasetGraphChanges(DatasetGraph dsg, RDFChanges monitor) {
        this(dsg, monitor, identityRunnable, DatasetGraphChanges.identityConsumer());
    }

    public DatasetGraphChanges(DatasetGraph dsg, RDFChanges changesMonitor, Runnable syncHandler, Consumer<ReadWrite> txnSyncHandler) {
        super(dsg);
        this.changesMonitor = changesMonitor;
        this.syncHandler = syncHandler == null ? identityRunnable : syncHandler;
        this.txnSyncHandler = txnSyncHandler == null ? DatasetGraphChanges.identityConsumer() : txnSyncHandler;
    }

    public RDFChanges getMonitor() {
        return this.changesMonitor;
    }

    @Override
    public void sync() {
        this.syncHandler.run();
        if (this.syncHandler != identityRunnable) {
            super.sync();
        }
    }

    @Override
    public void add(Quad quad) {
        this.add(quad.getGraph(), quad.getSubject(), quad.getPredicate(), quad.getObject());
    }

    @Override
    public void delete(Quad quad) {
        this.delete(quad.getGraph(), quad.getSubject(), quad.getPredicate(), quad.getObject());
    }

    @Override
    public void add(Node g, Node s, Node p, Node o) {
        this.requireWriteTxn();
        this.changesMonitor.add(g, s, p, o);
        super.add(g, s, p, o);
    }

    @Override
    public void delete(Node g, Node s, Node p, Node o) {
        this.requireWriteTxn();
        this.changesMonitor.delete(g, s, p, o);
        super.delete(g, s, p, o);
    }

    private void requireWriteTxn() {
        ReadWrite mode = this.transactionMode();
        if (mode == ReadWrite.WRITE) {
            return;
        }
        boolean b = this.promote();
        if (!b) {
            throw new JenaTransactionException("Can't write");
        }
    }

    @Override
    public Graph getDefaultGraph() {
        return new GraphChanges(this.get().getDefaultGraph(), null, this.changesMonitor);
    }

    @Override
    public Graph getGraph(Node graphNode) {
        return new GraphChanges(this.get().getGraph(graphNode), graphNode, this.changesMonitor);
    }

    @Override
    public void addGraph(Node graphName, Graph data) {
        this.removeGraph(graphName);
        data.find().forEachRemaining(t -> this.add(graphName, t.getSubject(), t.getPredicate(), t.getObject()));
    }

    @Override
    public void removeGraph(Node graphName) {
        this.deleteAny(graphName, Node.ANY, Node.ANY, Node.ANY);
    }

    @Override
    public void deleteAny(Node g, Node s, Node p, Node o) {
        int len;
        this.requireWriteTxn();
        Quad[] buffer = new Quad[10000];
        do {
            Iterator<Quad> iter = this.find(g, s, p, o);
            for (len = 0; len < 10000 && iter.hasNext(); ++len) {
                buffer[len] = iter.next();
            }
            for (int i = 0; i < len; ++i) {
                this.delete(buffer[i]);
                buffer[i] = null;
            }
        } while (len >= 10000);
    }

    @Override
    public void begin() {
        if (this.insideBegin.get().booleanValue()) {
            super.begin();
            return;
        }
        this.insideBegin.set(true);
        try {
            ReadWrite readWrite = this.transactionMode();
            if (readWrite == ReadWrite.WRITE) {
                this.changesMonitor.txnBegin();
            }
            this.txnSyncHandler.accept(readWrite);
            super.begin();
        }
        finally {
            this.insideBegin.set(false);
        }
        this.internalBegin();
    }

    protected void internalBegin() {
    }

    @Override
    public void begin(TxnType txnType) {
        if (this.insideBegin.get().booleanValue()) {
            super.begin(txnType);
            return;
        }
        this.insideBegin.set(true);
        try {
            if (txnType == TxnType.WRITE) {
                this.changesMonitor.txnBegin();
            }
            if (txnType != TxnType.READ) {
                this.txnSyncHandler.accept(ReadWrite.WRITE);
            } else {
                this.txnSyncHandler.accept(ReadWrite.READ);
            }
            super.begin(txnType);
        }
        finally {
            this.insideBegin.set(false);
        }
        this.internalBegin();
    }

    @Override
    public void begin(ReadWrite readWrite) {
        TxnType txnType = TxnType.convert(readWrite);
        this.begin(txnType);
    }

    @Override
    public boolean promote() {
        TxnType txnType = this.transactionType();
        if (txnType == null) {
            throw new JenaTransactionException("Not in a transaction");
        }
        switch (txnType) {
            case WRITE: {
                return true;
            }
            case READ: {
                return false;
            }
            case READ_PROMOTE: {
                return this.promote(Transactional.Promote.ISOLATED);
            }
            case READ_COMMITTED_PROMOTE: {
                return this.promote(Transactional.Promote.READ_COMMITTED);
            }
        }
        throw new JenaTransactionException("Can't determine promote '" + txnType + "'transaction");
    }

    @Override
    public boolean promote(Transactional.Promote type) {
        if (super.transactionMode() == ReadWrite.READ) {
            boolean b = super.promote(type);
            if (super.transactionMode() == ReadWrite.WRITE) {
                this.changesMonitor.txnBegin();
            }
            return b;
        }
        return super.promote(type);
    }

    @Override
    public void commit() {
        if (this.isWriteMode()) {
            try {
                this.changesMonitor.txnCommit();
            }
            catch (Exception ex) {
                super.abort();
                throw ex;
            }
        }
        super.commit();
    }

    @Override
    public void abort() {
        if (this.isWriteMode()) {
            this.changesMonitor.txnAbort();
        }
        super.abort();
    }

    private boolean isWriteMode() {
        return super.transactionMode() == ReadWrite.WRITE;
    }
}

