/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.irix;

import java.util.Objects;
import java.util.function.BiConsumer;
import org.apache.jena.irix.IRIException;
import org.apache.jena.irix.IRIProviderAny;
import org.apache.jena.irix.SystemIRIx;

public abstract class IRIx {
    private final String iriString;

    public static IRIx create(String iri2) throws IRIException {
        Objects.requireNonNull(iri2);
        return SystemIRIx.getProvider().create(iri2);
    }

    public static IRIx createAny(String iri2) throws IRIException {
        Objects.requireNonNull(iri2);
        return IRIProviderAny.stringProvider().create(iri2);
    }

    protected IRIx(String string) {
        this.iriString = string;
    }

    public abstract boolean isAbsolute();

    public abstract boolean isRelative();

    public abstract boolean hasScheme(String var1);

    public abstract boolean isReference();

    public abstract IRIx resolve(String var1);

    public abstract IRIx resolve(IRIx var1);

    public abstract IRIx normalize();

    public abstract IRIx relativize(IRIx var1);

    public abstract boolean hasViolations();

    public abstract void handleViolations(BiConsumer<Boolean, String> var1);

    public String str() {
        return this.iriString;
    }

    public abstract Object getImpl();

    public abstract int hashCode();

    public abstract boolean equals(Object var1);

    public String toString() {
        return this.iriString;
    }
}

