/*
 * Decompiled with CFR 0.152.
 */
package arq.cmdline;

import java.io.PrintStream;
import java.util.HashSet;
import java.util.Set;
import org.apache.jena.cmd.ArgDecl;
import org.apache.jena.cmd.CmdArgModule;
import org.apache.jena.cmd.CmdException;
import org.apache.jena.cmd.CmdGeneral;
import org.apache.jena.cmd.ModBase;
import org.apache.jena.ext.com.google.common.base.Objects;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFFormat;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.riot.RDFWriterRegistry;
import org.apache.jena.riot.system.StreamRDFWriter;

public class ModLangOutput
extends ModBase {
    protected ArgDecl argOutput = new ArgDecl(true, "out", "output");
    protected ArgDecl argPretty = new ArgDecl(true, "formatted", "pretty", "fmt");
    protected ArgDecl argStream = new ArgDecl(true, "stream");
    protected ArgDecl argCompress = new ArgDecl(false, "compress");
    private boolean compressedOutput = false;
    private RDFFormat streamOutput = null;
    private RDFFormat formattedOutput = null;
    private static Set<Lang> hiddenLanguages = new HashSet<Lang>();

    @Override
    public void registerWith(CmdGeneral cmdLine) {
        cmdLine.getUsage().startCategory("Output control");
        cmdLine.add(this.argOutput, "--output=FMT", "Output in the given format, streaming if possible.");
        cmdLine.add(this.argPretty, "--formatted=FMT", "Output, using pretty printing (consumes memory)");
        cmdLine.add(this.argStream, "--stream=FMT", "Output, using a streaming format");
        cmdLine.add(this.argCompress, "--compress", "Compress the output with gzip");
    }

    @Override
    public void processArgs(CmdArgModule cmdLine) {
        Lang lang;
        String langName;
        if (cmdLine.contains(this.argPretty)) {
            langName = cmdLine.getValue(this.argPretty);
            lang = RDFLanguages.nameToLang(langName);
            if (lang == null) {
                throw new CmdException("Not recognized as an RDF language : '" + langName + "'");
            }
            this.formattedOutput = RDFWriterRegistry.defaultSerialization(lang);
            if (this.formattedOutput == null) {
                System.err.println("Language '" + lang.getLabel() + "' not registered.");
                ModLangOutput.printRegistered(System.err);
                throw new CmdException("No output set: '" + langName + "'");
            }
        }
        if (cmdLine.contains(this.argStream)) {
            langName = cmdLine.getValue(this.argStream);
            lang = RDFLanguages.nameToLang(langName);
            if (lang == null) {
                throw new CmdException("Not recognized as an RDF language : '" + langName + "'");
            }
            this.streamOutput = StreamRDFWriter.defaultSerialization(lang);
            if (this.streamOutput == null) {
                System.err.println("Language '" + lang.getLabel() + "' not registered for streaming.");
                ModLangOutput.printRegistered(System.err);
                throw new CmdException("No output set: '" + langName + "'");
            }
        }
        if (cmdLine.contains(this.argOutput)) {
            langName = cmdLine.getValue(this.argOutput);
            lang = RDFLanguages.nameToLang(langName);
            if (lang == null) {
                throw new CmdException("Not recognized as an RDF language : '" + langName + "'");
            }
            if (StreamRDFWriter.registered(lang)) {
                this.streamOutput = StreamRDFWriter.defaultSerialization(lang);
            } else {
                this.formattedOutput = RDFWriterRegistry.defaultSerialization(lang);
                if (this.formattedOutput == null) {
                    System.err.println("Language '" + lang.getLabel() + "' not recognized.");
                    ModLangOutput.printRegistered(System.err);
                    throw new CmdException("No output set: '" + langName + "'");
                }
                if (Objects.equal(this.formattedOutput, RDFFormat.RDFXML_PRETTY)) {
                    this.formattedOutput = RDFFormat.RDFXML_PLAIN;
                }
            }
        }
        if (cmdLine.contains(this.argCompress)) {
            this.compressedOutput = true;
        }
        if (this.streamOutput == null && this.formattedOutput == null) {
            this.streamOutput = RDFFormat.NQUADS;
        }
    }

    private static void printRegistered(PrintStream out) {
        Lang lang;
        out.println("Streaming languages:");
        HashSet<Lang> seen = new HashSet<Lang>();
        for (RDFFormat fmt : StreamRDFWriter.registered()) {
            lang = fmt.getLang();
            if (hiddenLanguages.contains(lang) || seen.contains(lang)) continue;
            seen.add(lang);
            out.println("   " + lang.getLabel());
        }
        System.err.println("Non-streaming languages:");
        for (RDFFormat fmt : RDFWriterRegistry.registeredFormats()) {
            lang = fmt.getLang();
            if (hiddenLanguages.contains(lang) || seen.contains(lang)) continue;
            seen.add(lang);
            out.println("   " + lang.getLabel());
        }
    }

    public RDFFormat getOutputStreamFormat() {
        return this.streamOutput;
    }

    public RDFFormat getOutputFormatted() {
        return this.formattedOutput;
    }

    public boolean compressedOutput() {
        return this.compressedOutput;
    }

    static {
        hiddenLanguages.add(Lang.RDFNULL);
        hiddenLanguages.add(Lang.CSV);
    }
}

