/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.rdfs.setup;

import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.rdfs.engine.ConstRDFS;
import org.apache.jena.rdfs.engine.Match;
import org.apache.jena.rdfs.setup.ConfigRDFS;
import org.apache.jena.sparql.util.NodeUtils;

public class MatchVocabRDFS
implements Match<Node, Triple> {
    private final ConfigRDFS<Node> setup;

    public MatchVocabRDFS(ConfigRDFS<Node> setup) {
        this.setup = setup;
    }

    @Override
    public Stream<Triple> match(Node s, Node p, Node o) {
        Node sx = NodeUtils.nullToAny(s);
        Node px = NodeUtils.nullToAny(p);
        Node ox = NodeUtils.nullToAny(o);
        return this.match2(sx, px, ox);
    }

    private Stream<Triple> match2(Node s, Node p, Node o) {
        Map<Node, Set<Node>> map;
        if (p == Node.ANY) {
            Stream<Triple> stream = this.match(s, ConstRDFS.rdfsSubClassOf, o);
            stream = Stream.concat(stream, this.match(s, ConstRDFS.rdfsSubPropertyOf, o));
            stream = Stream.concat(stream, this.match(s, ConstRDFS.rdfsDomain, o));
            stream = Stream.concat(stream, this.match(s, ConstRDFS.rdfsRange, o));
            return stream;
        }
        if (o.isConcrete() && !s.isConcrete()) {
            Set<Node> set;
            if (p.equals(ConstRDFS.rdfsSubClassOf)) {
                set = this.setup.getSubClassesInc(o);
            } else if (p.equals(ConstRDFS.rdfsSubPropertyOf)) {
                set = this.setup.getSubPropertiesInc(o);
            } else if (p.equals(ConstRDFS.rdfsDomain)) {
                set = this.setup.getPropertiesByDomain(o);
            } else if (p.equals(ConstRDFS.rdfsRange)) {
                set = this.setup.getPropertiesByRange(o);
            } else {
                return Stream.empty();
            }
            return set.stream().map(x -> Triple.create(x, p, o));
        }
        if (p.equals(ConstRDFS.rdfsSubClassOf)) {
            map = this.setup.getSubClassHierarchy();
        } else if (p.equals(ConstRDFS.rdfsSubPropertyOf)) {
            map = this.setup.getSubPropertyHierarchy();
        } else if (p.equals(ConstRDFS.rdfsDomain)) {
            map = this.setup.getPropertyDomains();
        } else if (p.equals(ConstRDFS.rdfsRange)) {
            map = this.setup.getPropertyRanges();
        } else {
            return Stream.empty();
        }
        if (s.isConcrete()) {
            Set<Node> x2 = map.get(s);
            if (x2 == null) {
                return Stream.empty();
            }
            if (o.isConcrete()) {
                return x2.contains(o) ? Stream.of(Triple.create(s, p, o)) : Stream.empty();
            }
            return x2.stream().map(ox -> Triple.create(s, p, ox));
        }
        return map.entrySet().stream().flatMap(e2 -> ((Set)e2.getValue()).stream().map(obj -> Triple.create((Node)e2.getKey(), p, obj)));
    }
}

