/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.servlets;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.CharacterCodingException;
import java.util.Objects;
import java.util.function.BiConsumer;
import javax.servlet.ServletContext;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jena.atlas.RuntimeIOException;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.atlas.lib.Lib;
import org.apache.jena.atlas.web.AcceptList;
import org.apache.jena.atlas.web.ContentType;
import org.apache.jena.atlas.web.MediaType;
import org.apache.jena.fuseki.DEF;
import org.apache.jena.fuseki.Fuseki;
import org.apache.jena.fuseki.server.DataAccessPoint;
import org.apache.jena.fuseki.server.DataAccessPointRegistry;
import org.apache.jena.fuseki.servlets.HttpAction;
import org.apache.jena.fuseki.servlets.ServletOps;
import org.apache.jena.fuseki.system.ConNeg;
import org.apache.jena.fuseki.system.FusekiNetLib;
import org.apache.jena.graph.Graph;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.RDFFormat;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.riot.RDFParser;
import org.apache.jena.riot.RDFParserRegistry;
import org.apache.jena.riot.RDFWriterRegistry;
import org.apache.jena.riot.RiotException;
import org.apache.jena.riot.RiotParseException;
import org.apache.jena.riot.WebContent;
import org.apache.jena.riot.system.ErrorHandler;
import org.apache.jena.riot.system.ErrorHandlerFactory;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.riot.system.StreamRDFLib;
import org.apache.jena.shared.JenaException;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.graph.GraphFactory;

public class ActionLib {
    public static String mapRequestToEndpointName(HttpAction action, DataAccessPoint dataAccessPoint) {
        String uri = action.getActionURI();
        return ActionLib.mapRequestToEndpointName(uri, dataAccessPoint);
    }

    public static String mapRequestToEndpointName(String uri, DataAccessPoint dataAccessPoint) {
        if (dataAccessPoint == null) {
            return "";
        }
        String name = dataAccessPoint.getName();
        if (name.length() >= uri.length()) {
            return "";
        }
        if (name.equals("/")) {
            return uri.substring(1);
        }
        return uri.substring(name.length() + 1);
    }

    public static String unused_mapRequestToDatasetLongest(String uri, DataAccessPointRegistry registry) {
        if (uri == null) {
            return null;
        }
        String ds = null;
        for (String ds2 : registry.keys()) {
            if (!uri.startsWith(ds2)) continue;
            if (ds == null) {
                ds = ds2;
                continue;
            }
            if (ds.length() >= ds2.length()) continue;
            ds = ds2;
        }
        return ds;
    }

    public static String wholeRequestURL(HttpServletRequest request) {
        StringBuffer sb = request.getRequestURL();
        String queryString = request.getQueryString();
        if (queryString != null) {
            sb.append("?");
            sb.append(queryString);
        }
        return sb.toString();
    }

    public static String removeContextPath(HttpAction action) {
        return ActionLib.actionURI(action.getRequest());
    }

    public static String actionURI(HttpServletRequest request) {
        String uri = request.getRequestURI();
        ServletContext servletCxt = request.getServletContext();
        if (servletCxt == null) {
            return request.getRequestURI();
        }
        String contextPath = servletCxt.getContextPath();
        if (contextPath == null) {
            return uri;
        }
        if (contextPath.isEmpty()) {
            return uri;
        }
        String x = uri;
        if (uri.startsWith(contextPath)) {
            x = uri.substring(contextPath.length());
        }
        return x;
    }

    public static MediaType contentNegotation(HttpAction action, AcceptList myPrefs, MediaType defaultMediaType) {
        MediaType mt = ConNeg.chooseContentType(action.getRequest(), myPrefs, defaultMediaType);
        if (mt == null) {
            return null;
        }
        if (mt.getContentTypeStr() != null) {
            action.setResponseContentType(mt.getContentTypeStr());
        }
        if (mt.getCharset() != null) {
            action.setResponseCharacterEncoding(mt.getCharset());
        }
        return mt;
    }

    public static MediaType contentNegotationRDF(HttpAction action) {
        return ActionLib.contentNegotation(action, DEF.rdfOffer, DEF.acceptRDFXML);
    }

    public static MediaType contentNegotationQuads(HttpAction action) {
        return ActionLib.contentNegotation(action, DEF.quadsOffer, DEF.acceptNQuads);
    }

    public static String[] splitOnComma(String string) {
        String[] split = string.split(",");
        for (int i = 0; i < split.length; ++i) {
            split[i] = split[i].trim();
        }
        return split;
    }

    public static boolean splitContains(String[] elts, String str2) {
        for (int i = 0; i < elts.length; ++i) {
            if (!Lib.equals(elts[i], str2)) continue;
            return true;
        }
        return false;
    }

    public static void parseOrError(HttpAction action, StreamRDF dest, Lang lang, String base) {
        try {
            ActionLib.parse(action, dest, lang, base);
        }
        catch (RiotParseException ex) {
            ActionLib.consumeBody(action);
            ServletOps.errorParseError(ex);
        }
    }

    public static void parse(HttpAction action, StreamRDF dest, Lang lang, String base) {
        try {
            InputStream input = action.getRequestInputStream();
            ActionLib.parse(action, dest, input, lang, base);
        }
        catch (IOException ex) {
            IO.exception(ex);
        }
    }

    public static void parse(HttpAction action, StreamRDF dest, InputStream input, Lang lang, String base) {
        try {
            if (!RDFParserRegistry.isRegistered(lang)) {
                ServletOps.errorBadRequest("No parser for language '" + lang.getName() + "'");
            }
            ErrorHandler errorHandler = ErrorHandlerFactory.errorHandlerStd(action.log);
            RDFParser.create().errorHandler(errorHandler).source(input).lang(lang).base(base).parse(dest);
        }
        catch (RuntimeIOException ex) {
            if (ex.getCause() instanceof CharacterCodingException) {
                throw new RiotException("Character Coding Error: " + ex.getMessage());
            }
            throw ex;
        }
    }

    public static void consumeBody(HttpAction action) {
        try {
            if (action.getRequestContentLengthLong() > 0L) {
                InputStream input = action.getRequestInputStreamRaw();
                IO.skipToEnd(input);
            }
        }
        catch (IOException ex) {
            IO.exception(ex);
        }
    }

    public static Graph readFromRequest(HttpAction action, Lang defaultLang) {
        Lang lang;
        ContentType ct = ActionLib.getContentType(action);
        if (ct == null || ct.getContentTypeStr().isEmpty()) {
            lang = RDFLanguages.TURTLE;
        } else {
            if (ct.equals(WebContent.ctHTMLForm)) {
                ServletOps.errorBadRequest("HTML Form data sent to SHACL valdiation server");
                return null;
            }
            lang = RDFLanguages.contentTypeToLang(ct.getContentTypeStr());
            if (lang == null) {
                lang = defaultLang;
            }
        }
        Graph graph = GraphFactory.createDefaultGraph();
        StreamRDF dest = StreamRDFLib.graph(graph);
        ActionLib.parseOrError(action, dest, lang, null);
        return graph;
    }

    public static void datasetResponse(HttpAction action, DatasetGraph dsg, Lang lang) {
        Objects.requireNonNull(lang);
        RDFFormat format = ActionLib.getNetworkFormatForLang(lang);
        ActionLib.datasetResponse(action, dsg, format, null);
    }

    public static void datasetResponse(HttpAction action, DatasetGraph dsg, RDFFormat format, String contentType) {
        Objects.requireNonNull(dsg);
        Objects.requireNonNull(format);
        ActionLib.writeResponse(action, (out, fmt) -> RDFDataMgr.write(out, dsg, fmt), format, contentType);
    }

    public static void graphResponse(HttpAction action, Graph graph, Lang lang) {
        Objects.requireNonNull(lang);
        RDFFormat format = ActionLib.getNetworkFormatForLang(lang);
        ActionLib.graphResponse(action, graph, format, null);
    }

    public static void graphResponse(HttpAction action, Graph graph, RDFFormat format, String contentType) {
        Objects.requireNonNull(graph);
        Objects.requireNonNull(format);
        ActionLib.writeResponse(action, (out, fmt) -> RDFDataMgr.write(out, graph, fmt), format, contentType);
    }

    public static RDFFormat getNetworkFormatForLang(Lang lang) {
        Objects.requireNonNull(lang);
        return lang == Lang.RDFXML ? RDFFormat.RDFXML_PLAIN : RDFWriterRegistry.defaultSerialization(lang);
    }

    private static void writeResponse(HttpAction action, BiConsumer<OutputStream, RDFFormat> writeAction, RDFFormat fmt, String actualContentType) {
        String ct = actualContentType;
        Lang lang = fmt.getLang();
        if (ct == null) {
            ct = lang.getContentType().toHeaderString();
        }
        try {
            boolean materializeFirst;
            ServletOutputStream out = action.getResponseOutputStream();
            boolean bl = materializeFirst = lang == Lang.RDFXML;
            if (materializeFirst) {
                byte[] bytes;
                try (ByteArrayOutputStream bout = new ByteArrayOutputStream(102400);){
                    writeAction.accept(bout, fmt);
                    bytes = bout.toByteArray();
                }
                catch (JenaException ex) {
                    action.log.warn(String.format("[%d] Failed to produce %s: %s", action.id, lang.getLabel(), ex.getMessage()));
                    ServletOps.error(406);
                    return;
                }
                action.setResponseContentLength(bytes.length);
                action.setResponseContentType(ct);
                action.setResponseStatus(200);
                out.write(bytes);
            } else {
                action.setResponseContentType(ct);
                writeAction.accept(out, fmt);
            }
            out.flush();
        }
        catch (IOException ex) {
            IO.exception(ex);
        }
    }

    public static String getOneHeader(HttpServletRequest request, String name) {
        String[] values = request.getParameterValues(name);
        if (values == null) {
            return null;
        }
        if (values.length == 0) {
            return null;
        }
        if (values.length > 1) {
            ServletOps.errorBadRequest("Multiple occurrences of '" + name + "'");
        }
        return values[0];
    }

    public static ContentType getContentType(HttpAction action) {
        return FusekiNetLib.getContentType(action.getRequest());
    }

    public static void setCommonHeadersForOptions(HttpAction action) {
        ActionLib.setCommonHeadersForOptions(action.getResponse());
    }

    private static void setCommonHeadersForOptions(HttpServletResponse httpResponse) {
        ActionLib.setCommonHeaders(httpResponse);
    }

    public static void setCommonHeaders(HttpAction action) {
        ActionLib.setCommonHeaders(action.getResponse());
    }

    private static void setCommonHeaders(HttpServletResponse httpResponse) {
        if (Fuseki.outputFusekiServerHeader) {
            httpResponse.setHeader("Server", Fuseki.serverHttpName);
        }
    }

    private static String extractItemName(HttpAction action) {
        String x1 = action.getRequestServletPath();
        String x2 = action.getRequestPathInfo();
        String pathInfo = action.getRequestPathInfo();
        if (pathInfo == null || pathInfo.isEmpty() || pathInfo.equals("/")) {
            return null;
        }
        String name = pathInfo;
        int idx = pathInfo.lastIndexOf(47);
        if (idx > 0) {
            name = name.substring(idx);
        }
        return name;
    }

    public static void doOptionsGet(HttpAction action) {
        ActionLib.setCommonHeadersForOptions(action);
        action.setResponseHeader("Allow", "GET,OPTIONS");
    }

    public static void doOptionsGetHead(HttpAction action) {
        ActionLib.setCommonHeadersForOptions(action);
        action.setResponseHeader("Allow", "GET,HEAD,OPTIONS");
    }

    public static void doOptionsGetPost(HttpAction action) {
        ActionLib.setCommonHeadersForOptions(action);
        action.setResponseHeader("Allow", "GET,POST,OPTIONS");
    }

    public static void doOptionsGetPostHead(HttpAction action) {
        ActionLib.setCommonHeadersForOptions(action);
        action.setResponseHeader("Allow", "GET,POST,HEAD,OPTIONS");
    }

    public static void doOptionsGetPostDelete(HttpAction action) {
        ActionLib.setCommonHeadersForOptions(action);
        action.setResponseHeader("Allow", "GET,POST,DELETE,OPTIONS");
    }

    public static void doOptionsGetPostDeleteHead(HttpAction action) {
        ActionLib.setCommonHeadersForOptions(action);
        action.setResponseHeader("Allow", "GET,HEAD,POST,DELETE,OPTIONS");
    }

    public static void doOptionsPost(HttpAction action) {
        ActionLib.setCommonHeadersForOptions(action);
        action.setResponseHeader("Allow", "POST,OPTIONS");
    }
}

