/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.session.mgt;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import org.apache.shiro.cache.CacheManager;
import org.apache.shiro.cache.CacheManagerAware;
import org.apache.shiro.session.Session;
import org.apache.shiro.session.UnknownSessionException;
import org.apache.shiro.session.mgt.AbstractValidatingSessionManager;
import org.apache.shiro.session.mgt.SessionContext;
import org.apache.shiro.session.mgt.SessionFactory;
import org.apache.shiro.session.mgt.SessionKey;
import org.apache.shiro.session.mgt.SimpleSession;
import org.apache.shiro.session.mgt.SimpleSessionFactory;
import org.apache.shiro.session.mgt.eis.MemorySessionDAO;
import org.apache.shiro.session.mgt.eis.SessionDAO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSessionManager
extends AbstractValidatingSessionManager
implements CacheManagerAware {
    private static final Logger log = LoggerFactory.getLogger(DefaultSessionManager.class);
    private SessionFactory sessionFactory = new SimpleSessionFactory();
    protected SessionDAO sessionDAO = new MemorySessionDAO();
    private CacheManager cacheManager;
    private boolean deleteInvalidSessions = true;

    public void setSessionDAO(SessionDAO sessionDAO) {
        this.sessionDAO = sessionDAO;
        this.applyCacheManagerToSessionDAO();
    }

    public SessionDAO getSessionDAO() {
        return this.sessionDAO;
    }

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public boolean isDeleteInvalidSessions() {
        return this.deleteInvalidSessions;
    }

    public void setDeleteInvalidSessions(boolean deleteInvalidSessions) {
        this.deleteInvalidSessions = deleteInvalidSessions;
    }

    @Override
    public void setCacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
        this.applyCacheManagerToSessionDAO();
    }

    private void applyCacheManagerToSessionDAO() {
        if (this.cacheManager != null && this.sessionDAO != null && this.sessionDAO instanceof CacheManagerAware) {
            ((CacheManagerAware)((Object)this.sessionDAO)).setCacheManager(this.cacheManager);
        }
    }

    @Override
    protected Session doCreateSession(SessionContext context2) {
        Session s = this.newSessionInstance(context2);
        if (log.isTraceEnabled()) {
            log.trace("Creating session for host {}", (Object)s.getHost());
        }
        this.create(s);
        return s;
    }

    protected Session newSessionInstance(SessionContext context2) {
        return this.getSessionFactory().createSession(context2);
    }

    protected void create(Session session) {
        if (log.isDebugEnabled()) {
            log.debug("Creating new EIS record for new session instance [" + session + "]");
        }
        this.sessionDAO.create(session);
    }

    @Override
    protected void onStop(Session session) {
        if (session instanceof SimpleSession) {
            SimpleSession ss = (SimpleSession)session;
            Date stopTs = ss.getStopTimestamp();
            ss.setLastAccessTime(stopTs);
        }
        this.onChange(session);
    }

    @Override
    protected void afterStopped(Session session) {
        if (this.isDeleteInvalidSessions()) {
            this.delete(session);
        }
    }

    @Override
    protected void onExpiration(Session session) {
        if (session instanceof SimpleSession) {
            ((SimpleSession)session).setExpired(true);
        }
        this.onChange(session);
    }

    @Override
    protected void afterExpired(Session session) {
        if (this.isDeleteInvalidSessions()) {
            this.delete(session);
        }
    }

    @Override
    protected void onChange(Session session) {
        this.sessionDAO.update(session);
    }

    @Override
    protected Session retrieveSession(SessionKey sessionKey) throws UnknownSessionException {
        Serializable sessionId = this.getSessionId(sessionKey);
        if (sessionId == null) {
            log.debug("Unable to resolve session ID from SessionKey [{}].  Returning null to indicate a session could not be found.", (Object)sessionKey);
            return null;
        }
        Session s = this.retrieveSessionFromDataSource(sessionId);
        if (s == null) {
            String msg = "Could not find session with ID [" + sessionId + "]";
            throw new UnknownSessionException(msg);
        }
        return s;
    }

    protected Serializable getSessionId(SessionKey sessionKey) {
        return sessionKey.getSessionId();
    }

    protected Session retrieveSessionFromDataSource(Serializable sessionId) throws UnknownSessionException {
        return this.sessionDAO.readSession(sessionId);
    }

    protected void delete(Session session) {
        this.sessionDAO.delete(session);
    }

    @Override
    protected Collection<Session> getActiveSessions() {
        Collection<Session> active = this.sessionDAO.getActiveSessions();
        return active != null ? active : Collections.emptySet();
    }
}

