/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.shex.expressions;

import java.util.Objects;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.riot.out.NodeFormatter;
import org.apache.jena.shex.expressions.Cardinality;
import org.apache.jena.shex.expressions.ShapeExpression;
import org.apache.jena.shex.expressions.TripleExprVisitor;
import org.apache.jena.shex.expressions.TripleExpression;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TripleConstraint
extends TripleExpression {
    private static Logger LOG = LoggerFactory.getLogger(TripleConstraint.class);
    private final Node label;
    private final Node predicate;
    private final ShapeExpression shapeExpression;
    private final boolean reverse;
    private final Cardinality cardinality;
    private final int min;
    private final int max;

    public TripleConstraint(Node label, Node predicate, boolean reverse, ShapeExpression valueExpr, Cardinality cardinality) {
        this.label = label;
        this.predicate = predicate;
        this.reverse = reverse;
        this.shapeExpression = valueExpr;
        this.cardinality = cardinality;
        this.min = cardinality == null ? 1 : cardinality.min;
        this.max = cardinality == null ? 1 : cardinality.max;
    }

    public String cardinalityString() {
        if (this.cardinality == null) {
            return "";
        }
        return this.cardinality.image;
    }

    public Node label() {
        return this.label;
    }

    public int min() {
        return this.min;
    }

    public int max() {
        return this.max;
    }

    public Node getPredicate() {
        return this.predicate;
    }

    public ShapeExpression getShapeExpression() {
        return this.shapeExpression;
    }

    public boolean reverse() {
        return this.reverse;
    }

    private static Node value(Triple triple, boolean reverse) {
        return reverse ? triple.getSubject() : triple.getObject();
    }

    @Override
    public void visit(TripleExprVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void print(IndentedWriter iOut, NodeFormatter nFmt) {
        iOut.print("TripleConstraint");
        if (this.label != null) {
            iOut.print(" $");
            nFmt.format(iOut, this.label);
        }
        iOut.println(" {");
        iOut.incIndent();
        iOut.printf("predicate = ", new Object[0]);
        if (this.reverse) {
            iOut.print("^");
        }
        nFmt.format(iOut, this.predicate);
        iOut.println();
        this.shapeExpression.print(iOut, nFmt);
        if (this.cardinality != null) {
            iOut.print(this.cardinality.toString());
            iOut.println();
        }
        iOut.decIndent();
        iOut.println("}");
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.max, this.min, this.predicate, this.reverse, this.shapeExpression);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TripleConstraint other = (TripleConstraint)obj;
        return this.max == other.max && this.min == other.min && Objects.equals(this.predicate, other.predicate) && this.reverse == other.reverse && Objects.equals(this.shapeExpression, other.shapeExpression);
    }

    @Override
    public String toString() {
        Object cardStr = "";
        if (!this.cardinalityString().isEmpty()) {
            cardStr = "cardinality=" + this.cardinalityString() + ", ";
        }
        Object s = "TripleConstraint";
        if (this.label != null) {
            s = (String)s + "($" + this.label + ")";
        }
        return (String)s + " [predicate=" + this.predicate + ", " + (String)cardStr + "shapeExpr=" + this.shapeExpression + "]";
    }
}

