/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.rdflink;

import java.util.Objects;
import org.apache.jena.atlas.lib.InternalErrorException;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.query.Query;
import org.apache.jena.query.ReadWrite;
import org.apache.jena.query.TxnType;
import org.apache.jena.rdfconnection.Isolation;
import org.apache.jena.rdflink.LibRDFLink;
import org.apache.jena.rdflink.RDFLink;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.riot.other.G;
import org.apache.jena.sparql.ARQException;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetGraphFactory;
import org.apache.jena.sparql.core.DatasetGraphReadOnly;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.core.Transactional;
import org.apache.jena.sparql.exec.QueryExec;
import org.apache.jena.sparql.exec.QueryExecApp;
import org.apache.jena.sparql.exec.QueryExecBuilder;
import org.apache.jena.sparql.exec.UpdateExec;
import org.apache.jena.sparql.exec.UpdateExecBuilder;
import org.apache.jena.sparql.exec.UpdateExecDatasetBuilder;
import org.apache.jena.sparql.graph.GraphFactory;
import org.apache.jena.sparql.graph.GraphReadOnly;
import org.apache.jena.system.Txn;
import org.apache.jena.update.UpdateRequest;

public class RDFLinkDataset
implements RDFLink {
    private ThreadLocal<Boolean> transactionActive = ThreadLocal.withInitial(() -> false);
    private DatasetGraph dataset;
    private final Isolation isolation;

    private RDFLinkDataset(DatasetGraph dataset) {
        this(dataset, Isolation.NONE);
    }

    RDFLinkDataset(DatasetGraph dataset, Isolation isolation) {
        this.dataset = dataset;
        this.isolation = isolation;
    }

    @Override
    public QueryExec query(Query query2) {
        this.checkOpen();
        return QueryExecApp.create(QueryExec.dataset(this.dataset).query(query2), this.dataset, query2, null);
    }

    @Override
    public QueryExecBuilder newQuery() {
        return QueryExec.dataset(this.dataset);
    }

    @Override
    public UpdateExecBuilder newUpdate() {
        return UpdateExec.dataset(this.dataset);
    }

    @Override
    public void update(UpdateRequest update2) {
        this.checkOpen();
        Txn.executeWrite(this.dataset, () -> UpdateExecDatasetBuilder.create().update(update2).execute(this.dataset));
    }

    @Override
    public void load(Node graphName, String file) {
        this.checkOpen();
        this.doPutPost(graphName, file, false);
    }

    @Override
    public void load(String file) {
        this.checkOpen();
        this.doPutPost(null, file, false);
    }

    @Override
    public void load(Node graphName, Graph graphSrc) {
        this.checkOpen();
        Txn.executeWrite(this.dataset, () -> {
            Graph graphDst = this.graphFor(graphName);
            G.copyGraphSrcToDst(graphSrc, graphDst);
        });
    }

    @Override
    public void load(Graph graph) {
        this.load(null, graph);
    }

    @Override
    public Graph get(Node graphName) {
        this.checkOpen();
        return Txn.calculateRead(this.dataset, () -> {
            Graph graph = this.graphFor(graphName);
            return this.isolate(graph);
        });
    }

    @Override
    public Graph get() {
        this.checkOpen();
        return this.get(null);
    }

    @Override
    public void put(String file) {
        this.checkOpen();
        this.doPutPost(null, file, true);
    }

    @Override
    public void put(Node graphName, String file) {
        this.checkOpen();
        this.doPutPost(graphName, file, true);
    }

    @Override
    public void put(Graph graph) {
        this.put(null, graph);
    }

    @Override
    public void put(Node graphName, Graph graph) {
        this.checkOpen();
        Txn.executeWrite(this.dataset, () -> {
            Graph graphDst = this.graphFor(graphName);
            G.clear(graphDst);
            G.copyGraphSrcToDst(graph, graphDst);
        });
    }

    @Override
    public void delete(Node graphName) {
        this.checkOpen();
        Txn.executeWrite(this.dataset, () -> {
            if (LibRDFLink.isDefault(graphName)) {
                G.clear(this.dataset.getDefaultGraph());
            } else {
                G.clear(this.dataset.getGraph(graphName));
            }
        });
    }

    @Override
    public void delete() {
        this.checkOpen();
        this.delete(null);
    }

    private void doPutPost(Node graphName, String file, boolean replace) {
        Objects.requireNonNull(file);
        Lang lang = RDFLanguages.filenameToLang(file);
        Txn.executeWrite(this.dataset, () -> {
            if (RDFLanguages.isTriples(lang)) {
                Graph graph;
                Graph graph2 = graph = LibRDFLink.isDefault(graphName) ? this.dataset.getDefaultGraph() : this.dataset.getGraph(graphName);
                if (replace) {
                    G.clear(graph);
                }
                RDFDataMgr.read(graph, file);
            } else if (RDFLanguages.isQuads(lang)) {
                if (replace) {
                    this.dataset.clear();
                }
                RDFDataMgr.read(this.dataset, file);
            } else {
                throw new ARQException("Not an RDF format: " + file + " (lang=" + lang + ")");
            }
        });
    }

    private Graph isolate(Graph graph) {
        switch (this.isolation) {
            case COPY: {
                Graph graph2 = GraphFactory.createDefaultGraph();
                G.copyGraphSrcToDst(graph, graph2);
                return graph2;
            }
            case READONLY: {
                GraphReadOnly graph2 = new GraphReadOnly(graph);
                return graph2;
            }
            case NONE: {
                return graph;
            }
        }
        throw new InternalErrorException();
    }

    private DatasetGraph isolate(DatasetGraph dataset) {
        switch (this.isolation) {
            case COPY: {
                DatasetGraph dsg2 = DatasetGraphFactory.create();
                dataset.find().forEachRemaining(q -> dsg2.add((Quad)q));
                return dsg2;
            }
            case READONLY: {
                DatasetGraphReadOnly dsg = new DatasetGraphReadOnly(dataset);
                return dsg;
            }
            case NONE: {
                return dataset;
            }
        }
        throw new InternalErrorException();
    }

    private Graph graphFor(Node graphName) {
        if (LibRDFLink.isDefault(graphName)) {
            return this.dataset.getDefaultGraph();
        }
        return this.dataset.getGraph(graphName);
    }

    @Override
    public DatasetGraph getDataset() {
        this.checkOpen();
        return Txn.calculateRead(this.dataset, () -> this.isolate(this.dataset));
    }

    @Override
    public void loadDataset(String file) {
        this.checkOpen();
        Txn.executeWrite(this.dataset, () -> RDFDataMgr.read(this.dataset, file));
    }

    @Override
    public void loadDataset(DatasetGraph srcDataset) {
        this.checkOpen();
        srcDataset.executeRead(() -> this.dataset.executeWrite(() -> srcDataset.find().forEachRemaining(q -> this.dataset.add((Quad)q))));
    }

    @Override
    public void putDataset(String file) {
        this.checkOpen();
        Txn.executeWrite(this.dataset, () -> {
            this.dataset.clear();
            RDFDataMgr.read(this.dataset, file);
        });
    }

    @Override
    public void putDataset(DatasetGraph dataset) {
        this.checkOpen();
        Txn.executeWrite(dataset, () -> {
            this.dataset = this.isolate(dataset);
        });
    }

    @Override
    public void clearDataset() {
        this.checkOpen();
        Txn.executeWrite(this.dataset, this.dataset::clear);
    }

    @Override
    public void close() {
        this.dataset = null;
    }

    @Override
    public boolean isClosed() {
        return this.dataset == null;
    }

    private void checkOpen() {
        if (this.dataset == null) {
            throw new ARQException("closed");
        }
    }

    @Override
    public void begin() {
        this.dataset.begin();
    }

    @Override
    public void begin(TxnType txnType) {
        this.dataset.begin(txnType);
    }

    @Override
    public void begin(ReadWrite mode) {
        this.dataset.begin(mode);
    }

    @Override
    public boolean promote(Transactional.Promote promote) {
        return this.dataset.promote(promote);
    }

    @Override
    public void commit() {
        this.dataset.commit();
    }

    @Override
    public void abort() {
        this.dataset.abort();
    }

    @Override
    public boolean isInTransaction() {
        return this.dataset.isInTransaction();
    }

    @Override
    public void end() {
        this.dataset.end();
    }

    @Override
    public ReadWrite transactionMode() {
        return this.dataset.transactionMode();
    }

    @Override
    public TxnType transactionType() {
        return this.dataset.transactionType();
    }
}

