/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.server;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.jena.fuseki.Fuseki;
import org.apache.jena.fuseki.auth.Auth;
import org.apache.jena.fuseki.server.DataAccessPoint;
import org.apache.jena.fuseki.server.DataAccessPointRegistry;
import org.apache.jena.fuseki.server.DataService;
import org.apache.jena.fuseki.server.Endpoint;
import org.apache.jena.fuseki.server.EndpointSet;
import org.apache.jena.fuseki.server.Operation;
import org.apache.jena.fuseki.servlets.ActionExecLib;
import org.apache.jena.fuseki.servlets.ActionLib;
import org.apache.jena.fuseki.servlets.ActionProcessor;
import org.apache.jena.fuseki.servlets.HttpAction;
import org.apache.jena.fuseki.servlets.ServletOps;
import org.apache.jena.fuseki.system.ActionCategory;
import org.apache.jena.web.HttpSC;
import org.slf4j.Logger;

public class Dispatcher {
    private static final boolean LogDispatch = false;
    private static Logger LOG = Fuseki.serverLog;

    public static boolean dispatch(HttpServletRequest request, HttpServletResponse response) {
        DataAccessPointRegistry registry = DataAccessPointRegistry.get(request.getServletContext());
        DataAccessPoint dap = Dispatcher.locateDataAccessPoint(request, registry);
        if (dap == null) {
            return false;
        }
        return Dispatcher.process(dap, request, response);
    }

    private static DataAccessPoint locateDataAccessPoint(HttpServletRequest request, DataAccessPointRegistry registry) {
        String uri = ActionLib.actionURI(request);
        DataAccessPoint dap = Dispatcher.locateDataAccessPoint(uri, registry);
        return dap;
    }

    static DataAccessPoint locateDataAccessPoint(String uri, DataAccessPointRegistry registry) {
        if (registry.isRegistered(uri)) {
            return registry.get(uri);
        }
        String datasetUri = Dispatcher.removeFinalComponent(uri);
        if (datasetUri == null) {
            return null;
        }
        if (registry.isRegistered(datasetUri)) {
            return registry.get(datasetUri);
        }
        return null;
    }

    private static String removeFinalComponent(String uri) {
        int i = uri.lastIndexOf(47);
        if (i == -1) {
            return null;
        }
        if (i == 0) {
            return "/";
        }
        return uri.substring(0, i);
    }

    private static String mapRequestToEndpointName(HttpAction action, DataAccessPoint dataAccessPoint) {
        return ActionLib.mapRequestToEndpointName(action, dataAccessPoint);
    }

    private static boolean process(DataAccessPoint dap, HttpServletRequest request, HttpServletResponse response) {
        HttpAction action = ActionExecLib.allocHttpAction(dap, Fuseki.actionLog, ActionCategory.ACTION, request, response);
        return Dispatcher.dispatchAction(action);
    }

    private static boolean dispatchAction(HttpAction action) {
        return ActionExecLib.execAction(action, () -> Dispatcher.chooseProcessor(action));
    }

    private static ActionProcessor chooseProcessor(HttpAction action) {
        DataAccessPoint dataAccessPoint = action.getDataAccessPoint();
        DataService dataService = action.getDataService();
        if (!dataService.isAcceptingRequests()) {
            ServletOps.error(503, "Dataset not currently active");
            return null;
        }
        String endpointName = Dispatcher.mapRequestToEndpointName(action, dataAccessPoint);
        Endpoint endpoint = Dispatcher.chooseEndpoint(action, dataService, endpointName);
        if (endpoint == null) {
            return null;
        }
        Operation operation = endpoint.getOperation();
        if (operation == null) {
            ServletOps.errorNotFound("No operation: " + action.getActionURI());
            return null;
        }
        action.setEndpoint(endpoint);
        String user = action.getUser();
        if (dataService.authPolicy() != null && !dataService.authPolicy().isAllowed(user)) {
            ServletOps.errorForbidden();
        }
        Auth.allow(user, action.getEndpoint().getAuthPolicy(), ServletOps::errorForbidden);
        ActionProcessor processor = endpoint.getProcessor();
        if (processor == null) {
            ServletOps.errorBadRequest(String.format("No processor: dataset=%s: op=%s", dataAccessPoint.getName(), operation.getName()));
        }
        return processor;
    }

    private static Endpoint chooseEndpoint(HttpAction action, DataService dataService, String endpointName) {
        EndpointSet epSet;
        EndpointSet endpointSet = epSet = StringUtils.isEmpty(endpointName) ? dataService.getEndpointSet() : dataService.getEndpointSet(endpointName);
        if (epSet == null || epSet.isEmpty()) {
            if (!StringUtils.isAnyEmpty(endpointName)) {
                return null;
            }
            ServletOps.errorBadRequest("No endpoint for request");
            return null;
        }
        Endpoint ep = epSet.getExactlyOne();
        if (ep != null) {
            return ep;
        }
        Operation operation = Dispatcher.chooseOperation(action);
        ep = epSet.get(operation);
        if (ep == null) {
            if (Operation.GSP_R.equals(operation)) {
                ep = epSet.get(Operation.GSP_RW);
            } else if (Operation.GSP_RW.equals(operation) && epSet.contains(Operation.GSP_R)) {
                ServletOps.errorMethodNotAllowed(action.getMethod());
            }
        }
        if (ep == null) {
            ServletOps.errorBadRequest("No operation for request: " + action.getActionURI());
        }
        return ep;
    }

    private static Operation chooseOperation(HttpAction action) {
        boolean hasParams;
        boolean hasParamGraphDefault;
        Operation operation;
        int idx;
        boolean isUpdate;
        boolean isQuery;
        HttpServletRequest request = action.getRequest();
        boolean bl = isQuery = request.getParameter("query") != null;
        if (isQuery) {
            return Operation.Query;
        }
        boolean bl2 = isUpdate = request.getParameter("update") != null || request.getParameter("request") != null;
        if (isUpdate) {
            return Operation.Update;
        }
        String ct = request.getContentType();
        if (ct != null && (idx = ct.indexOf(59)) > 0) {
            ct = ct.substring(0, idx);
        }
        if (ct != null && (operation = action.getOperationRegistry().findByContentType(ct)) != null) {
            return operation;
        }
        boolean hasParamGraph = request.getParameter("graph") != null;
        boolean bl3 = hasParamGraphDefault = request.getParameter("default") != null;
        if (hasParamGraph || hasParamGraphDefault) {
            return Dispatcher.gspOperation(action, request);
        }
        boolean bl4 = hasParams = request.getParameterMap().size() > 0;
        if (hasParams) {
            if ("application/x-www-form-urlencoded".equals(request.getContentType())) {
                ServletOps.errorBadRequest("Malformed request: unrecognized HTML form request");
                return null;
            }
            String qs = request.getQueryString();
            if (qs != null) {
                ServletOps.errorBadRequest("Malformed request: unrecognized parameters: " + qs);
            } else {
                ServletOps.errorBadRequest(HttpSC.getMessage(400));
            }
        }
        return Dispatcher.quadsOperation(action, request);
    }

    private static Operation gspOperation(HttpAction action, HttpServletRequest request) {
        if (Dispatcher.isReadMethod(request)) {
            return Operation.GSP_R;
        }
        return Operation.GSP_RW;
    }

    private static Operation quadsOperation(HttpAction action, HttpServletRequest request) {
        if (Dispatcher.isReadMethod(request)) {
            return Operation.GSP_R;
        }
        return Operation.GSP_RW;
    }

    private static boolean isReadMethod(HttpServletRequest request) {
        String method = request.getMethod();
        boolean isGET = method.equals("GET");
        boolean isHEAD = method.equals("HEAD");
        return isGET || isHEAD;
    }
}

