/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.subject;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.shiro.subject.MutablePrincipalCollection;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.shiro.util.CollectionUtils;
import org.apache.shiro.util.StringUtils;

public class SimplePrincipalCollection
implements MutablePrincipalCollection {
    private static final long serialVersionUID = -6305224034025797558L;
    private Map<String, Set> realmPrincipals;
    private transient String cachedToString;

    public SimplePrincipalCollection() {
    }

    public SimplePrincipalCollection(Object principal, String realmName) {
        if (principal instanceof Collection) {
            this.addAll((Collection)principal, realmName);
        } else {
            this.add(principal, realmName);
        }
    }

    public SimplePrincipalCollection(Collection principals, String realmName) {
        this.addAll(principals, realmName);
    }

    public SimplePrincipalCollection(PrincipalCollection principals) {
        this.addAll(principals);
    }

    protected Collection getPrincipalsLazy(String realmName) {
        LinkedHashSet principals;
        if (this.realmPrincipals == null) {
            this.realmPrincipals = new LinkedHashMap<String, Set>();
        }
        if ((principals = this.realmPrincipals.get(realmName)) == null) {
            principals = new LinkedHashSet();
            this.realmPrincipals.put(realmName, principals);
        }
        return principals;
    }

    @Override
    public Object getPrimaryPrincipal() {
        if (this.isEmpty()) {
            return null;
        }
        return this.iterator().next();
    }

    @Override
    public void add(Object principal, String realmName) {
        if (realmName == null) {
            throw new NullPointerException("realmName argument cannot be null.");
        }
        if (principal == null) {
            throw new NullPointerException("principal argument cannot be null.");
        }
        this.cachedToString = null;
        this.getPrincipalsLazy(realmName).add(principal);
    }

    @Override
    public void addAll(Collection principals, String realmName) {
        if (realmName == null) {
            throw new NullPointerException("realmName argument cannot be null.");
        }
        if (principals == null) {
            throw new NullPointerException("principals argument cannot be null.");
        }
        if (principals.isEmpty()) {
            throw new IllegalArgumentException("principals argument cannot be an empty collection.");
        }
        this.cachedToString = null;
        this.getPrincipalsLazy(realmName).addAll(principals);
    }

    @Override
    public void addAll(PrincipalCollection principals) {
        if (principals.getRealmNames() != null) {
            for (String realmName : principals.getRealmNames()) {
                for (Object principal : principals.fromRealm(realmName)) {
                    this.add(principal, realmName);
                }
            }
        }
    }

    @Override
    public <T> T oneByType(Class<T> type) {
        if (this.realmPrincipals == null || this.realmPrincipals.isEmpty()) {
            return null;
        }
        Collection<Set> values = this.realmPrincipals.values();
        for (Set set : values) {
            for (Object o : set) {
                if (!type.isAssignableFrom(o.getClass())) continue;
                return (T)o;
            }
        }
        return null;
    }

    @Override
    public <T> Collection<T> byType(Class<T> type) {
        if (this.realmPrincipals == null || this.realmPrincipals.isEmpty()) {
            return Collections.EMPTY_SET;
        }
        LinkedHashSet typed = new LinkedHashSet();
        Collection<Set> values = this.realmPrincipals.values();
        for (Set set : values) {
            for (Object o : set) {
                if (!type.isAssignableFrom(o.getClass())) continue;
                typed.add(o);
            }
        }
        if (typed.isEmpty()) {
            return Collections.EMPTY_SET;
        }
        return Collections.unmodifiableSet(typed);
    }

    @Override
    public List asList() {
        Set all = this.asSet();
        if (all.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        return Collections.unmodifiableList(new ArrayList(all));
    }

    @Override
    public Set asSet() {
        if (this.realmPrincipals == null || this.realmPrincipals.isEmpty()) {
            return Collections.EMPTY_SET;
        }
        LinkedHashSet aggregated = new LinkedHashSet();
        Collection<Set> values = this.realmPrincipals.values();
        for (Set set : values) {
            aggregated.addAll(set);
        }
        if (aggregated.isEmpty()) {
            return Collections.EMPTY_SET;
        }
        return Collections.unmodifiableSet(aggregated);
    }

    @Override
    public Collection fromRealm(String realmName) {
        if (this.realmPrincipals == null || this.realmPrincipals.isEmpty()) {
            return Collections.EMPTY_SET;
        }
        Set principals = this.realmPrincipals.get(realmName);
        if (principals == null || principals.isEmpty()) {
            principals = Collections.EMPTY_SET;
        }
        return Collections.unmodifiableSet(principals);
    }

    @Override
    public Set<String> getRealmNames() {
        if (this.realmPrincipals == null) {
            return null;
        }
        return this.realmPrincipals.keySet();
    }

    @Override
    public boolean isEmpty() {
        return this.realmPrincipals == null || this.realmPrincipals.isEmpty();
    }

    @Override
    public void clear() {
        this.cachedToString = null;
        if (this.realmPrincipals != null) {
            this.realmPrincipals.clear();
            this.realmPrincipals = null;
        }
    }

    public Iterator iterator() {
        return this.asSet().iterator();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof SimplePrincipalCollection) {
            SimplePrincipalCollection other = (SimplePrincipalCollection)o;
            return this.realmPrincipals != null ? this.realmPrincipals.equals(other.realmPrincipals) : other.realmPrincipals == null;
        }
        return false;
    }

    public int hashCode() {
        if (this.realmPrincipals != null && !this.realmPrincipals.isEmpty()) {
            return this.realmPrincipals.hashCode();
        }
        return super.hashCode();
    }

    public String toString() {
        if (this.cachedToString == null) {
            Set principals = this.asSet();
            this.cachedToString = !CollectionUtils.isEmpty(principals) ? StringUtils.toString(principals.toArray()) : "empty";
        }
        return this.cachedToString;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        boolean principalsExist = !CollectionUtils.isEmpty(this.realmPrincipals);
        out.writeBoolean(principalsExist);
        if (principalsExist) {
            out.writeObject(this.realmPrincipals);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        boolean principalsExist = in.readBoolean();
        if (principalsExist) {
            this.realmPrincipals = (Map)in.readObject();
        }
    }
}

