/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queryparser.xml.builders;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.TermToBytesRefAttribute;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryparser.xml.DOMUtils;
import org.apache.lucene.queryparser.xml.ParserException;
import org.apache.lucene.queryparser.xml.builders.SpanBuilderBase;
import org.apache.lucene.search.spans.SpanBoostQuery;
import org.apache.lucene.search.spans.SpanOrQuery;
import org.apache.lucene.search.spans.SpanQuery;
import org.apache.lucene.search.spans.SpanTermQuery;
import org.apache.lucene.util.BytesRef;
import org.w3c.dom.Element;

public class SpanOrTermsBuilder
extends SpanBuilderBase {
    private final Analyzer analyzer;

    public SpanOrTermsBuilder(Analyzer analyzer) {
        this.analyzer = analyzer;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public SpanQuery getSpanQuery(Element e2) throws ParserException {
        String fieldName = DOMUtils.getAttributeWithInheritanceOrFail(e2, "fieldName");
        String value = DOMUtils.getNonBlankTextOrFail(e2);
        ArrayList<SpanTermQuery> clausesList = new ArrayList<SpanTermQuery>();
        try (TokenStream ts = this.analyzer.tokenStream(fieldName, value);){
            TermToBytesRefAttribute termAtt = ts.addAttribute(TermToBytesRefAttribute.class);
            ts.reset();
            while (ts.incrementToken()) {
                SpanTermQuery stq = new SpanTermQuery(new Term(fieldName, BytesRef.deepCopyOf(termAtt.getBytesRef())));
                clausesList.add(stq);
            }
            ts.end();
            SpanOrQuery soq = new SpanOrQuery(clausesList.toArray(new SpanQuery[clausesList.size()]));
            float boost = DOMUtils.getAttribute(e2, "boost", 1.0f);
            SpanBoostQuery spanBoostQuery = new SpanBoostQuery(soq, boost);
            return spanBoostQuery;
        }
        catch (IOException ioe) {
            throw new ParserException("IOException parsing value:" + value);
        }
    }
}

