/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.lang;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.query.QueryParseException;
import org.apache.jena.query.Syntax;
import org.apache.jena.sparql.core.Prologue;
import org.apache.jena.sparql.lang.UpdateParserRegistry;
import org.apache.jena.sparql.modify.UpdateSink;
import org.apache.jena.util.FileUtils;

public abstract class UpdateParser {
    protected UpdateParser() {
    }

    public final void parse(UpdateSink sink, Prologue prologue, String updateString) throws QueryParseException {
        StringReader r = new StringReader(updateString);
        this.executeParse(sink, prologue, r);
    }

    public final void parse(UpdateSink sink, Prologue prologue, InputStream input) throws QueryParseException {
        BufferedReader r = FileUtils.asBufferedUTF8(input);
        this.executeParse(sink, prologue, r);
    }

    public void parse(UpdateSink sink, Prologue prologue, Reader r) {
        if (r instanceof FileReader) {
            Log.warn(this, "FileReader passed to Update parser - use a FileInputStream");
        }
        this.executeParse(sink, prologue, r);
    }

    protected abstract void executeParse(UpdateSink var1, Prologue var2, Reader var3);

    public static boolean canParse(Syntax syntaxURI) {
        return UpdateParserRegistry.get().containsFactory(syntaxURI);
    }

    public static UpdateParser createParser(Syntax syntaxURI) {
        return UpdateParserRegistry.get().createParser(syntaxURI);
    }
}

