/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.validation.json;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.jena.atlas.json.JsonBuilder;
import org.apache.jena.atlas.json.JsonObject;
import org.apache.jena.fuseki.servlets.ServletOps;
import org.apache.jena.fuseki.validation.json.ValidationAction;
import org.apache.jena.fuseki.validation.json.ValidatorJsonLib;
import org.apache.jena.iri.IRI;
import org.apache.jena.iri.IRIFactory;
import org.apache.jena.iri.Violation;
import org.apache.jena.irix.SetupJenaIRI;

public class IRIValidatorJSON {
    static IRIFactory iriFactory = SetupJenaIRI.iriCheckerFactory();
    static final String paramIRI = "iri";
    static final String jIRIs = "iris";
    static final String jIRI = "iri";

    public static JsonObject execute(ValidationAction action) {
        JsonBuilder obj = new JsonBuilder();
        obj.startObject();
        String[] args = ValidatorJsonLib.getArgs(action, "iri");
        if (args.length == 0) {
            ServletOps.errorBadRequest("No IRIs supplied");
        }
        obj.key(jIRIs);
        obj.startArray();
        for (String iriStr : args) {
            obj.startObject();
            obj.key("iri").value(iriStr);
            IRI iri2 = iriFactory.create(iriStr);
            ArrayList<String> errors = new ArrayList<String>();
            ArrayList<Object> warnings = new ArrayList<Object>();
            if (iri2.isRelative()) {
                warnings.add("Relative IRI: " + iriStr);
            }
            Iterator<Violation> vIter = iri2.violations(true);
            while (vIter.hasNext()) {
                Violation v = vIter.next();
                String string = v.getShortMessage();
                if (v.isError()) {
                    errors.add(string);
                    continue;
                }
                warnings.add(string);
            }
            obj.key("errors");
            obj.startArray();
            for (String string : errors) {
                obj.value(string);
            }
            obj.finishArray();
            obj.key("warning");
            obj.startArray();
            for (String string : warnings) {
                obj.value(string);
            }
            obj.finishArray();
            obj.finishObject();
        }
        obj.finishArray();
        obj.finishObject();
        return obj.build().getAsObject();
    }
}

