/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.server;

import org.apache.jena.fuseki.FusekiException;
import org.apache.jena.fuseki.server.DataServiceStatus;
import org.apache.jena.irix.IRIException;
import org.apache.jena.irix.IRIx;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.Resource;

public class FusekiVocab {
    public static String NS = "http://jena.apache.org/fuseki#";
    private static Model model = ModelFactory.createDefaultModel();
    public static final Resource tServer = FusekiVocab.resource("Server");
    public static final Resource fusekiService = FusekiVocab.resource("Service");
    public static final Property pServices = FusekiVocab.property("services");
    public static final Property pServiceName = FusekiVocab.property("name");
    public static final Property pEndpointName = FusekiVocab.property("name");
    public static final Property pPasswordFile = FusekiVocab.property("passwd");
    public static final Property pRealm = FusekiVocab.property("realm");
    public static final Property pAuth = FusekiVocab.property("auth");
    public static final Property pEndpoint = FusekiVocab.property("endpoint");
    public static final Property pOperation = FusekiVocab.property("operation");
    public static final Property pAllowedUsers = FusekiVocab.property("allowedUsers");
    public static final Property pTimeout = FusekiVocab.property("timeout");
    public static final Property pImplementation = FusekiVocab.property("implementation");
    public static final Property pQueryLimit = FusekiVocab.property("queryLimit");
    public static final Property pUnionDefaultGraph = FusekiVocab.property("unionDefaultGraph");
    public static final Property pAllowTimeoutOverride = FusekiVocab.property("allowTimeoutOverride");
    public static final Property pMaximumTimeoutOverride = FusekiVocab.property("maximumTimeoutOverride");
    public static final Property pDataset = FusekiVocab.property("dataset");
    public static final Property pServerPing = FusekiVocab.property("pingEP");
    public static final Property pServerStats = FusekiVocab.property("statsEP");
    public static final Property pServerMetrics = FusekiVocab.property("metricsEP");
    public static final Property pServerCompact = FusekiVocab.property("compactEP");
    public static final Property pServiceQueryEP = FusekiVocab.property("serviceQuery");
    public static final Property pServiceUpdateEP = FusekiVocab.property("serviceUpdate");
    public static final Property pServiceUploadEP = FusekiVocab.property("serviceUpload");
    public static final Property pServiceShaclEP = FusekiVocab.property("serviceShacl");
    public static final Property pServiceReadWriteGraphStoreEP = FusekiVocab.property("serviceReadWriteGraphStore");
    public static final Property pServiceReadGraphStoreEP = FusekiVocab.property("serviceReadGraphStore");
    public static final Resource opQuery = FusekiVocab.resource("query");
    public static final Resource opUpdate = FusekiVocab.resource("update");
    public static final Resource opUpload = FusekiVocab.resource("upload");
    public static final Resource opGSP_r = FusekiVocab.resource("gsp-r");
    public static final Resource opGSP_r_alt = FusekiVocab.resource("gsp_r");
    public static final Resource opGSP_rw = FusekiVocab.resource("gsp-rw");
    public static final Resource opGSP_rw_alt = FusekiVocab.resource("gsp_rw");
    public static final Resource opNoOp = FusekiVocab.resource("no-op");
    public static final Resource opNoOp_alt = FusekiVocab.resource("no_op");
    public static final Resource opShacl = FusekiVocab.resource("shacl");
    private static final String stateNameActive = DataServiceStatus.ACTIVE.name;
    private static final String stateNameOffline = DataServiceStatus.OFFLINE.name;
    private static final String stateNameClosing = DataServiceStatus.CLOSING.name;
    private static final String stateNameClosed = DataServiceStatus.CLOSED.name;
    public static final Resource stateActive = FusekiVocab.resource(stateNameActive);
    public static final Resource stateOffline = FusekiVocab.resource(stateNameOffline);
    public static final Resource stateClosing = FusekiVocab.resource(stateNameClosing);
    public static final Resource stateClosed = FusekiVocab.resource(stateNameClosed);

    private static Resource resource(String localname2) {
        return model.createResource(FusekiVocab.iri(localname2));
    }

    private static Property property(String localname2) {
        return model.createProperty(FusekiVocab.iri(localname2));
    }

    private static String iri(String localname2) {
        String uri = NS + localname2;
        try {
            IRIx iri2 = IRIx.create(uri);
            if (!iri2.isReference()) {
                throw new FusekiException("Bad IRI (relative): " + uri);
            }
            return uri;
        }
        catch (IRIException ex) {
            throw new FusekiException("Bad IRI: " + uri);
        }
    }
}

