/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.dboe.sys;

import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import org.apache.jena.atlas.RuntimeIOException;
import org.apache.jena.atlas.logging.FmtLog;
import org.apache.jena.dboe.DBOpEnvException;
import org.apache.jena.dboe.base.file.Location;

public class IO_DB {
    public static Location asLocation(Path path) {
        Objects.requireNonNull(path, "IOX.asLocation(null)");
        if (!Files.isDirectory(path, new LinkOption[0])) {
            throw new RuntimeIOException("Path is not naming a directory: " + path);
        }
        return Location.create(path.toString());
    }

    public static Path asPath(Location location) {
        if (location.isMem()) {
            throw new RuntimeIOException("Location is a memory location: " + location);
        }
        return Paths.get(location.getDirectoryPath(), new String[0]);
    }

    public static File asFile(Location loc) {
        return new File(loc.getDirectoryPath());
    }

    public static List<Path> scanForDirByPattern(Path directory, String namebase, String nameSep) {
        Pattern pattern = Pattern.compile(Pattern.quote(namebase) + Pattern.quote(nameSep) + "[\\d]+");
        ArrayList<Path> paths = new ArrayList<Path>();
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(directory, namebase + "*");){
            for (Path entry : stream) {
                if (!pattern.matcher(entry.getFileName().toString()).matches()) {
                    throw new DBOpEnvException("Invalid filename for matching: " + entry.getFileName());
                }
                if (!Files.isDirectory(entry, new LinkOption[0])) {
                    throw new DBOpEnvException("Not a directory: " + entry);
                }
                paths.add(entry);
            }
        }
        catch (IOException ex) {
            FmtLog.warn(IO_DB.class, "Can't inspect directory: (%s, %s)", directory, namebase);
            throw new DBOpEnvException(ex);
        }
        Comparator comp = (f1, f2) -> {
            int num1 = IO_DB.extractIndex(f1.getFileName().toString(), namebase, nameSep);
            int num2 = IO_DB.extractIndex(f2.getFileName().toString(), namebase, nameSep);
            return Integer.compare(num1, num2);
        };
        paths.sort(comp);
        return paths;
    }

    public static int extractIndex(String name, String namebase, String nameSep) {
        int i = namebase.length() + nameSep.length();
        String numStr = name.substring(i);
        int num = Integer.parseInt(numStr);
        return num;
    }
}

