/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.util;

import java.lang.invoke.MethodHandles;
import java.util.stream.Stream;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.logging.log4j.util.LowLevelLogUtil;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;

public class OsgiServiceLocator {
    private static final boolean OSGI_AVAILABLE = OsgiServiceLocator.checkOsgiAvailable();

    private static boolean checkOsgiAvailable() {
        try {
            Class.forName("org.osgi.framework.Bundle");
            return true;
        }
        catch (ClassNotFoundException | LinkageError e2) {
            return false;
        }
        catch (Throwable e3) {
            LowLevelLogUtil.logException("Unknown error checking for existence of class: org.osgi.framework.Bundle", e3);
            return false;
        }
    }

    public static boolean isAvailable() {
        return OSGI_AVAILABLE;
    }

    public static <T> Stream<T> loadServices(Class<T> serviceType, MethodHandles.Lookup lookup) {
        return OsgiServiceLocator.loadServices(serviceType, lookup, true);
    }

    public static <T> Stream<T> loadServices(Class<T> serviceType, MethodHandles.Lookup lookup, boolean verbose) {
        block3: {
            Bundle bundle = FrameworkUtil.getBundle(lookup.lookupClass());
            if (bundle != null) {
                BundleContext ctx = bundle.getBundleContext();
                try {
                    return ctx.getServiceReferences(serviceType, null).stream().map(arg_0 -> ((BundleContext)ctx).getService(arg_0));
                }
                catch (Throwable e2) {
                    if (!verbose) break block3;
                    StatusLogger.getLogger().error("Unable to load OSGI services for service {}", (Object)serviceType, (Object)e2);
                }
            }
        }
        return Stream.empty();
    }
}

