/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb.store;

import java.util.Map;
import java.util.Objects;
import org.apache.jena.atlas.lib.Pair;
import org.apache.jena.riot.system.PrefixLib;
import org.apache.jena.riot.system.PrefixMapBase;
import org.apache.jena.tdb.store.DatasetPrefixStorage;

public class GraphPrefixesProjection
extends PrefixMapBase {
    private final String graphName;
    private final DatasetPrefixStorage prefixes;

    public GraphPrefixesProjection(String graphName, DatasetPrefixStorage prefixes) {
        Objects.requireNonNull(graphName);
        Objects.requireNonNull(prefixes);
        this.graphName = graphName;
        this.prefixes = prefixes;
    }

    @Override
    public String get(String prefix) {
        Objects.requireNonNull(prefix);
        prefix = PrefixLib.canonicalPrefix(prefix);
        return this.prefixes.readPrefix(this.graphName, prefix);
    }

    @Override
    public Map<String, String> getMapping() {
        return this.prefixes.readPrefixMap(this.graphName);
    }

    @Override
    public void add(String prefix, String iriString) {
        Objects.requireNonNull(prefix);
        Objects.requireNonNull(iriString);
        prefix = PrefixLib.canonicalPrefix(prefix);
        this.prefixes.insertPrefix(this.graphName, prefix, iriString);
    }

    @Override
    public void delete(String prefix) {
        Objects.requireNonNull(prefix);
        prefix = PrefixLib.canonicalPrefix(prefix);
        this.prefixes.removeFromPrefixMap(this.graphName, prefix);
    }

    @Override
    public void clear() {
        this.prefixes.removeAllFromPrefixMap(this.graphName);
    }

    @Override
    public boolean containsPrefix(String prefix) {
        return this.get(prefix) != null;
    }

    @Override
    public String abbreviate(String uriStr) {
        Objects.requireNonNull(uriStr);
        return PrefixLib.abbreviate(this, uriStr);
    }

    @Override
    public Pair<String, String> abbrev(String uriStr) {
        Objects.requireNonNull(uriStr);
        return PrefixLib.abbrev(this, uriStr);
    }

    @Override
    public String expand(String prefix, String localName) {
        Objects.requireNonNull(prefix);
        Objects.requireNonNull(localName);
        prefix = PrefixLib.canonicalPrefix(prefix);
        return PrefixLib.expand(this, prefix, localName);
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public int size() {
        return this.getMapping().size();
    }
}

