/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.exec.http;

import java.net.http.HttpClient;
import java.util.HashMap;
import org.apache.jena.http.HttpLib;
import org.apache.jena.http.sys.ExecHTTPBuilder;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecutionBuilder;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingLib;
import org.apache.jena.sparql.exec.http.Params;
import org.apache.jena.sparql.exec.http.QueryExecHTTP;
import org.apache.jena.sparql.exec.http.QueryExecutionHTTP;
import org.apache.jena.sparql.util.Context;

public class QueryExecutionHTTPBuilder
extends ExecHTTPBuilder<QueryExecutionHTTP, QueryExecutionHTTPBuilder>
implements QueryExecutionBuilder {
    public static QueryExecutionHTTPBuilder create() {
        return new QueryExecutionHTTPBuilder();
    }

    public static QueryExecutionHTTPBuilder service(String serviceURL) {
        return (QueryExecutionHTTPBuilder)QueryExecutionHTTPBuilder.create().endpoint(serviceURL);
    }

    private QueryExecutionHTTPBuilder() {
    }

    @Override
    protected QueryExecutionHTTPBuilder thisBuilder() {
        return this;
    }

    @Override
    protected QueryExecutionHTTP buildX(HttpClient hClient, Query queryActual, String queryStringActual, Context cxt) {
        QueryExecHTTP qExec = new QueryExecHTTP(this.serviceURL, queryActual, queryStringActual, this.urlLimit, hClient, new HashMap<String, String>(this.httpHeaders), Params.create(this.params), cxt, HttpLib.copyArray(this.defaultGraphURIs), HttpLib.copyArray(this.namedGraphURIs), this.sendMode, this.appAcceptHeader, this.timeout, this.timeoutUnit);
        return new QueryExecutionHTTP(qExec);
    }

    @Override
    public QueryExecutionBuilder substitution(QuerySolution querySolution) {
        Binding binding = BindingLib.toBinding(querySolution);
        super.substitution(binding);
        return this.thisBuilder();
    }

    @Override
    public QueryExecutionBuilder substitution(String varName, RDFNode value) {
        super.substitution(Var.alloc(varName), value.asNode());
        return this.thisBuilder();
    }
}

