/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.tokens;

import java.nio.charset.MalformedInputException;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.apache.jena.atlas.AtlasException;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.atlas.io.PeekReader;
import org.apache.jena.atlas.lib.Chars;
import org.apache.jena.riot.RiotParseException;
import org.apache.jena.riot.system.ErrorHandler;
import org.apache.jena.riot.system.RiotChars;
import org.apache.jena.riot.tokens.StringType;
import org.apache.jena.riot.tokens.Token;
import org.apache.jena.riot.tokens.TokenChecker;
import org.apache.jena.riot.tokens.TokenType;
import org.apache.jena.riot.tokens.TokenizeTextBuilder;
import org.apache.jena.riot.tokens.Tokenizer;
import org.apache.jena.sparql.ARQInternalErrorException;

public final class TokenizerText
implements Tokenizer {
    private static final int CTRL_CHAR = 42;
    private static final boolean Checking = false;
    private Token token = null;
    private final StringBuilder stringBuilder = new StringBuilder(200);
    private final PeekReader reader;
    private final boolean lineMode;
    private boolean finished = false;
    private final TokenChecker checker = null;
    private final ErrorHandler errorHandler;
    private static final boolean VeryVeryLaxIRI = false;
    private static final boolean AllowSpacesInIRI = false;
    private static char[] extraCharsWord = new char[]{'_', '.', '-'};
    private static char[] extraCharsVar = new char[]{'_', '.', '-', '?', '@', '+', '/', '~'};

    public static TokenizeTextBuilder create() {
        return new TokenizeTextBuilder();
    }

    public static Tokenizer fromString(String string) {
        return TokenizerText.create().fromString(string).build();
    }

    static TokenizerText internal(PeekReader reader, boolean lineMode, ErrorHandler errorHandler) {
        return new TokenizerText(reader, lineMode, errorHandler);
    }

    private TokenizerText(PeekReader reader, boolean lineMode, ErrorHandler errorHandler) {
        this.reader = Objects.requireNonNull(reader, "PeekReader");
        this.lineMode = lineMode;
        this.errorHandler = Objects.requireNonNull(errorHandler, "ErrorHandler");
    }

    @Override
    public final boolean hasNext() {
        if (this.finished) {
            return false;
        }
        if (this.token != null) {
            return true;
        }
        try {
            this.skip();
            if (this.reader.eof()) {
                this.finished = true;
                return false;
            }
            this.token = this.parseToken();
            if (this.token == null) {
                this.finished = true;
                return false;
            }
            return true;
        }
        catch (AtlasException ex) {
            if (ex.getCause() != null) {
                if (ex.getCause().getClass() == MalformedInputException.class) {
                    throw new RiotParseException("Bad character encoding", this.reader.getLineNum(), this.reader.getColNum());
                }
                throw new RiotParseException("Bad input stream [" + ex.getCause() + "]", this.reader.getLineNum(), this.reader.getColNum());
            }
            throw new RiotParseException("Bad input stream", this.reader.getLineNum(), this.reader.getColNum());
        }
    }

    @Override
    public final boolean eof() {
        return !this.hasNext();
    }

    @Override
    public final Token next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        Token t = this.token;
        this.token = null;
        return t;
    }

    @Override
    public final Token peek() {
        if (!this.hasNext()) {
            return null;
        }
        return this.token;
    }

    @Override
    public void close() {
        IO.close(this.reader);
    }

    private void skip() {
        int ch = -1;
        while (true) {
            if (this.reader.eof()) {
                return;
            }
            ch = this.reader.peekChar();
            if (ch == 35) {
                this.reader.readChar();
                while ((ch = this.reader.peekChar()) != -1 && !RiotChars.isNewlineChar(ch)) {
                    this.reader.readChar();
                }
            }
            if (this.lineMode ? !RiotChars.isHorizontalWhitespace(ch) : !RiotChars.isWhitespace(ch)) break;
            this.reader.readChar();
        }
    }

    private Token parseToken() {
        int ch2;
        int chPeek;
        this.token = new Token(this.getLine(), this.getColumn());
        int ch = this.reader.peekChar();
        if (ch == 60) {
            this.reader.readChar();
            chPeek = this.reader.peekChar();
            if (chPeek != 60) {
                this.token.setImage(this.readIRI());
                this.token.setType(TokenType.IRI);
                return this.token;
            }
            if (chPeek == 60) {
                this.reader.readChar();
                this.token.setType(TokenType.LT2);
                return this.token;
            }
            this.fatal("Internal error - parsed '%c' after '<'", chPeek);
        }
        if (ch == 39 || ch == 34) {
            this.token.setType(TokenType.STRING);
            this.reader.readChar();
            ch2 = this.reader.peekChar();
            if (ch2 == ch) {
                StringType st;
                this.reader.readChar();
                int ch3 = this.reader.peekChar();
                if (ch3 == ch) {
                    this.reader.readChar();
                    this.token.setImage(this.readLongString(ch, false));
                    st = ch == 39 ? StringType.LONG_STRING1 : StringType.LONG_STRING2;
                    this.token.setStringType(st);
                } else {
                    this.token.setImage("");
                    st = ch == 39 ? StringType.STRING1 : StringType.STRING2;
                    this.token.setStringType(st);
                }
            } else {
                this.token.setImage(this.readString(ch, ch));
                StringType st = ch == 39 ? StringType.STRING1 : StringType.STRING2;
                this.token.setStringType(st);
            }
            this.skip();
            if (this.reader.peekChar() == 64) {
                this.reader.readChar();
                Token mainToken = new Token(this.token);
                mainToken.setType(TokenType.LITERAL_LANG);
                mainToken.setSubToken1(this.token);
                mainToken.setImage2(this.langTag());
                this.token = mainToken;
            } else if (this.reader.peekChar() == 94) {
                this.expect("^^");
                this.skip();
                Token mainToken = new Token(this.token);
                mainToken.setSubToken1(this.token);
                mainToken.setImage(this.token.getImage());
                Token subToken = this.parseToken();
                if (!subToken.isIRI()) {
                    this.fatal("Datatype URI required after ^^ - URI or prefixed name expected", new Object[0]);
                }
                mainToken.setSubToken2(subToken);
                mainToken.setType(TokenType.LITERAL_DT);
                this.token = mainToken;
            }
            return this.token;
        }
        if (ch == 95) {
            this.reader.readChar();
            ch2 = this.reader.peekChar();
            if (ch2 == 58) {
                this.reader.readChar();
                this.token.setImage(this.readBlankNodeLabel());
                this.token.setType(TokenType.BNODE);
                return this.token;
            }
            this.token.setType(TokenType.UNDERSCORE);
            return this.token;
        }
        if (ch == 64) {
            this.reader.readChar();
            this.token.setType(TokenType.DIRECTIVE);
            this.token.setImage(this.readWord(false));
            return this.token;
        }
        if (ch == 63) {
            this.reader.readChar();
            this.token.setType(TokenType.VAR);
            this.token.setImage(this.readVarName());
            return this.token;
        }
        switch (ch) {
            case 46: {
                this.reader.readChar();
                ch = this.reader.peekChar();
                if (RiotChars.range(ch, 48, 57)) {
                    this.reader.pushbackChar(46);
                    this.readNumber();
                    return this.token;
                }
                this.token.setType(TokenType.DOT);
                return this.token;
            }
            case 62: {
                this.reader.readChar();
                chPeek = this.reader.peekChar();
                if (chPeek == 62) {
                    this.reader.readChar();
                    this.token.setType(TokenType.GT2);
                    return this.token;
                }
                this.token.setType(TokenType.GT);
                return this.token;
            }
            case 59: {
                this.reader.readChar();
                this.token.setType(TokenType.SEMICOLON);
                return this.token;
            }
            case 44: {
                this.reader.readChar();
                this.token.setType(TokenType.COMMA);
                return this.token;
            }
            case 123: {
                this.reader.readChar();
                chPeek = this.reader.peekChar();
                if (chPeek == 124) {
                    this.reader.readChar();
                    this.token.setType(TokenType.L_ANN);
                    return this.token;
                }
                this.token.setType(TokenType.LBRACE);
                return this.token;
            }
            case 125: {
                this.reader.readChar();
                this.token.setType(TokenType.RBRACE);
                return this.token;
            }
            case 40: {
                this.reader.readChar();
                this.token.setType(TokenType.LPAREN);
                return this.token;
            }
            case 41: {
                this.reader.readChar();
                this.token.setType(TokenType.RPAREN);
                return this.token;
            }
            case 91: {
                this.reader.readChar();
                this.token.setType(TokenType.LBRACKET);
                return this.token;
            }
            case 93: {
                this.reader.readChar();
                this.token.setType(TokenType.RBRACKET);
                return this.token;
            }
            case 61: {
                this.reader.readChar();
                this.token.setType(TokenType.EQUALS);
                return this.token;
            }
            case 47: {
                this.reader.readChar();
                this.token.setType(TokenType.SLASH);
                return this.token;
            }
            case 92: {
                this.reader.readChar();
                this.token.setType(TokenType.RSLASH);
                return this.token;
            }
            case 124: {
                this.reader.readChar();
                chPeek = this.reader.peekChar();
                if (chPeek == 125) {
                    this.reader.readChar();
                    this.token.setType(TokenType.R_ANN);
                    return this.token;
                }
                this.token.setType(TokenType.VBAR);
                return this.token;
            }
            case 38: {
                this.reader.readChar();
                this.token.setType(TokenType.AMPERSAND);
                return this.token;
            }
            case 60: {
                this.reader.readChar();
                this.token.setType(TokenType.LT);
                return this.token;
            }
            case 42: {
                this.reader.readChar();
                this.token.setType(TokenType.STAR);
                return this.token;
            }
            case 33: {
                this.reader.readChar();
                this.token.setType(TokenType.EMARK);
                return this.token;
            }
        }
        int signCh = 0;
        if (ch == 43 || ch == 45) {
            this.reader.readChar();
            int ch22 = this.reader.peekChar();
            if (!RiotChars.range(ch22, 48, 57)) {
                if (ch == 43) {
                    this.token.setType(TokenType.PLUS);
                } else {
                    this.token.setType(TokenType.MINUS);
                }
                return this.token;
            }
            this.reader.pushbackChar(ch);
            signCh = ch;
        }
        if (ch == 43 || ch == 45 || RiotChars.range(ch, 48, 57)) {
            this.readNumber();
            return this.token;
        }
        if (RiotChars.isNewlineChar(ch)) {
            do {
                int n = this.reader.readChar();
            } while (RiotChars.isNewlineChar(this.reader.peekChar()));
            this.token.setType(TokenType.NL);
            return this.token;
        }
        this.readPrefixedNameOrKeyword(this.token);
        return this.token;
    }

    private String readIRI() {
        this.stringBuilder.setLength(0);
        while (true) {
            int ch = this.reader.readChar();
            switch (ch) {
                case -1: {
                    this.fatal("Broken IRI (End of file)", new Object[0]);
                    return null;
                }
                case 10: {
                    this.fatal("Broken IRI (newline): %s", this.stringBuilder.toString());
                    return null;
                }
                case 13: {
                    this.fatal("Broken IRI (CR): %s", this.stringBuilder.toString());
                    return null;
                }
                case 62: {
                    return this.stringBuilder.toString();
                }
                case 92: {
                    ch = this.readUnicodeEscape();
                    break;
                }
                case 60: {
                    this.fatal("Bad character in IRI (bad character: '<'): <%s[<]...>", this.stringBuilder.toString());
                    return null;
                }
                case 9: {
                    this.error("Bad character in IRI (Tab character): <%s[tab]...>", this.stringBuilder.toString());
                    return null;
                }
                case 34: 
                case 94: 
                case 96: 
                case 123: 
                case 124: 
                case 125: {
                    this.warning("Illegal character in IRI (codepoint 0x%02X, '%c'): <%s[%c]...>", ch, Character.valueOf((char)ch), this.stringBuilder.toString(), Character.valueOf((char)ch));
                    break;
                }
                case 32: {
                    this.error("Bad character in IRI (space): <%s[space]...>", this.stringBuilder.toString());
                    break;
                }
                default: {
                    if (ch > 25) break;
                    this.warning("Illegal character in IRI (control char 0x%02X): <%s[0x%02X]...>", ch, this.stringBuilder.toString(), ch);
                }
            }
            if (ch >= 160 && !TokenizerText.isUcsChar(ch)) {
                this.warning("Illegal character in IRI (Not a ucschar: 0x%04X): <%s[U+%04X]...>", ch, this.stringBuilder.toString(), ch);
            }
            this.insertCodepoint(this.stringBuilder, ch);
        }
    }

    private static boolean isUcsChar(int ch) {
        boolean b;
        boolean bl = b = RiotChars.range(ch, 160, 55295) || RiotChars.range(ch, 63744, 64975) || RiotChars.range(ch, 65008, 65519);
        if (b) {
            return true;
        }
        if (ch < 4096) {
            return false;
        }
        return RiotChars.range(ch, 65536, 131069) || RiotChars.range(ch, 131072, 196605) || RiotChars.range(ch, 196608, 262141) || RiotChars.range(ch, 262144, 327677) || RiotChars.range(ch, 327680, 393213) || RiotChars.range(ch, 393216, 458749) || RiotChars.range(ch, 458752, 524285) || RiotChars.range(ch, 524288, 589821) || RiotChars.range(ch, 589824, 655357) || RiotChars.range(ch, 655360, 720893) || RiotChars.range(ch, 720896, 786429) || RiotChars.range(ch, 786432, 851965) || RiotChars.range(ch, 851968, 917501) || RiotChars.range(ch, 921600, 983037);
    }

    private final int readUnicodeEscape() {
        int ch = this.reader.readChar();
        if (ch == -1) {
            this.fatal("Broken escape sequence", new Object[0]);
        }
        switch (ch) {
            case 117: {
                return this.readUnicode4Escape();
            }
            case 85: {
                return this.readUnicode8Escape();
            }
        }
        this.fatal("Illegal unicode escape sequence value: \\%c (0x%02X)", ch, ch);
        return 0;
    }

    private void readPrefixedNameOrKeyword(Token token) {
        long posn = this.reader.getPosition();
        String prefixPart = this.readPrefixPart();
        token.setImage(prefixPart);
        token.setType(TokenType.KEYWORD);
        int ch = this.reader.peekChar();
        if (ch == 58) {
            this.reader.readChar();
            token.setType(TokenType.PREFIXED_NAME);
            String ln2 = this.readLocalPart();
            token.setImage2(ln2);
        }
        if (posn == this.reader.getPosition()) {
            this.fatal("Failed to find a prefix name or keyword: %c(%d;0x%04X)", ch, ch, ch);
        }
    }

    private String readPrefixPart() {
        return this.readSegment(false);
    }

    private String readLocalPart() {
        return this.readSegment(true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String readSegment(boolean isLocalPart) {
        this.stringBuilder.setLength(0);
        int ch = this.reader.peekChar();
        if (ch == -1) {
            return "";
        }
        if (isLocalPart) {
            if (ch == 58) {
                this.reader.readChar();
                this.insertCodepoint(this.stringBuilder, ch);
            } else if (ch == 37 || ch == 92) {
                this.reader.readChar();
                this.processPLX(ch);
            } else {
                if (!RiotChars.isPNChars_U_N(ch)) return "";
                if (ch == 65533) {
                    this.warning("Unicode replacement character U+FFFD", new Object[0]);
                }
                this.insertCodepoint(this.stringBuilder, ch);
                this.reader.readChar();
            }
        } else {
            if (!RiotChars.isPNCharsBase(ch)) {
                return "";
            }
            this.insertCodepoint(this.stringBuilder, ch);
            this.reader.readChar();
        }
        int chDot = 0;
        while (true) {
            ch = this.reader.peekChar();
            boolean valid = false;
            if (isLocalPart && (ch == 37 || ch == 92)) {
                this.reader.readChar();
                if (chDot != 0) {
                    TokenizerText.insertCodepointDirect(this.stringBuilder, chDot);
                }
                this.processPLX(ch);
                chDot = 0;
                continue;
            }
            valid = isLocalPart && ch == 58 ? true : (RiotChars.isPNChars(ch) ? true : ch == 46);
            if (!valid) break;
            if (chDot != 0) {
                TokenizerText.insertCodepointDirect(this.stringBuilder, chDot);
                chDot = 0;
            }
            if (ch != 46) {
                if (ch == 65533) {
                    this.warning("Unicode replacement character U+FFFD", new Object[0]);
                }
                this.insertCodepoint(this.stringBuilder, ch);
            } else {
                chDot = ch;
            }
            this.reader.readChar();
        }
        if (chDot != 46) return this.stringBuilder.toString();
        this.reader.pushbackChar(chDot);
        return this.stringBuilder.toString();
    }

    private void processPLX(int ch) {
        if (ch == 37) {
            TokenizerText.insertCodepointDirect(this.stringBuilder, ch);
            ch = this.reader.peekChar();
            if (!RiotChars.isHexChar(ch)) {
                this.fatal("Not a hex character: '%c'", ch);
            }
            TokenizerText.insertCodepointDirect(this.stringBuilder, ch);
            this.reader.readChar();
            ch = this.reader.peekChar();
            if (!RiotChars.isHexChar(ch)) {
                this.fatal("Not a hex character: '%c'", ch);
            }
            TokenizerText.insertCodepointDirect(this.stringBuilder, ch);
            this.reader.readChar();
        } else if (ch == 92) {
            ch = this.readCharEscape();
            this.insertCodepoint(this.stringBuilder, ch);
        } else {
            throw new ARQInternalErrorException("Not a '\\' or a '%' character");
        }
    }

    private String readString(int startCh, int endCh) {
        this.stringBuilder.setLength(0);
        while (true) {
            int ch;
            if ((ch = this.reader.readChar()) == 65533) {
                this.warning("Unicode replacement character U+FFFD in string", new Object[0]);
            } else if (ch == -1) {
                this.fatal("Broken token: %s", this.stringBuilder.toString());
            } else if (ch == 10) {
                this.fatal("Broken token (newline): %s", this.stringBuilder.toString());
            } else {
                if (ch == endCh) {
                    return this.stringBuilder.toString();
                }
                if (ch == 92) {
                    ch = this.readLiteralEscape();
                }
            }
            this.insertCodepoint(this.stringBuilder, ch);
        }
    }

    private String readLongString(int quoteChar, boolean endNL) {
        this.stringBuilder.setLength(0);
        while (true) {
            int ch;
            if ((ch = this.reader.readChar()) == 65533) {
                this.warning("Input has Unicode replacement character U+FFFD in string", new Object[0]);
            } else if (ch == -1) {
                if (endNL) {
                    return this.stringBuilder.toString();
                }
                this.fatal("Broken long string", new Object[0]);
            } else if (ch == quoteChar) {
                if (this.threeQuotes(quoteChar)) {
                    return this.stringBuilder.toString();
                }
            } else if (ch == 92) {
                ch = this.readLiteralEscape();
            }
            this.insertCodepoint(this.stringBuilder, ch);
        }
    }

    private String readWord(boolean leadingDigitAllowed) {
        return this.readWordSub(leadingDigitAllowed, false);
    }

    private String readWordSub(boolean leadingDigitAllowed, boolean leadingSignAllowed) {
        return this.readCharsWithExtras(leadingDigitAllowed, leadingSignAllowed, extraCharsWord, false);
    }

    private String readVarName() {
        return this.readCharsWithExtras(true, true, extraCharsVar, true);
    }

    private String readCharsWithExtras(boolean leadingDigitAllowed, boolean leadingSignAllowed, char[] extraChars, boolean allowFinalDot) {
        int ch;
        this.stringBuilder.setLength(0);
        int idx = 0;
        if (!leadingDigitAllowed && Character.isDigit(ch = this.reader.peekChar())) {
            return "";
        }
        if (!(leadingSignAllowed || (ch = this.reader.peekChar()) != 45 && ch != 43)) {
            return "";
        }
        while (RiotChars.isAlphaNumeric(ch = this.reader.peekChar()) || Chars.charInArray(ch, extraChars)) {
            this.reader.readChar();
            TokenizerText.insertCodepointDirect(this.stringBuilder, ch);
            ++idx;
        }
        if (!allowFinalDot) {
            while (idx > 0 && this.stringBuilder.charAt(idx - 1) == '.') {
                this.reader.pushbackChar(46);
                this.stringBuilder.setLength(idx - 1);
                --idx;
            }
        }
        return this.stringBuilder.toString();
    }

    private String readBlankNodeLabel() {
        int ch;
        this.stringBuilder.setLength(0);
        int ch2 = this.reader.peekChar();
        if (ch2 == -1) {
            this.fatal("Blank node label missing (EOF found)", new Object[0]);
        }
        if (RiotChars.isWhitespace(ch2)) {
            this.fatal("Blank node label missing", new Object[0]);
        }
        if (!RiotChars.isPNChars_U_N(ch2)) {
            this.fatal("Blank node label does not start with alphabetic or _ : '%c'", Character.valueOf((char)ch2));
        }
        this.reader.readChar();
        if (ch2 == 65533) {
            this.warning("Unicode replacement character U+FFFD in blank node label", new Object[0]);
        }
        this.insertCodepoint(this.stringBuilder, ch2);
        int chDot = 0;
        while ((ch = this.reader.peekChar()) != -1 && (RiotChars.isPNChars(ch) || ch == 46)) {
            this.reader.readChar();
            if (chDot != 0) {
                TokenizerText.insertCodepointDirect(this.stringBuilder, chDot);
                chDot = 0;
            }
            if (ch != 46) {
                if (ch == 65533) {
                    this.warning("Unicode replacement character U+FFFD in blank node label", new Object[0]);
                }
                this.insertCodepoint(this.stringBuilder, ch);
                continue;
            }
            chDot = ch;
        }
        if (chDot == 46) {
            this.reader.pushbackChar(chDot);
        }
        return this.stringBuilder.toString();
    }

    private void readNumber() {
        int len;
        boolean isDouble = false;
        boolean isDecimal = false;
        this.stringBuilder.setLength(0);
        int x = 0;
        int ch = this.reader.peekChar();
        if (ch == 48) {
            ++x;
            this.reader.readChar();
            TokenizerText.insertCodepointDirect(this.stringBuilder, ch);
            ch = this.reader.peekChar();
            if (ch == 120 || ch == 88) {
                this.reader.readChar();
                TokenizerText.insertCodepointDirect(this.stringBuilder, ch);
                this.readHex(this.reader, this.stringBuilder);
                this.token.setImage(this.stringBuilder.toString());
                this.token.setType(TokenType.HEX);
                return;
            }
        } else if (ch == 45 || ch == 43) {
            this.readPossibleSign(this.stringBuilder);
        }
        x += this.readDigits(this.stringBuilder);
        ch = this.reader.peekChar();
        if (ch == 46) {
            this.reader.readChar();
            this.stringBuilder.append('.');
            isDecimal = true;
            this.readDigits(this.stringBuilder);
        }
        if (x == 0 && !isDecimal) {
            this.fatal("Unrecognized as number", new Object[0]);
        }
        if (this.exponent(this.stringBuilder)) {
            isDouble = true;
            isDecimal = false;
        }
        if (isDecimal && this.stringBuilder.charAt((len = this.stringBuilder.length()) - 1) == '.') {
            this.stringBuilder.setLength(len - 1);
            this.reader.pushbackChar(46);
            isDecimal = false;
        }
        this.token.setImage(this.stringBuilder.toString());
        if (isDouble) {
            this.token.setType(TokenType.DOUBLE);
        } else if (isDecimal) {
            this.token.setType(TokenType.DECIMAL);
        } else {
            this.token.setType(TokenType.INTEGER);
        }
    }

    private void readHex(PeekReader reader, StringBuilder sb) {
        int ch;
        int x = 0;
        while (RiotChars.isHexChar(ch = reader.peekChar())) {
            reader.readChar();
            TokenizerText.insertCodepointDirect(sb, ch);
            ++x;
        }
        if (x == 0) {
            this.fatal("No hex characters after %s", sb.toString());
        }
    }

    private int readDigits(StringBuilder buffer) {
        int ch;
        int count = 0;
        while (RiotChars.range(ch = this.reader.peekChar(), 48, 57)) {
            this.reader.readChar();
            TokenizerText.insertCodepointDirect(buffer, ch);
            ++count;
        }
        return count;
    }

    private void readPossibleSign(StringBuilder sb) {
        int ch = this.reader.peekChar();
        if (ch == 45 || ch == 43) {
            this.reader.readChar();
            TokenizerText.insertCodepointDirect(sb, ch);
        }
    }

    private boolean threeQuotes(int ch) {
        int ch2 = this.reader.peekChar();
        if (ch2 != ch) {
            return false;
        }
        this.reader.readChar();
        int ch3 = this.reader.peekChar();
        if (ch3 != ch) {
            this.reader.pushbackChar(ch2);
            return false;
        }
        this.reader.readChar();
        return true;
    }

    private boolean exponent(StringBuilder sb) {
        int ch = this.reader.peekChar();
        if (ch != 101 && ch != 69) {
            return false;
        }
        this.reader.readChar();
        TokenizerText.insertCodepointDirect(sb, ch);
        this.readPossibleSign(sb);
        int x = this.readDigits(sb);
        if (x == 0) {
            this.fatal("Malformed double: %s", sb);
        }
        return true;
    }

    private String langTag() {
        int ch;
        this.stringBuilder.setLength(0);
        this.a2z(this.stringBuilder);
        if (this.stringBuilder.length() == 0) {
            this.fatal("Bad language tag", new Object[0]);
        }
        while ((ch = this.reader.peekChar()) == 45) {
            this.reader.readChar();
            TokenizerText.insertCodepointDirect(this.stringBuilder, ch);
            int x = this.stringBuilder.length();
            this.a2zN(this.stringBuilder);
            if (this.stringBuilder.length() != x) continue;
            this.fatal("Bad language tag", new Object[0]);
        }
        return this.stringBuilder.toString().intern();
    }

    private void a2z(StringBuilder sBuff) {
        int ch;
        while (RiotChars.isA2Z(ch = this.reader.peekChar())) {
            this.reader.readChar();
            TokenizerText.insertCodepointDirect(sBuff, ch);
        }
    }

    private void a2zN(StringBuilder sBuff) {
        int ch;
        while (RiotChars.isA2ZN(ch = this.reader.peekChar())) {
            this.reader.readChar();
            TokenizerText.insertCodepointDirect(sBuff, ch);
        }
    }

    private void insertCodepoint(StringBuilder buffer, int ch) {
        if (Character.charCount(ch) == 1) {
            TokenizerText.insertCodepointDirect(buffer, ch);
        } else {
            if (!Character.isDefined(ch) && !Character.isSupplementaryCodePoint(ch)) {
                this.fatal("Illegal codepoint: 0x%04X", ch);
            }
            char[] chars = Character.toChars(ch);
            buffer.append(chars);
        }
    }

    private static void insertCodepointDirect(StringBuilder buffer, int ch) {
        buffer.append((char)ch);
    }

    @Override
    public long getColumn() {
        return this.reader.getColNum();
    }

    @Override
    public long getLine() {
        return this.reader.getLineNum();
    }

    private void checkBlankNode(String blankNodeLabel) {
        if (this.checker != null) {
            this.checker.checkBlankNode(blankNodeLabel);
        }
    }

    private void checkLiteralLang(String lexicalForm, String langTag) {
        if (this.checker != null) {
            this.checker.checkLiteralLang(lexicalForm, langTag);
        }
    }

    private void checkLiteralDT(String lexicalForm, Token datatype) {
        if (this.checker != null) {
            this.checker.checkLiteralDT(lexicalForm, datatype);
        }
    }

    private void checkString(String string) {
        if (this.checker != null) {
            this.checker.checkString(string);
        }
    }

    private void checkURI(String uriStr) {
        if (this.checker != null) {
            this.checker.checkURI(uriStr);
        }
    }

    private void checkNumber(String image, String datatype) {
        if (this.checker != null) {
            this.checker.checkNumber(image, datatype);
        }
    }

    private void checkVariable(String tokenImage) {
        if (this.checker != null) {
            this.checker.checkVariable(tokenImage);
        }
    }

    private void checkDirective(int cntrlCode) {
        if (this.checker != null) {
            this.checker.checkDirective(cntrlCode);
        }
    }

    private void checkKeyword(String tokenImage) {
        if (this.checker != null) {
            this.checker.checkKeyword(tokenImage);
        }
    }

    private void checkPrefixedName(String tokenImage, String tokenImage2) {
        if (this.checker != null) {
            this.checker.checkPrefixedName(tokenImage, tokenImage2);
        }
    }

    private void checkControl(int code) {
        if (this.checker != null) {
            this.checker.checkControl(code);
        }
    }

    private final int readLiteralEscape() {
        int c = this.reader.readChar();
        if (c == -1) {
            this.fatal("Escape sequence not completed", new Object[0]);
        }
        switch (c) {
            case 110: {
                return 10;
            }
            case 114: {
                return 13;
            }
            case 116: {
                return 9;
            }
            case 102: {
                return 12;
            }
            case 98: {
                return 8;
            }
            case 34: {
                return 34;
            }
            case 39: {
                return 39;
            }
            case 92: {
                return 92;
            }
            case 117: {
                return this.readUnicode4Escape();
            }
            case 85: {
                return this.readUnicode8Escape();
            }
        }
        this.fatal("Illegal escape sequence value: %c (0x%02X)", c, c);
        return 0;
    }

    private final int readCharEscape() {
        int c = this.reader.readChar();
        if (c == -1) {
            this.fatal("Escape sequence not completed", new Object[0]);
        }
        switch (c) {
            case 33: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 59: 
            case 61: 
            case 63: 
            case 64: 
            case 95: 
            case 126: {
                return c;
            }
        }
        this.fatal("illegal character escape value: \\%c", c);
        return 0;
    }

    private final int readUnicode4Escape() {
        return this.readHexSequence(4);
    }

    private final int readUnicode8Escape() {
        int ch8 = this.readHexSequence(8);
        if (ch8 > 0x10FFFF) {
            this.fatal("Illegal code point in \\U sequence value: 0x%08X", ch8);
        }
        return ch8;
    }

    private final int readHexSequence(int N) {
        int x = 0;
        for (int i = 0; i < N; ++i) {
            int d = this.readHexChar();
            if (d < 0) {
                return -1;
            }
            x = (x << 4) + d;
        }
        return x;
    }

    private final int readHexChar() {
        int x;
        int ch = this.reader.readChar();
        if (ch == -1) {
            this.fatal("Not a hexadecimal character (end of file)", new Object[0]);
        }
        if ((x = RiotChars.valHexChar(ch)) != -1) {
            return x;
        }
        this.fatal("Not a hexadecimal character: '%c'", Character.valueOf((char)ch));
        return -1;
    }

    private boolean expect(String str2) {
        for (int i = 0; i < str2.length(); ++i) {
            char want = str2.charAt(i);
            if (this.reader.eof()) {
                this.fatal("End of input during expected string: %s", str2);
                return false;
            }
            int inChar = this.reader.peekChar();
            if (inChar != want) {
                this.fatal("expected \"%s\"", str2);
                return false;
            }
            this.reader.readChar();
        }
        return true;
    }

    private void warning(String message, Object ... args) {
        String msg = String.format(message, args);
        this.errorHandler.warning(msg, this.reader.getLineNum(), this.reader.getColNum());
    }

    private void error(String message, Object ... args) {
        String msg = String.format(message, args);
        this.errorHandler.error(msg, this.reader.getLineNum(), this.reader.getColNum());
    }

    private void fatal(String message, Object ... args) {
        String msg = String.format(message, args);
        long line = this.reader.getLineNum();
        long col = this.reader.getColNum();
        this.errorHandler.fatal(msg, line, col);
        throw new RiotParseException(message, line, col);
    }
}

