/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.jetty;

import java.util.Objects;
import org.apache.jena.atlas.lib.FileOps;
import org.apache.jena.atlas.web.AuthScheme;
import org.apache.jena.fuseki.FusekiConfigException;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.security.ConstraintMapping;
import org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.eclipse.jetty.security.DefaultIdentityService;
import org.eclipse.jetty.security.HashLoginService;
import org.eclipse.jetty.security.PropertyUserStore;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.security.UserStore;
import org.eclipse.jetty.security.authentication.BasicAuthenticator;
import org.eclipse.jetty.security.authentication.DigestAuthenticator;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.util.security.Constraint;
import org.eclipse.jetty.util.security.Password;

public class JettyLib {
    public static final AuthScheme dftAuthMode;
    public static AuthScheme authMode;

    public static SecurityHandler makeSecurityHandlerForPathspec(String pathSpec, String realm, UserStore userStore) {
        ConstraintSecurityHandler sh = JettyLib.makeSecurityHandler(realm, userStore);
        JettyLib.addPathConstraint(sh, pathSpec);
        return sh;
    }

    public static ConstraintSecurityHandler makeSecurityHandler(String realm, UserStore userStore) {
        return JettyLib.makeSecurityHandler(realm, userStore, "**", authMode);
    }

    public static ConstraintSecurityHandler makeSecurityHandler(String realm, UserStore userStore, AuthScheme authMode) {
        return JettyLib.makeSecurityHandler(realm, userStore, "**", authMode);
    }

    public static ConstraintSecurityHandler makeSecurityHandler(String realm, UserStore userStore, String role, AuthScheme authMode) {
        Objects.requireNonNull(userStore);
        Objects.requireNonNull(role);
        if (authMode == null) {
            authMode = dftAuthMode;
        }
        ConstraintSecurityHandler securityHandler = new ConstraintSecurityHandler();
        DefaultIdentityService identService = new DefaultIdentityService();
        securityHandler.setIdentityService(identService);
        HashLoginService loginService = new HashLoginService(realm);
        loginService.setUserStore(userStore);
        loginService.setIdentityService(identService);
        securityHandler.setLoginService(loginService);
        securityHandler.setAuthenticator(authMode == AuthScheme.BASIC ? new BasicAuthenticator() : new DigestAuthenticator());
        if (realm != null) {
            securityHandler.setRealmName(realm);
        }
        return securityHandler;
    }

    public static void addPathConstraint(ConstraintSecurityHandler securityHandler, String pathSpec) {
        JettyLib.addPathConstraint(securityHandler, pathSpec, "**");
    }

    public static void addPathConstraint(ConstraintSecurityHandler securityHandler, String pathSpec, String role) {
        Objects.requireNonNull(securityHandler);
        Objects.requireNonNull(pathSpec);
        ConstraintMapping mapping = new ConstraintMapping();
        Constraint constraint = new Constraint();
        String[] roles = new String[]{role};
        constraint.setRoles(roles);
        constraint.setName(securityHandler.getAuthenticator().getAuthMethod());
        constraint.setAuthenticate(true);
        mapping.setConstraint(constraint);
        mapping.setPathSpec(pathSpec);
        securityHandler.addConstraintMapping(mapping);
    }

    public static UserStore makeUserStore(String passwordFile) {
        if (!FileOps.exists(passwordFile)) {
            throw new FusekiConfigException("No such file: " + passwordFile);
        }
        PropertyUserStore propertyUserStore = new PropertyUserStore();
        propertyUserStore.setConfig(passwordFile);
        propertyUserStore.setHotReload(true);
        try {
            propertyUserStore.start();
        }
        catch (Exception ex) {
            throw new RuntimeException("UserStore", ex);
        }
        return propertyUserStore;
    }

    public static UserStore makeUserStore(String user, String password) {
        return JettyLib.makeUserStore(user, password, "**");
    }

    public static UserStore makeUserStore(String user, String password, String role) {
        Objects.requireNonNull(user);
        Objects.requireNonNull(password);
        Objects.requireNonNull(role);
        UserStore userStore = new UserStore();
        JettyLib.addUser(userStore, user, password, role);
        try {
            userStore.start();
        }
        catch (Exception ex) {
            throw new RuntimeException("UserStore", ex);
        }
        return userStore;
    }

    public static UserStore addUser(UserStore userStore, String user, String password) {
        return JettyLib.addUser(userStore, user, password, "**");
    }

    public static UserStore addUser(UserStore userStore, String user, String password, String role) {
        String[] stringArray;
        if (role == null) {
            stringArray = null;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = role;
        }
        String[] roles = stringArray;
        Password cred = new Password(password);
        userStore.addUser(user, cred, roles);
        return userStore;
    }

    public static void addHandler(Server server, Handler handler) {
        Handler currentHandler = server.getHandler();
        if (currentHandler == null) {
            server.setHandler(handler);
        } else if (currentHandler instanceof HandlerList) {
            ((HandlerList)currentHandler).addHandler(handler);
        } else {
            HandlerList handlerList = new HandlerList();
            handlerList.addHandler(currentHandler);
            handlerList.addHandler(handler);
            server.setHandler(handlerList);
        }
    }

    public static void setMimeTypes(ServletContextHandler context2) {
        MimeTypes mimeTypes = new MimeTypes();
        mimeTypes.addMimeMapping("nt", "application/n-triples");
        mimeTypes.addMimeMapping("nq", "application/n-quads");
        mimeTypes.addMimeMapping("ttl", "text/turtle;charset=utf-8");
        mimeTypes.addMimeMapping("trig", "application/trig;charset=utf-8");
        mimeTypes.addMimeMapping("rdf", "application/rdf+xml");
        mimeTypes.addMimeMapping("jsonld", "application/ld+json");
        mimeTypes.addMimeMapping("rj", "application/rdf+json");
        mimeTypes.addMimeMapping("rt", "application/rdf+thrift");
        mimeTypes.addMimeMapping("trdf", "application/rdf+thrift");
        mimeTypes.addMimeMapping("rq", "application/sparql-query");
        mimeTypes.addMimeMapping("ru", "application/sparql-update");
        mimeTypes.addMimeMapping("rsj", "application/sparql-results+json");
        mimeTypes.addMimeMapping("rsx", "application/sparql-results+xml");
        mimeTypes.addMimeMapping("srt", "application/sparql-results+thrift");
        mimeTypes.addMimeMapping("srt", "application/sparql-results+protobuf");
        mimeTypes.addMimeMapping("txt", "text/plain");
        mimeTypes.addMimeMapping("csv", "text/csv");
        mimeTypes.addMimeMapping("tsv", "text/tab-separated-values");
        context2.setMimeTypes(mimeTypes);
    }

    public static HttpConfiguration httpConfiguration() {
        HttpConfiguration http_config = new HttpConfiguration();
        http_config.setRequestHeaderSize(524288);
        http_config.setOutputBufferSize(0x100000);
        http_config.setSendServerVersion(false);
        return http_config;
    }

    static {
        authMode = dftAuthMode = AuthScheme.BASIC;
    }
}

