/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.jsonld.processor;

import com.apicatalog.jsonld.JsonLdError;
import com.apicatalog.jsonld.JsonLdErrorCode;
import com.apicatalog.jsonld.JsonLdOptions;
import com.apicatalog.jsonld.JsonLdVersion;
import com.apicatalog.jsonld.compaction.Compaction;
import com.apicatalog.jsonld.context.ActiveContext;
import com.apicatalog.jsonld.document.Document;
import com.apicatalog.jsonld.flattening.NodeMap;
import com.apicatalog.jsonld.flattening.NodeMapBuilder;
import com.apicatalog.jsonld.framing.Frame;
import com.apicatalog.jsonld.framing.Framing;
import com.apicatalog.jsonld.framing.FramingState;
import com.apicatalog.jsonld.json.JsonMapBuilder;
import com.apicatalog.jsonld.json.JsonUtils;
import com.apicatalog.jsonld.lang.BlankNode;
import com.apicatalog.jsonld.loader.DocumentLoaderOptions;
import com.apicatalog.jsonld.processor.ExpansionProcessor;
import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonString;
import jakarta.json.JsonStructure;
import jakarta.json.JsonValue;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class FramingProcessor {
    private FramingProcessor() {
    }

    public static final JsonObject frame(URI input, Document frame, JsonLdOptions options) throws JsonLdError {
        if (options.getDocumentLoader() == null) {
            throw new JsonLdError(JsonLdErrorCode.LOADING_DOCUMENT_FAILED, "Document loader is null. Cannot fetch [" + input + "].");
        }
        DocumentLoaderOptions loaderOptions = new DocumentLoaderOptions();
        loaderOptions.setExtractAllScripts(options.isExtractAllScripts());
        Document remoteDocument = options.getDocumentLoader().loadDocument(input, loaderOptions);
        if (remoteDocument == null) {
            throw new JsonLdError(JsonLdErrorCode.LOADING_DOCUMENT_FAILED, "Returned document is null [" + input + "].");
        }
        return FramingProcessor.frame(remoteDocument, frame, options);
    }

    public static final JsonObject frame(Document input, URI frameUri, JsonLdOptions options) throws JsonLdError {
        if (options.getDocumentLoader() == null) {
            throw new JsonLdError(JsonLdErrorCode.LOADING_DOCUMENT_FAILED, "Document loader is null. Cannot fetch [" + frameUri + "].");
        }
        Document frameDocument = options.getDocumentLoader().loadDocument(frameUri, new DocumentLoaderOptions());
        if (frameDocument == null) {
            throw new JsonLdError(JsonLdErrorCode.INVALID_REMOTE_CONTEXT, "Returned frame is null [" + frameUri + "] is null.");
        }
        return FramingProcessor.frame(input, frameDocument, options);
    }

    public static final JsonObject frame(Document input, Document frame, JsonLdOptions options) throws JsonLdError {
        List<String> remove;
        if (frame == null) {
            throw new JsonLdError(JsonLdErrorCode.LOADING_DOCUMENT_FAILED, "Frame or Frame.Document is null.");
        }
        JsonStructure frameStructure = frame.getJsonContent().orElseThrow(() -> new JsonLdError(JsonLdErrorCode.LOADING_DOCUMENT_FAILED, "Frame is not JSON object but null."));
        if (JsonUtils.isNotObject(frameStructure)) {
            throw new JsonLdError(JsonLdErrorCode.LOADING_DOCUMENT_FAILED, "Frame is not JSON object but [" + frameStructure + "].");
        }
        JsonObject frameObject = frameStructure.asJsonObject();
        JsonLdOptions expansionOptions = new JsonLdOptions(options);
        expansionOptions.setOrdered(false);
        JsonArray expandedInput = ExpansionProcessor.expand(input, expansionOptions, false);
        JsonArray expandedFrame = ExpansionProcessor.expand(frame, expansionOptions, true);
        JsonValue context2 = JsonValue.EMPTY_JSON_OBJECT;
        if (frameObject.containsKey("@context")) {
            context2 = (JsonValue)frameObject.get("@context");
        }
        URI contextBase = frame.getContextUrl() != null ? frame.getDocumentUrl() : options.getBase();
        ActiveContext activeContext = new ActiveContext(input.getDocumentUrl(), input.getDocumentUrl(), options).newContext().create(context2, contextBase);
        ArrayList<String> frameKeysExpanded = new ArrayList<String>();
        for (String key : frameObject.keySet()) {
            frameKeysExpanded.add(activeContext.uriExpansion().vocab(true).expand(key));
        }
        boolean frameDefault = frameKeysExpanded.contains("@graph");
        FramingState state = new FramingState();
        state.setEmbed(options.getEmbed());
        state.setEmbedded(false);
        state.setExplicitInclusion(options.isExplicit());
        state.setRequireAll(options.isRequiredAll());
        state.setOmitDefault(options.isOmitDefault());
        state.setGraphMap(NodeMapBuilder.with(expandedInput, new NodeMap()).build());
        if (frameDefault) {
            state.setGraphName("@default");
        } else {
            state.setGraphName("@merged");
            state.getGraphMap().merge();
        }
        JsonMapBuilder resultMap = JsonMapBuilder.create();
        Framing.with(state, new ArrayList<String>(state.getGraphMap().subjects(state.getGraphName())), Frame.of(expandedFrame), resultMap, null).ordered(options.isOrdered()).frame();
        Stream<Object> result = resultMap.valuesToArray().stream();
        if (!activeContext.inMode(JsonLdVersion.V1_0) && !(remove = FramingProcessor.findBlankNodes(resultMap.valuesToArray())).isEmpty()) {
            result = result.map(v -> FramingProcessor.removeBlankIdKey(v, remove));
        }
        JsonArrayBuilder filtered = Json.createArrayBuilder();
        result.map(FramingProcessor::removePreserve).forEach(filtered::add);
        JsonValue compactedResults = Compaction.with(activeContext).compactArrays(options.isCompactArrays()).ordered(options.isOrdered()).compact(filtered.build());
        if (JsonUtils.isEmptyArray(compactedResults)) {
            compactedResults = JsonValue.EMPTY_JSON_OBJECT;
        } else if (JsonUtils.isArray(compactedResults)) {
            String key = activeContext.uriCompaction().vocab(true).compact("@graph");
            compactedResults = Json.createObjectBuilder().add(key, compactedResults).build();
        }
        compactedResults = FramingProcessor.replaceNull(compactedResults);
        boolean omitGraph = options.isOmitGraph() == null ? activeContext.inMode(JsonLdVersion.V1_1) : options.isOmitGraph().booleanValue();
        if (!omitGraph && !compactedResults.asJsonObject().containsKey("@graph")) {
            compactedResults = compactedResults.asJsonObject().isEmpty() ? Json.createObjectBuilder().add("@graph", JsonValue.EMPTY_JSON_ARRAY).build() : Json.createObjectBuilder().add("@graph", Json.createArrayBuilder().add(compactedResults)).build();
        }
        if (!JsonUtils.isEmptyArray(context2) && !JsonUtils.isEmptyObject(context2)) {
            compactedResults = Json.createObjectBuilder(compactedResults.asJsonObject()).add("@context", context2).build();
        }
        return compactedResults.asJsonObject();
    }

    public static final JsonObject frame(URI input, URI frame, JsonLdOptions options) throws JsonLdError {
        return FramingProcessor.frame(FramingProcessor.getDocument(input, options), FramingProcessor.getDocument(frame, options), options);
    }

    private static Document getDocument(URI document, JsonLdOptions options) throws JsonLdError {
        if (options.getDocumentLoader() == null) {
            throw new JsonLdError(JsonLdErrorCode.LOADING_DOCUMENT_FAILED, "Document loader is null. Cannot fetch [" + document + "].");
        }
        DocumentLoaderOptions loaderOptions = new DocumentLoaderOptions();
        loaderOptions.setExtractAllScripts(options.isExtractAllScripts());
        Document remoteDocument = options.getDocumentLoader().loadDocument(document, loaderOptions);
        if (remoteDocument == null) {
            throw new JsonLdError(JsonLdErrorCode.LOADING_DOCUMENT_FAILED, "Cannot load document [" + document + "].");
        }
        return remoteDocument;
    }

    private static final JsonValue removePreserve(JsonValue value) {
        if (JsonUtils.isScalar(value)) {
            return value;
        }
        if (JsonUtils.isArray(value)) {
            JsonArrayBuilder array = Json.createArrayBuilder();
            value.asJsonArray().forEach(item -> array.add(FramingProcessor.removePreserve(item)));
            return array.build();
        }
        JsonObjectBuilder object = Json.createObjectBuilder();
        for (Map.Entry entry : value.asJsonObject().entrySet()) {
            if ("@preserve".equals(entry.getKey())) {
                return (JsonValue)((JsonValue)entry.getValue()).asJsonArray().get(0);
            }
            object.add((String)entry.getKey(), FramingProcessor.removePreserve((JsonValue)entry.getValue()));
        }
        return object.build();
    }

    private static final JsonValue replaceNull(JsonValue value) {
        if (JsonUtils.isString(value) && "@null".equals(((JsonString)value).getString())) {
            return JsonValue.NULL;
        }
        if (JsonUtils.isScalar(value)) {
            return value;
        }
        if (JsonUtils.isArray(value)) {
            JsonArrayBuilder array = Json.createArrayBuilder();
            value.asJsonArray().forEach(item -> array.add(FramingProcessor.replaceNull(item)));
            JsonArray result = array.build();
            return result.size() != 1 || JsonUtils.isNotNull((JsonValue)result.get(0)) ? result : JsonValue.EMPTY_JSON_ARRAY;
        }
        JsonObjectBuilder object = Json.createObjectBuilder();
        value.asJsonObject().entrySet().forEach(entry -> object.add((String)entry.getKey(), FramingProcessor.replaceNull((JsonValue)entry.getValue())));
        return object.build();
    }

    private static final JsonValue removeBlankIdKey(JsonValue value, List<String> blankNodes) {
        if (JsonUtils.isScalar(value)) {
            return value;
        }
        if (JsonUtils.isArray(value)) {
            JsonArrayBuilder array = Json.createArrayBuilder();
            value.asJsonArray().forEach(item -> array.add(FramingProcessor.removeBlankIdKey(item, blankNodes)));
            return array.build();
        }
        JsonObjectBuilder object = Json.createObjectBuilder();
        for (Map.Entry entry : value.asJsonObject().entrySet()) {
            if ("@id".equals(entry.getKey()) && JsonUtils.isString((JsonValue)entry.getValue()) && blankNodes.contains(((JsonString)entry.getValue()).getString())) continue;
            object.add((String)entry.getKey(), FramingProcessor.removeBlankIdKey((JsonValue)entry.getValue(), blankNodes));
        }
        return object.build();
    }

    private static final List<String> findBlankNodes(JsonArray array) {
        HashMap candidates = new HashMap();
        array.forEach(v -> FramingProcessor.findBlankNodes(v, candidates));
        return candidates.entrySet().stream().filter(e2 -> (Integer)e2.getValue() == 1).map(Map.Entry::getKey).collect(Collectors.toList());
    }

    private static final void findBlankNodes(JsonValue value, Map<String, Integer> blankNodes) {
        if (JsonUtils.isString(value)) {
            if (BlankNode.isWellFormed(((JsonString)value).getString())) {
                Integer count = blankNodes.computeIfAbsent(((JsonString)value).getString(), x -> 0);
                count = count + 1;
                blankNodes.put(((JsonString)value).getString(), count);
            }
            return;
        }
        if (JsonUtils.isScalar(value)) {
            return;
        }
        if (JsonUtils.isArray(value)) {
            for (JsonValue item : value.asJsonArray()) {
                FramingProcessor.findBlankNodes(item, blankNodes);
            }
            return;
        }
        for (Map.Entry entry : value.asJsonObject().entrySet()) {
            FramingProcessor.findBlankNodes((JsonValue)entry.getValue(), blankNodes);
        }
    }
}

