/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.web.filter.authc;

import java.io.IOException;
import java.util.Arrays;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.authz.UnauthenticatedException;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.web.filter.authc.AuthenticationFilter;

public abstract class AuthenticatingFilter
extends AuthenticationFilter {
    public static final String PERMISSIVE = "permissive";

    protected boolean executeLogin(ServletRequest request, ServletResponse response) throws Exception {
        AuthenticationToken token = this.createToken(request, response);
        if (token == null) {
            String msg = "createToken method implementation returned null. A valid non-null AuthenticationToken must be created in order to execute a login attempt.";
            throw new IllegalStateException(msg);
        }
        try {
            Subject subject = this.getSubject(request, response);
            subject.login(token);
            return this.onLoginSuccess(token, subject, request, response);
        }
        catch (AuthenticationException e2) {
            return this.onLoginFailure(token, e2, request, response);
        }
    }

    protected abstract AuthenticationToken createToken(ServletRequest var1, ServletResponse var2) throws Exception;

    protected AuthenticationToken createToken(String username, String password, ServletRequest request, ServletResponse response) {
        boolean rememberMe = this.isRememberMe(request);
        String host = this.getHost(request);
        return this.createToken(username, password, rememberMe, host);
    }

    protected AuthenticationToken createToken(String username, String password, boolean rememberMe, String host) {
        return new UsernamePasswordToken(username, password, rememberMe, host);
    }

    protected boolean onLoginSuccess(AuthenticationToken token, Subject subject, ServletRequest request, ServletResponse response) throws Exception {
        return true;
    }

    protected boolean onLoginFailure(AuthenticationToken token, AuthenticationException e2, ServletRequest request, ServletResponse response) {
        return false;
    }

    protected String getHost(ServletRequest request) {
        return request.getRemoteHost();
    }

    protected boolean isRememberMe(ServletRequest request) {
        return false;
    }

    @Override
    protected boolean isAccessAllowed(ServletRequest request, ServletResponse response, Object mappedValue) {
        return super.isAccessAllowed(request, response, mappedValue) || !this.isLoginRequest(request, response) && this.isPermissive(mappedValue);
    }

    protected boolean isPermissive(Object mappedValue) {
        if (mappedValue != null) {
            Object[] values = (String[])mappedValue;
            return Arrays.binarySearch(values, PERMISSIVE) >= 0;
        }
        return false;
    }

    @Override
    protected void cleanup(ServletRequest request, ServletResponse response, Exception existing) throws ServletException, IOException {
        if (existing instanceof UnauthenticatedException || existing instanceof ServletException && existing.getCause() instanceof UnauthenticatedException) {
            try {
                this.onAccessDenied(request, response);
                existing = null;
            }
            catch (Exception e2) {
                existing = e2;
            }
        }
        super.cleanup(request, response, existing);
    }
}

