/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.graph;

import java.util.Map;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.function.BiConsumer;
import java.util.stream.Stream;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.util.SplitIRI;
import org.apache.jena.util.XMLChar;

public abstract class PrefixMappingBase
implements PrefixMapping {
    protected PrefixMappingBase() {
    }

    protected abstract void add(String var1, String var2);

    protected abstract void remove(String var1);

    protected abstract void clear();

    protected abstract boolean isEmpty();

    protected abstract int size();

    protected abstract String prefixToUri(String var1);

    protected abstract String uriToPrefix(String var1);

    protected abstract Map<String, String> asMap();

    protected abstract Map<String, String> asMapCopy();

    protected abstract void apply(BiConsumer<String, String> var1);

    protected Optional<Map.Entry<String, String>> findMapping(String uri, boolean partial) {
        return ((Stream)this.asMap().entrySet().stream().sequential()).filter(e2 -> {
            String ss = (String)e2.getValue();
            return uri.startsWith(ss) && (partial || ss.length() == uri.length());
        }).findFirst();
    }

    @Override
    public PrefixMapping setNsPrefix(String prefix, String uri) {
        PrefixMappingBase.checkLegalPrefix(prefix);
        this.add(prefix, uri);
        return this;
    }

    @Override
    public PrefixMapping removeNsPrefix(String prefix) {
        this.remove(prefix);
        return this;
    }

    @Override
    public PrefixMapping clearNsPrefixMap() {
        this.clear();
        return this;
    }

    public static void checkLegalPrefix(String prefix) {
        if (prefix == null) {
            throw new PrefixMapping.IllegalPrefixException("null for prefix");
        }
        if (prefix.length() > 0 && !XMLChar.isValidNCName(prefix)) {
            throw new PrefixMapping.IllegalPrefixException(prefix);
        }
    }

    @Override
    public PrefixMapping setNsPrefixes(PrefixMapping pmap) {
        if (pmap instanceof PrefixMappingBase) {
            PrefixMappingBase pmap2 = (PrefixMappingBase)pmap;
            pmap2.apply((p, u) -> this.setNsPrefix((String)p, (String)u));
            return this;
        }
        this.setNsPrefixes(pmap.getNsPrefixMap());
        return this;
    }

    @Override
    public PrefixMapping setNsPrefixes(Map<String, String> map) {
        map.forEach(this::setNsPrefix);
        return this;
    }

    @Override
    public PrefixMapping withDefaultMappings(PrefixMapping pmap) {
        if (pmap instanceof PrefixMappingBase) {
            PrefixMappingBase pmap2 = (PrefixMappingBase)pmap;
            pmap2.apply(this::addWith);
            return this;
        }
        Map<String, String> map = pmap.getNsPrefixMap();
        map.forEach(this::addWith);
        return this;
    }

    private void addWith(String p, String u) {
        if (this.prefixToUri(p) == null && this.uriToPrefix(u) == null) {
            this.add(p, u);
        }
    }

    @Override
    public String getNsPrefixURI(String prefix) {
        return this.prefixToUri(prefix);
    }

    @Override
    public String getNsURIPrefix(String uri) {
        return this.uriToPrefix(uri);
    }

    @Override
    public Map<String, String> getNsPrefixMap() {
        return this.asMapCopy();
    }

    @Override
    public String expandPrefix(String prefixed) {
        int colon = prefixed.indexOf(58);
        if (colon < 0) {
            return prefixed;
        }
        String prefix = prefixed.substring(0, colon);
        String uri = this.getNsPrefixURI(prefix);
        return uri == null ? prefixed : uri + prefixed.substring(colon + 1);
    }

    @Override
    public String qnameFor(String uri) {
        int split = SplitIRI.splitXML(uri);
        String ns = uri.substring(0, split);
        String local = uri.substring(split);
        if (local.equals("")) {
            return null;
        }
        String prefix = this.getNsURIPrefix(ns);
        return prefix == null ? null : prefix + ":" + local;
    }

    @Override
    public String shortForm(String uri) {
        Optional<Map.Entry<String, String>> e2 = this.findMapping(uri, true);
        if (!e2.isPresent()) {
            return uri;
        }
        return e2.get().getKey() + ":" + uri.substring(e2.get().getValue().length());
    }

    @Override
    public boolean samePrefixMappingAs(PrefixMapping other) {
        if (this.numPrefixes() != other.numPrefixes()) {
            return false;
        }
        return this.getNsPrefixMap().equals(other.getNsPrefixMap());
    }

    @Override
    public PrefixMapping lock() {
        return this;
    }

    @Override
    public boolean hasNoMappings() {
        return this.isEmpty();
    }

    @Override
    public int numPrefixes() {
        return this.size();
    }

    public String toString() {
        StringJoiner sj = new StringJoiner(", ");
        this.apply((p, u) -> sj.add(p + "->" + u));
        return "pm:[" + this.numPrefixes() + "]{" + sj.toString() + "}";
    }
}

