/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.shacl.lib;

import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.StringJoiner;
import org.apache.jena.atlas.io.IndentedLineBuffer;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.atlas.lib.StrUtils;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.QueryParseException;
import org.apache.jena.query.ResultSet;
import org.apache.jena.query.Syntax;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.impl.Util;
import org.apache.jena.riot.other.G;
import org.apache.jena.riot.other.RDFDataException;
import org.apache.jena.riot.out.NodeFormatter;
import org.apache.jena.riot.out.NodeFormatterTTL;
import org.apache.jena.riot.system.PrefixMap;
import org.apache.jena.riot.system.PrefixMapFactory;
import org.apache.jena.shacl.Shapes;
import org.apache.jena.shacl.ValidationReport;
import org.apache.jena.shacl.engine.ShaclPaths;
import org.apache.jena.shacl.engine.Target;
import org.apache.jena.shacl.engine.TargetType;
import org.apache.jena.shacl.parser.ShaclParseException;
import org.apache.jena.shacl.vocabulary.SHACL;
import org.apache.jena.sparql.core.DatasetGraphFactory;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.path.Path;
import org.apache.jena.vocabulary.OWL;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.RDFS;
import org.apache.jena.vocabulary.XSD;

public class ShLib {
    private static String PREFIXES = StrUtils.strjoinNL("PREFIX owl:  <http://www.w3.org/2002/07/owl#>", "PREFIX rdf:  <http://www.w3.org/1999/02/22-rdf-syntax-ns#>", "PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#>", "PREFIX sh:   <http://www.w3.org/ns/shacl#>", "PREFIX xsd:  <http://www.w3.org/2001/XMLSchema#>", "");
    private static PrefixMap displayPrefixMap = PrefixMapFactory.createForOutput();
    public static NodeFormatter nodeFmtAbbrev;
    static Set<String> rdfDatatypes;
    private static String prefixesQueryString;
    private static Query prefixesQuery;
    private static Var varPrefix;
    private static Var varNamespace;

    public static void printShapes(Graph shapeGraph) {
        ShLib.printShapes(Shapes.parse(shapeGraph));
    }

    public static void printShapes(Shapes shapes) {
        ShLib.printShapes(IndentedWriter.stdout, shapes);
        IndentedWriter.stdout.flush();
    }

    public static void printShapes(IndentedWriter out, Shapes shapes) {
        NodeFormatter nodeFmt = ShLib.nodeFormatter(shapes);
        ShLib.printImports(out, nodeFmt, shapes);
        ShLib.printShapes(out, nodeFmt, shapes);
        out.flush();
    }

    private static void printImports(IndentedWriter out, NodeFormatter nodeFmt, Shapes shapes) {
        if (shapes.getImports() != null) {
            shapes.getImports().forEach(impt -> {
                out.print("Import: ");
                nodeFmt.format(out, (Node)impt);
                out.println();
            });
        }
    }

    public static void printShapes(IndentedWriter out, NodeFormatter nodeFmt, Shapes shapes) {
        int indent = out.getAbsoluteIndent();
        shapes.iteratorAll().forEachRemaining(shape -> shape.print(out, nodeFmt));
        out.setAbsoluteIndent(indent);
    }

    public static void print(Collection<Node> nodes) {
        nodes.stream().forEach(n -> {
            if (n.isURI()) {
                System.out.println(n.getLocalName());
            } else {
                System.out.println(ShLib.displayStr(n));
            }
        });
    }

    public static void printReport(ValidationReport report) {
        ShLib.printReport(System.out, report);
    }

    public static void printReport(OutputStream output, ValidationReport report) {
        PrintStream out;
        PrintStream printStream = out = output instanceof PrintStream ? (PrintStream)output : new PrintStream(output);
        if (report.conforms()) {
            out.println("Conforms");
            out.flush();
            return;
        }
        try {
            report.getEntries().forEach(e2 -> {
                out.printf("Node=%s\n", ShLib.displayStr(e2.focusNode()));
                if (e2.resultPath() != null) {
                    out.printf("  Path=%s\n", e2.resultPath());
                }
                if (e2.value() != null) {
                    out.printf("  Value: %s\n", ShLib.displayStr(e2.value()));
                }
                if (e2.message() != null) {
                    out.printf("  Message: %s\n", e2.message());
                }
            });
        }
        finally {
            out.flush();
        }
    }

    public static void printReport(Resource report) {
        String qs = StrUtils.strjoinNL(PREFIXES, "SELECT * {", "    [] sh:result ?R .", "    ?R", "       sh:focusNode ?focusNode ;", "       sh:resultMessage ?message ;", "       sh:resultSeverity  ?severity ; ", "       .", "    OPTIONAL { ?R sh:sourceConstraintComponent ?component }", "    OPTIONAL { ?R sh:sourceShape ?sourceShape }", "    OPTIONAL { ?R sh:resultPath    ?path}", "}");
        try (QueryExecution qExec = QueryExecutionFactory.create(qs, report.getModel());){
            ResultSet rs = qExec.execSelect();
            if (!rs.hasNext()) {
                System.out.println("No violations");
            } else {
                rs.forEachRemaining(row -> {
                    RDFNode focusNode = row.get("focusNode");
                    String msg = row.getLiteral("message").getLexicalForm();
                    RDFNode pathNode = row.get("path");
                    if (pathNode != null) {
                        System.out.printf("Node=%s   Path=%s\n", ShLib.displayStr(focusNode), pathNode);
                    } else {
                        System.out.printf("Node=%s\n", ShLib.displayStr(focusNode));
                    }
                    System.out.printf("  %s\n", msg);
                    Path path = null;
                    if (pathNode != null) {
                        path = ShaclPaths.parsePath(report.getModel().getGraph(), pathNode.asNode());
                    }
                });
            }
        }
    }

    static String displayStr(RDFNode n) {
        return ShLib.displayStr(n.asNode(), nodeFmtAbbrev);
    }

    public static String displayStr(Node n) {
        return ShLib.displayStr(n, nodeFmtAbbrev);
    }

    public static String displayStr(RDFDatatype dt) {
        Node n = NodeFactory.createURI(dt.getURI());
        return ShLib.displayStr(n, nodeFmtAbbrev);
    }

    public static String displayStr(Node n, NodeFormatter nodeFmt) {
        IndentedLineBuffer sw = new IndentedLineBuffer();
        nodeFmt.format(sw, n);
        return sw.toString();
    }

    public static boolean isImmediate(Target target) {
        TargetType targetType = target.getTargetType();
        return targetType.equals((Object)TargetType.targetObjectsOf) || targetType.equals((Object)TargetType.targetSubjectsOf);
    }

    public static boolean isDatatype(String iriStr) {
        return iriStr.startsWith(XSD.getURI()) || rdfDatatypes.contains(iriStr);
    }

    public static NodeFormatter nodeFormatter(Shapes shapes) {
        return new NodeFormatterTTL(shapes.getBaseURI(), shapes.getPrefixMap());
    }

    public static Query parseQueryString(String queryString) {
        try {
            Query query2 = new Query();
            QueryFactory.parse(query2, queryString, null, Syntax.defaultQuerySyntax);
            return query2;
        }
        catch (QueryParseException ex) {
            throw new ShaclParseException("Bad query: " + ex.getMessage());
        }
    }

    public static Query extractSPARQLQuery(Graph shapesGraph, Node sparqlNode) {
        String qs = ShLib.extractSPARQLQueryString(shapesGraph, sparqlNode);
        try {
            Query query2 = ShLib.parseQueryString(qs);
            return query2;
        }
        catch (QueryParseException ex) {
            throw new ShaclParseException("SPARQL parse error: " + ex.getMessage() + "\n" + qs);
        }
    }

    public static String extractSPARQLQueryString(Graph shapesGraph, Node sparqlNode) {
        Node selectNode;
        String prefixes = ShLib.prefixes(shapesGraph, sparqlNode);
        try {
            selectNode = G.getOneSP(shapesGraph, sparqlNode, SHACL.select);
        }
        catch (RDFDataException ex) {
            throw new ShaclParseException("required - one sh:select at : " + sparqlNode);
        }
        if (!Util.isSimpleString(selectNode)) {
            throw new ShaclParseException("Not a string for sh:select at : " + ShLib.displayStr(selectNode));
        }
        String selectQuery = selectNode.getLiteralLexicalForm();
        String qs = prefixes + "\n" + selectQuery;
        return qs;
    }

    public static String prefixes(Graph shapesGraph, Node sparqlNode) {
        StringJoiner prefixesSJ = new StringJoiner("\n");
        QueryExecution qExec = QueryExecutionFactory.create(prefixesQuery, DatasetGraphFactory.wrap(shapesGraph));
        ResultSet rs = qExec.execSelect();
        HashMap<String, String> seen = new HashMap<String, String>();
        while (rs.hasNext()) {
            String ns;
            Binding binding = rs.nextBinding();
            Node nPrefix = binding.get(varPrefix);
            Node nNamespace = binding.get(varNamespace);
            String prefix = nPrefix.getLiteralLexicalForm();
            if (nNamespace.isLiteral()) {
                ns = nNamespace.getLiteralLexicalForm();
            } else if (nNamespace.isURI()) {
                ns = nNamespace.getURI();
            } else {
                throw new ShaclParseException("sh:namespace is not  a literal or URI");
            }
            if (seen.containsKey(prefix) && ((String)seen.get(prefix)).equals(ns)) continue;
            prefixesSJ.add("PREFIX " + prefix + ": <" + ns + ">");
            seen.put(prefix, ns);
        }
        return prefixesSJ.toString();
    }

    static {
        displayPrefixMap.add("owl", OWL.getURI());
        displayPrefixMap.add("rdf", RDF.getURI());
        displayPrefixMap.add("rdfs", RDFS.getURI());
        displayPrefixMap.add("sh", SHACL.getURI());
        displayPrefixMap.add("xsd", XSD.getURI());
        nodeFmtAbbrev = new NodeFormatterTTL(null, displayPrefixMap);
        rdfDatatypes = new HashSet<String>();
        rdfDatatypes.add(RDF.dtLangString.getURI());
        rdfDatatypes.add(RDF.dtRDFHTML.getURI());
        rdfDatatypes.add(RDF.dtRDFJSON.getURI());
        rdfDatatypes.add(RDF.dtXMLLiteral.getURI());
        prefixesQueryString = StrUtils.strjoinNL("PREFIX owl:     <http://www.w3.org/2002/07/owl#>", "PREFIX sh:      <http://www.w3.org/ns/shacl#>", "SELECT * { ?x sh:prefixes/owl:imports*/sh:declare [ sh:prefix ?prefix ; sh:namespace ?namespace ] }");
        prefixesQuery = QueryFactory.create(prefixesQueryString);
        varPrefix = Var.alloc("prefix");
        varNamespace = Var.alloc("namespace");
    }
}

