/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.query.text;

import java.util.Iterator;
import java.util.List;
import org.apache.jena.dboe.transaction.txn.ComponentId;
import org.apache.jena.dboe.transaction.txn.TransactionCoordinator;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.query.ReadWrite;
import org.apache.jena.query.TxnType;
import org.apache.jena.query.text.TextDocProducer;
import org.apache.jena.query.text.TextHit;
import org.apache.jena.query.text.TextIndex;
import org.apache.jena.query.text.TextIndexDB;
import org.apache.jena.query.text.TextIndexException;
import org.apache.jena.query.text.TextIndexTDB1;
import org.apache.jena.query.text.changes.DatasetGraphTextMonitor;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.GraphView;
import org.apache.jena.sparql.core.Transactional;
import org.apache.jena.tdb.transaction.TransactionManager;
import org.apache.jena.tdb2.sys.TDBInternal;
import org.apache.lucene.queryparser.classic.QueryParserBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatasetGraphText
extends DatasetGraphTextMonitor
implements Transactional {
    private static Logger log = LoggerFactory.getLogger(DatasetGraphText.class);
    private final TextIndex textIndex;
    private final Graph dftGraph;
    private final boolean closeIndexOnClose;
    private final Object txnExitLock = new Object();
    private final ThreadLocal<ReadWrite> readWriteMode = new ThreadLocal();
    private Runnable delegateCommit = () -> super.commit();
    private Runnable delegateAbort = () -> super.abort();
    private Runnable nonDelegatedCommit = () -> {
        if (this.readWriteMode.get() == ReadWrite.WRITE) {
            this.commit_W();
        } else {
            this.commit_R();
        }
    };
    private Runnable nonDelegatedAbort = () -> {
        if (this.readWriteMode.get() == ReadWrite.WRITE) {
            this.abort_W();
        } else {
            this.abort_R();
        }
    };
    private Runnable commitAction = null;
    private Runnable abortAction = null;

    public DatasetGraphText(DatasetGraph dsg, TextIndex index, TextDocProducer producer) {
        this(dsg, index, producer, false);
    }

    public DatasetGraphText(DatasetGraph dsg, TextIndex index, TextDocProducer producer, boolean closeIndexOnClose) {
        super(dsg, producer);
        this.textIndex = index;
        this.dftGraph = GraphView.createDefaultGraph(this);
        this.closeIndexOnClose = closeIndexOnClose;
        if (org.apache.jena.tdb.sys.TDBInternal.isTDB1(dsg)) {
            TransactionManager txnMgr = org.apache.jena.tdb.sys.TDBInternal.getTransactionManager(dsg);
            txnMgr.addAdditionComponent(new TextIndexTDB1(this.textIndex));
            this.commitAction = this.delegateCommit;
            this.abortAction = this.delegateAbort;
        } else if (TDBInternal.isTDB2(dsg)) {
            TransactionCoordinator coord = TDBInternal.getTransactionCoordinator(dsg);
            byte[] componentID = new byte[]{2, 4, 6, 10};
            TextIndexDB tc = new TextIndexDB(ComponentId.create(null, componentID), this.textIndex);
            coord.modifyConfig(() -> coord.addExternal(tc));
            this.commitAction = this.delegateCommit;
            this.abortAction = this.delegateAbort;
        } else {
            this.commitAction = this.nonDelegatedCommit;
            this.abortAction = this.nonDelegatedAbort;
        }
    }

    @Override
    public Graph getDefaultGraph() {
        return this.dftGraph;
    }

    @Override
    public Graph getGraph(Node graphNode) {
        return GraphView.createNamedGraph(this, graphNode);
    }

    public TextIndex getTextIndex() {
        return this.textIndex;
    }

    public Iterator<TextHit> search(String queryString) {
        return this.search(queryString, null);
    }

    public Iterator<TextHit> search(String queryString, Node predicate) {
        return this.search(queryString, predicate, -1);
    }

    public Iterator<TextHit> search(String queryString, int limit) {
        return this.search(queryString, null, limit);
    }

    public Iterator<TextHit> search(String queryString, Node predicate, int limit) {
        return this.search(queryString, predicate, null, null, limit);
    }

    public Iterator<TextHit> search(String queryString, Node predicate, String graphURI, String lang, int limit) {
        queryString = QueryParserBase.escape((String)queryString);
        if (predicate != null) {
            String f = this.textIndex.getDocDef().getField(predicate);
            queryString = f + ":" + (String)queryString;
        }
        List<TextHit> results = this.textIndex.query(predicate, (String)queryString, graphURI, lang, limit);
        return results.iterator();
    }

    @Override
    public void begin(TxnType txnType) {
        switch (txnType) {
            case READ_PROMOTE: 
            case READ_COMMITTED_PROMOTE: {
                throw new UnsupportedOperationException("begin(" + txnType + ")");
            }
        }
        this.begin(TxnType.convert(txnType));
    }

    @Override
    public void begin(ReadWrite readWrite) {
        this.readWriteMode.set(readWrite);
        super.begin(readWrite);
        super.getMonitor().start();
    }

    @Override
    public void commit() {
        super.getMonitor().finish();
        this.commitAction.run();
        this.readWriteMode.set(null);
    }

    @Override
    public void abort() {
        super.getMonitor().finish();
        this.abortAction.run();
        this.readWriteMode.set(null);
    }

    private void commit_R() {
        super.commit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commit_W() {
        Object object = this.txnExitLock;
        synchronized (object) {
            super.getMonitor().finish();
            try {
                this.textIndex.prepareCommit();
            }
            catch (Throwable t) {
                log.error("Exception in prepareCommit: " + t.getMessage(), t);
                this.abort();
                throw new TextIndexException(t);
            }
            try {
                super.commit();
                this.textIndex.commit();
            }
            catch (Throwable t) {
                log.error("Exception in commit: " + t.getMessage(), t);
                this.abort();
                throw new TextIndexException(t);
            }
        }
    }

    private void abort_R() {
        try {
            super.abort();
        }
        catch (Throwable t) {
            log.warn("Exception in abort: " + t.getMessage(), t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void abort_W() {
        Object object = this.txnExitLock;
        synchronized (object) {
            try {
                super.abort();
            }
            catch (Throwable t) {
                log.warn("Exception in abort: " + t.getMessage(), t);
            }
            try {
                this.textIndex.rollback();
            }
            catch (Throwable t) {
                log.warn("Exception in abort: " + t.getMessage(), t);
            }
        }
    }

    @Override
    public boolean isInTransaction() {
        return this.readWriteMode.get() != null;
    }

    @Override
    public void end() {
        if (!this.isInTransaction()) {
            super.end();
            return;
        }
        if (this.readWriteMode.get() == ReadWrite.WRITE) {
            this.abortAction.run();
        }
        super.end();
        super.getMonitor().finish();
        this.readWriteMode.set(null);
    }

    @Override
    public boolean supportsTransactions() {
        return super.supportsTransactions();
    }

    @Override
    public boolean supportsTransactionAbort() {
        return super.supportsTransactionAbort();
    }

    @Override
    public void close() {
        super.close();
        if (this.closeIndexOnClose) {
            this.textIndex.close();
        }
    }
}

