/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.cmd;

import arq.cmdline.CmdARQ;
import arq.cmdline.ModDatasetAssembler;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.List;
import org.apache.jena.atlas.lib.FileOps;
import org.apache.jena.cmd.ArgDecl;
import org.apache.jena.cmd.CmdException;
import org.apache.jena.cmd.TerminationException;
import org.apache.jena.fuseki.Fuseki;
import org.apache.jena.fuseki.FusekiException;
import org.apache.jena.fuseki.cmd.FusekiArgs;
import org.apache.jena.fuseki.cmd.JettyFusekiWebapp;
import org.apache.jena.fuseki.cmd.WebappDSGSetup;
import org.apache.jena.fuseki.jetty.JettyServerConfig;
import org.apache.jena.fuseki.system.FusekiLogging;
import org.apache.jena.fuseki.webapp.FusekiEnv;
import org.apache.jena.fuseki.webapp.FusekiServerListener;
import org.apache.jena.query.ARQ;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.riot.RiotException;
import org.apache.jena.sparql.core.DatasetGraphFactory;
import org.apache.jena.sys.JenaSystem;
import org.apache.jena.system.Txn;
import org.apache.jena.tdb.TDB;
import org.slf4j.Logger;

public class FusekiCmd {
    public static void main(String ... argv) {
        FusekiCmdInner.innerMain(argv);
    }

    public static void runFuseki(FusekiArgs serverConfig, JettyServerConfig jettyConfig) {
        FusekiServerListener.initialSetup = serverConfig;
        JettyFusekiWebapp.initializeServer(jettyConfig);
        JettyFusekiWebapp.instance.start();
        JettyFusekiWebapp.instance.join();
    }

    static {
        FusekiEnv.mode = FusekiEnv.INIT.STANDALONE;
        FusekiEnv.setEnvironment();
        FusekiLogging.setLogging(FusekiEnv.FUSEKI_BASE);
    }

    static class FusekiCmdInner
    extends CmdARQ {
        private static ArgDecl argMgt = new ArgDecl(false, "mgt");
        private static ArgDecl argMgtPort = new ArgDecl(true, "mgtPort", "mgtport");
        private static ArgDecl argHome = new ArgDecl(true, "home");
        private static ArgDecl argPages = new ArgDecl(true, "pages");
        private static ArgDecl argMem = new ArgDecl(false, "mem");
        private static ArgDecl argUpdate = new ArgDecl(false, "update", "allowUpdate");
        private static ArgDecl argFile = new ArgDecl(true, "file");
        private static ArgDecl argTDB1mode = new ArgDecl(false, "tdb1");
        private static ArgDecl argTDB2mode = new ArgDecl(false, "tdb2");
        private static ArgDecl argMemTDB = new ArgDecl(false, "memtdb", "memTDB", "tdbmem");
        private static ArgDecl argTDB = new ArgDecl(true, "loc", "location", "tdb");
        private static ArgDecl argRDFS = new ArgDecl(true, "rdfs");
        private static ArgDecl argPort = new ArgDecl(true, "port");
        private static ArgDecl argLocalhost = new ArgDecl(false, "localhost", "local");
        private static ArgDecl argTimeout = new ArgDecl(true, "timeout");
        private static ArgDecl argFusekiConfig = new ArgDecl(true, "config", "conf");
        private static ArgDecl argJettyConfig = new ArgDecl(true, "jetty-config");
        private static ArgDecl argGZip = new ArgDecl(true, "gzip");
        private static ArgDecl argBasicAuth = new ArgDecl(true, "basic-auth");
        private static ModDatasetAssembler modDataset = new ModDatasetAssembler();
        private JettyServerConfig jettyServerConfig = new JettyServerConfig();
        private final FusekiArgs cmdLine;
        private boolean useTDB2;
        static String argUsage = "[--config=FILE] [--mem|--desc=AssemblerFile|--file=FILE] [--port PORT] /DatasetPathName";

        public static void innerMain(String ... argv) {
            JenaSystem.init();
            Fuseki.init();
            new FusekiCmdInner(argv).mainRun();
        }

        public FusekiCmdInner(String ... argv) {
            super(argv);
            this.jettyServerConfig.port = 3030;
            this.jettyServerConfig.contextPath = "/";
            this.jettyServerConfig.jettyConfigFile = null;
            this.jettyServerConfig.enableCompression = true;
            this.jettyServerConfig.verboseLogging = false;
            this.cmdLine = new FusekiArgs();
            this.useTDB2 = true;
            this.getUsage().startCategory("Fuseki");
            this.addModule(modDataset);
            this.add(argMem, "--mem", "Create an in-memory, non-persistent dataset for the server");
            this.add(argFile, "--file=FILE", "Create an in-memory, non-persistent dataset for the server, initialised with the contents of the file");
            this.add(argTDB1mode, "--tdb1", "Use TDB1 for command line persistent datasets (default is TDB2)");
            this.add(argTDB2mode, "--tdb2", "Use TDB2 for command line persistent datasets (default is TDB2)");
            this.add(argTDB, "--loc=DIR", "Use an existing TDB database (or create if does not exist)");
            this.add(argMemTDB, "--memTDB", "Create an in-memory, non-persistent dataset using TDB (testing only)");
            this.add(argRDFS, "--rdfs=", "Apply RDFS on top of the dataset");
            this.add(argPort, "--port", "Listen on this port number");
            this.add(argLocalhost, "--localhost", "Listen only on the localhost interface");
            this.add(argTimeout, "--timeout=", "Global timeout applied to queries (value in ms) -- format is X[,Y] ");
            this.add(argUpdate, "--update", "Allow updates (via SPARQL Update and SPARQL HTTP Update)");
            this.add(argFusekiConfig, "--config=", "Use a configuration file to determine the services");
            this.add(argJettyConfig, "--jetty-config=FILE", "Set up the server (not services) with a Jetty XML file");
            this.add(argBasicAuth);
            this.add(argPages);
            this.add(argMgt);
            this.add(argMgtPort);
            this.add(argGZip, "--gzip=on|off", "Enable GZip compression (HTTP Accept-Encoding) if request header set");
            this.modVersion.addClass(TDB.class);
            this.modVersion.addClass(Fuseki.class);
        }

        @Override
        protected String getSummary() {
            return this.getCommandName() + " " + argUsage;
        }

        @Override
        protected void processModulesAndArgs() {
            Object rdfsVocab;
            boolean cmdlineConfigPresent;
            if (super.isVerbose() || super.isDebug()) {
                this.jettyServerConfig.verboseLogging = true;
            }
            this.cmdLine.quiet = super.isQuiet();
            this.cmdLine.verbose = super.isVerbose();
            FusekiEnv.resetEnvironment();
            Logger log2 = Fuseki.serverLog;
            if (this.contains(argFusekiConfig)) {
                this.cmdLine.fusekiCmdLineConfigFile = this.getValue(argFusekiConfig);
                this.cmdLine.datasetDescription = "Configuration: " + this.cmdLine.fusekiCmdLineConfigFile;
            }
            ArgDecl assemblerDescDecl = new ArgDecl(true, "desc", "dataset");
            int x = 0;
            if (this.contains(argMem)) {
                ++x;
            }
            if (this.contains(argFile)) {
                ++x;
            }
            if (this.contains(assemblerDescDecl)) {
                ++x;
            }
            if (this.contains(argTDB)) {
                ++x;
            }
            if (this.contains(argMemTDB)) {
                ++x;
            }
            if (this.cmdLine.fusekiCmdLineConfigFile != null) {
                if (x >= 1) {
                    throw new CmdException("Dataset specified on the command line but a configuration file also given.");
                }
            } else if (x > 1) {
                throw new CmdException("Multiple ways providing a dataset. Only one of --mem, --file, --loc or --desc");
            }
            boolean bl = cmdlineConfigPresent = x != 0;
            if (cmdlineConfigPresent && this.getPositional().size() == 0) {
                throw new CmdException("Missing service name");
            }
            if (this.cmdLine.fusekiCmdLineConfigFile != null && this.getPositional().size() > 0) {
                throw new CmdException("Service name will come from --conf; no command line service name allowed");
            }
            if (!cmdlineConfigPresent && this.getPositional().size() > 0) {
                throw new CmdException("Service name given but no configuration argument to match (e.g. --mem, --loc/--tdb, --file)");
            }
            if (cmdlineConfigPresent && this.getPositional().size() > 1) {
                throw new CmdException("Multiple dataset path names given");
            }
            if (!cmdlineConfigPresent && this.cmdLine.fusekiCmdLineConfigFile == null) {
                FusekiEnv.setEnvironment();
                Path cfg = FusekiEnv.FUSEKI_BASE.resolve("config.ttl").toAbsolutePath();
                if (Files.exists(cfg, new LinkOption[0])) {
                    this.cmdLine.fusekiServerConfigFile = cfg.toString();
                }
            }
            if (!cmdlineConfigPresent && this.contains(argRDFS)) {
                throw new CmdException("Need to define RDFS setup in the configuration file.");
            }
            if (this.contains(argTDB1mode)) {
                this.useTDB2 = false;
            }
            if (this.contains(argTDB2mode)) {
                this.useTDB2 = true;
            }
            this.cmdLine.allowUpdate = this.contains(argUpdate);
            if (this.contains(argMem)) {
                this.cmdLine.datasetDescription = "in-memory";
                this.cmdLine.reset();
                this.cmdLine.templateFile = "templates/config-mem";
                this.cmdLine.allowUpdate = true;
            }
            if (this.contains(argFile)) {
                List<String> filenames = this.getValues(argFile);
                this.cmdLine.reset();
                this.cmdLine.dsg = DatasetGraphFactory.createTxnMem();
                this.cmdLine.allowUpdate = this.contains(argUpdate);
                this.cmdLine.datasetDescription = "in-memory, with files loaded";
                Iterator<String> iterator = filenames.iterator();
                while (iterator.hasNext()) {
                    String filename;
                    String pathname = filename = iterator.next();
                    if (filename.startsWith("file:")) {
                        pathname = filename.substring("file:".length());
                    }
                    if (!FileOps.exists(filename)) {
                        throw new CmdException("File not found: " + filename);
                    }
                    Lang language = RDFLanguages.filenameToLang(filename);
                    if (language == null) {
                        throw new CmdException("Can't guess language for file: " + filename);
                    }
                    Txn.executeWrite(this.cmdLine.dsg, () -> {
                        try {
                            log2.info("Dataset: in-memory: load file: " + filename);
                            RDFDataMgr.read(this.cmdLine.dsg, filename);
                        }
                        catch (RiotException ex) {
                            throw new CmdException("Failed to load file: " + filename);
                        }
                    });
                }
            }
            if (this.contains(argMemTDB)) {
                this.cmdLine.reset();
                this.cmdLine.templateFile = this.useTDB2 ? "templates/config-tdb2-mem" : "templates/config-tdb-mem";
                this.cmdLine.params.put("DIR", "--mem--");
                this.cmdLine.allowUpdate = true;
                String string = this.cmdLine.datasetDescription = this.useTDB2 ? "TDB2 dataset (in-memory)" : "TDB1 dataset (in-memory)";
            }
            if (this.contains(argTDB)) {
                String dir = this.getValue(argTDB);
                this.cmdLine.params.put("DIR", dir);
                this.cmdLine.reset();
                this.cmdLine.allowUpdate = this.contains(argUpdate);
                WebappDSGSetup.setup(dir, this.useTDB2, this.cmdLine);
            }
            if (this.contains(argRDFS)) {
                rdfsVocab = this.getValue(argRDFS);
                if (!FileOps.exists((String)rdfsVocab)) {
                    throw new CmdException("No such file for RDFS: " + (String)rdfsVocab);
                }
                this.cmdLine.rdfsGraph = rdfsVocab;
                this.cmdLine.datasetDescription = this.cmdLine.datasetDescription + " (with RDFS)";
            }
            if (this.contains(assemblerDescDecl)) {
                this.cmdLine.datasetDescription = "Assembler: " + modDataset.getAssemblerFile();
                rdfsVocab = modDataset.createDataset();
            }
            if (cmdlineConfigPresent) {
                this.cmdLine.datasetPath = this.getPositionalArg(0);
                if (this.cmdLine.datasetPath.length() > 0 && !this.cmdLine.datasetPath.startsWith("/")) {
                    throw new CmdException("Dataset path name must begin with a /: " + this.cmdLine.datasetPath);
                }
                if (!this.cmdLine.allowUpdate) {
                    Fuseki.serverLog.info("Running in read-only mode for " + this.cmdLine.datasetPath);
                }
                this.cmdLine.params.put("NAME", this.cmdLine.datasetPath);
            }
            if (this.contains(argBasicAuth)) {
                Fuseki.configLog.warn("--basic-auth ignored: Use Apache Shiro security - see shiro.ini");
            }
            if (this.contains(argPort)) {
                String portStr = this.getValue(argPort);
                try {
                    this.jettyServerConfig.port = Integer.parseInt(portStr);
                }
                catch (NumberFormatException ex) {
                    throw new CmdException(argPort.getKeyName() + " : bad port number: " + portStr);
                }
            }
            if (this.contains(argMgt)) {
                Fuseki.configLog.warn("Fuseki v2: Management functions are always enabled.  --mgt not needed.");
            }
            if (this.contains(argMgtPort)) {
                Fuseki.configLog.warn("Fuseki v2: Management functions are always on the same port as the server.  --mgtPort ignored.");
            }
            if (this.contains(argLocalhost)) {
                this.jettyServerConfig.loopback = true;
            }
            if (this.contains(argTimeout)) {
                String str2 = this.getValue(argTimeout);
                ARQ.getContext().set(ARQ.queryTimeout, str2);
            }
            if (this.contains(argJettyConfig)) {
                this.jettyServerConfig.jettyConfigFile = this.getValue(argJettyConfig);
                if (!FileOps.exists(this.jettyServerConfig.jettyConfigFile)) {
                    throw new CmdException("No such file: " + this.jettyServerConfig.jettyConfigFile);
                }
            }
            if (this.contains(argBasicAuth)) {
                Fuseki.configLog.warn("--basic-auth ignored (use Shiro setup instead)");
            }
            if (this.contains(argHome)) {
                Fuseki.configLog.warn("--home ignored (use enviroment variables $FUSEKI_HOME and $FUSEKI_BASE)");
            }
            if (this.contains(argPages)) {
                Fuseki.configLog.warn("--pages ignored (enviroment variables $FUSEKI_HOME to provide the webapp)");
            }
            if (this.contains(argGZip)) {
                if (!this.hasValueOfTrue(argGZip) && !this.hasValueOfFalse(argGZip)) {
                    throw new CmdException(argGZip.getNames().get(0) + ": Not understood: " + this.getValue(argGZip));
                }
                this.jettyServerConfig.enableCompression = super.hasValueOfTrue(argGZip);
            }
        }

        @Override
        protected void exec() {
            try {
                FusekiCmd.runFuseki(this.cmdLine, this.jettyServerConfig);
            }
            catch (FusekiException ex) {
                throw new TerminationException(1);
            }
        }

        @Override
        protected String getCommandName() {
            return "fuseki";
        }
    }
}

