/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.atlas.logging;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import org.apache.jena.atlas.AtlasException;
import org.apache.jena.atlas.logging.LogCtlJUL;
import org.apache.jena.atlas.logging.LogCtlLog4j2;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.slf4j.Logger;

public class LogCtl {
    private static final boolean hasLog4j2 = LogCtl.hasClass("org.apache.logging.slf4j.Log4jLoggerFactory");
    private static final boolean hasLog4j1 = LogCtl.hasClass("org.slf4j.impl.Log4jLoggerFactory");
    private static final boolean hasJUL = LogCtl.hasClass("org.slf4j.impl.JDK14LoggerFactory");
    public static final String log4j2ConfigProperty = "log4j.configurationFile";
    private static final String[] log4j2files = new String[]{"log4j2.properties", "log4j2.xml"};
    private static final boolean LogLogging = System.getenv("JENA_LOGLOGGING") != null || System.getProperty("jena.loglogging") != null;
    private static String JUL_PROPERTY = "java.util.logging.configuration";

    private static boolean hasClass(String className) {
        try {
            Class.forName(className);
            return true;
        }
        catch (ClassNotFoundException e2) {
            return false;
        }
    }

    public static void set(Logger logger, String level) {
        LogCtl.setLevel(logger.getName(), level);
    }

    public static void setLevel(Class<?> cls, String level) {
        LogCtl.setLevel(cls.getName(), level);
    }

    public static void setLevel(Logger logger, String level) {
        LogCtl.setLevel(logger.getName(), level);
    }

    public static void setLevel(String logger, String level) {
        LogCtl.setLevelLog4j2(logger, level);
        LogCtl.setLevelJUL(logger, level);
    }

    public static String getLevel(Logger logger) {
        return LogCtl.getLevel(logger.getName());
    }

    public static String getLevel(Class<?> logger) {
        return LogCtl.getLevel(logger.getName());
    }

    public static String getLevel(String logger) {
        String s2 = LogCtl.getLevelLog4j2(logger);
        if (s2 != null) {
            return s2;
        }
        String s3 = LogCtl.getLevelJUL(logger);
        if (s3 != null) {
            return s3;
        }
        return null;
    }

    private static String getLevelJUL(String logger) {
        java.util.logging.Level level = java.util.logging.Logger.getLogger(logger).getLevel();
        if (level == null) {
            return null;
        }
        if (level == java.util.logging.Level.SEVERE) {
            return "ERROR";
        }
        return level.getName();
    }

    private static String getLevelLog4j2(String logger) {
        if (!hasLog4j2) {
            return null;
        }
        Level level = LogManager.getLogger(logger).getLevel();
        if (level != null) {
            return level.toString();
        }
        return null;
    }

    private static void setLevelJUL(String logger, String levelName) {
        java.util.logging.Level level = java.util.logging.Level.ALL;
        if (levelName == null) {
            level = null;
        } else if (levelName.equalsIgnoreCase("info")) {
            level = java.util.logging.Level.INFO;
        } else if (levelName.equalsIgnoreCase("debug")) {
            level = java.util.logging.Level.FINE;
        } else if (levelName.equalsIgnoreCase("warn") || levelName.equalsIgnoreCase("warning")) {
            level = java.util.logging.Level.WARNING;
        } else if (levelName.equalsIgnoreCase("error") || levelName.equalsIgnoreCase("severe")) {
            level = java.util.logging.Level.SEVERE;
        } else if (levelName.equalsIgnoreCase("OFF")) {
            level = java.util.logging.Level.OFF;
        }
        java.util.logging.Logger.getLogger(logger).setLevel(level);
    }

    private static void setLevelLog4j2(String logger, String levelName) {
        if (!hasLog4j2) {
            return;
        }
        Level level = Level.ALL;
        if (levelName == null) {
            level = null;
        } else if (levelName.equalsIgnoreCase("info")) {
            level = Level.INFO;
        } else if (levelName.equalsIgnoreCase("debug")) {
            level = Level.DEBUG;
        } else if (levelName.equalsIgnoreCase("warn") || levelName.equalsIgnoreCase("warning")) {
            level = Level.WARN;
        } else if (levelName.equalsIgnoreCase("error") || levelName.equalsIgnoreCase("severe")) {
            level = Level.ERROR;
        } else if (levelName.equalsIgnoreCase("fatal")) {
            level = Level.FATAL;
        } else if (levelName.equalsIgnoreCase("OFF")) {
            level = Level.OFF;
        }
        LogCtlLog4j2.setLoggerlevel(logger, level);
    }

    public static void enable(Logger logger) {
        LogCtl.enable(logger.getName());
    }

    public static void enable(String logger) {
        LogCtl.setLevel(logger, "all");
    }

    public static void enable(Class<?> logger) {
        LogCtl.setLevel(logger.getName(), "ALL");
    }

    public static void disable(Logger logger) {
        LogCtl.setLevel(logger.getName(), "OFF");
    }

    public static void disable(String logger) {
        LogCtl.setLevel(logger, "OFF");
    }

    public static void disable(Class<?> logger) {
        LogCtl.setLevel(logger.getName(), "OFF");
    }

    public static void setInfo(String logger) {
        LogCtl.setLevel(logger, "info");
    }

    public static void setInfo(Class<?> logger) {
        LogCtl.setLevel(logger.getName(), "info");
    }

    public static void setWarn(String logger) {
        LogCtl.setLevel(logger, "warn");
    }

    public static void setWarn(Class<?> logger) {
        LogCtl.setLevel(logger.getName(), "warn");
    }

    public static void setError(String logger) {
        LogCtl.setLevel(logger, "error");
    }

    public static void setError(Class<?> logger) {
        LogCtl.setLevel(logger.getName(), "error");
    }

    public static void setLogging() {
        if (hasLog4j2) {
            LogCtl.setLog4j2();
            return;
        }
        if (hasJUL) {
            LogCtl.setJavaLogging();
            return;
        }
    }

    @Deprecated
    public static void setCmdLogging() {
        LogCtl.setLogging();
    }

    private static void logLogging(String fmt, Object ... args) {
        if (LogLogging) {
            System.err.print("Fuseki Logging: ");
            System.err.printf(fmt, args);
            System.err.println();
        }
    }

    public static void setLog4j2() {
        LogCtl.logLogging("Ensure Log4j2 setup", new Object[0]);
        if (!LogCtl.isSetLog4j2property()) {
            LogCtl.setLog4j2property();
            if (LogCtl.isSetLog4j2property()) {
                return;
            }
            LogCtl.logLogging("Log4j2: built-in default", new Object[0]);
            LogCtlLog4j2.resetLogging(LogCtlLog4j2.log4j2setup);
        } else {
            LogCtl.logLogging("Ready set: log4j.configurationFile=" + System.getProperty(log4j2ConfigProperty), new Object[0]);
        }
    }

    static boolean isSetLog4j2property() {
        return System.getProperty(log4j2ConfigProperty) != null;
    }

    static void setLog4j2property() {
        if (LogCtl.isSetLog4j2property()) {
            return;
        }
        for (String fn : log4j2files) {
            File f = new File(fn);
            if (!f.exists()) continue;
            System.setProperty(log4j2ConfigProperty, "file:" + fn);
            return;
        }
    }

    public static void setJavaLogging() {
        LogCtl.logLogging("Ensure java.util.logging setup", new Object[0]);
        if (System.getProperty(JUL_PROPERTY) != null) {
            LogCtl.logLogging(JUL_PROPERTY + "=" + System.getProperty(JUL_PROPERTY), new Object[0]);
            return;
        }
        LogCtl.logLogging("java.util.logging reset logging", new Object[0]);
        LogCtlJUL.resetJavaLogging();
    }

    public static void setJavaLogging(String filename) {
        try {
            InputStream details = new FileInputStream(filename);
            details = new BufferedInputStream(details);
            LogCtlJUL.readJavaLoggingConfiguration(details);
        }
        catch (Exception ex) {
            throw new AtlasException(ex);
        }
    }
}

