/*
 * Decompiled with CFR 0.152.
 */
package riotcmd;

import arq.cmdline.ModContext;
import arq.cmdline.ModLangOutput;
import arq.cmdline.ModLangParse;
import arq.cmdline.ModTime;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.GZIPOutputStream;
import org.apache.jena.Jena;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.atlas.lib.IRILib;
import org.apache.jena.atlas.lib.Pair;
import org.apache.jena.cmd.ArgDecl;
import org.apache.jena.cmd.CmdException;
import org.apache.jena.cmd.CmdGeneral;
import org.apache.jena.irix.IRIException;
import org.apache.jena.rdfs.RDFSFactory;
import org.apache.jena.rdfs.SetupRDFS;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFFormat;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.riot.RDFParser;
import org.apache.jena.riot.RDFParserBuilder;
import org.apache.jena.riot.RDFWriter;
import org.apache.jena.riot.RDFWriterBuilder;
import org.apache.jena.riot.RIOT;
import org.apache.jena.riot.RiotException;
import org.apache.jena.riot.RiotNotFoundException;
import org.apache.jena.riot.SysRIOT;
import org.apache.jena.riot.lang.StreamRDFCounting;
import org.apache.jena.riot.system.ErrorHandlerFactory;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.riot.system.StreamRDFLib;
import org.apache.jena.riot.system.StreamRDFWriter;
import org.apache.jena.riot.tokens.Tokenizer;
import org.apache.jena.riot.tokens.TokenizerText;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetGraphFactory;
import org.apache.jena.sys.JenaSystem;

public abstract class CmdLangParse
extends CmdGeneral {
    protected ModTime modTime = new ModTime();
    protected ModLangParse modLangParse = new ModLangParse();
    protected ModLangOutput modLangOutput = new ModLangOutput();
    protected SetupRDFS setup = null;
    protected ModContext modContext = new ModContext();
    protected ArgDecl strictDecl = new ArgDecl(false, "strict");
    protected boolean cmdStrictMode = false;
    protected List<ParseRecord> outcomes = new ArrayList<ParseRecord>();
    protected OutputStream outputWrite = System.out;
    protected StreamRDF outputStream = null;
    protected String parserBaseIRI = null;
    protected String writerBaseIRI = null;

    protected CmdLangParse(String[] argv) {
        super(argv);
        this.addModule(this.modContext);
        this.addModule(this.modTime);
        this.addModule(this.modLangOutput);
        this.addModule(this.modLangParse);
        this.modVersion.addClass(Jena.class);
    }

    @Override
    protected String getSummary() {
        return this.getCommandName() + " [--help] [--time] [--base=IRI] [--syntax=FORMAT] [--out=FORMAT] [--count] file ...";
    }

    @Override
    protected void processModulesAndArgs() {
        this.cmdStrictMode = super.contains(this.strictDecl);
    }

    @Override
    protected void exec() {
        boolean oldStrictValue = SysRIOT.isStrictMode();
        if (this.modLangParse.strictMode()) {
            SysRIOT.setStrictMode(true);
        }
        this.writerBaseIRI = this.parserBaseIRI = this.modLangParse.getBaseIRI();
        try {
            this.exec$();
        }
        finally {
            SysRIOT.setStrictMode(oldStrictValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void exec$() {
        if (this.modLangParse.getRDFSVocab() != null) {
            this.setup = RDFSFactory.setupRDFS(this.modLangParse.getRDFSVocab().getGraph());
        }
        if (this.modLangOutput.compressedOutput()) {
            try {
                this.outputWrite = new GZIPOutputStream(this.outputWrite, true);
            }
            catch (IOException e2) {
                IO.exception(e2);
            }
        }
        this.outputStream = null;
        PostParseHandler postParse = null;
        this.outputStream = this.createStreamSink();
        if (this.outputStream == null) {
            Pair<StreamRDF, PostParseHandler> p = this.createAccumulateSink();
            this.outputStream = p.getLeft();
            postParse = p.getRight();
        }
        try {
            if (super.getPositional().isEmpty()) {
                ParseRecord parseRec = this.parseFile("-");
                this.outcome(parseRec);
            } else {
                boolean b = super.getPositional().size() > 1;
                for (String fn : super.getPositional()) {
                    if (b && !super.isQuiet()) {
                        SysRIOT.getLogger().info("File: " + fn);
                    }
                    ParseRecord parseRec = this.parseFile(fn);
                    this.outcome(parseRec);
                }
            }
            if (postParse != null) {
                postParse.postParse();
            }
            if (super.getPositional().size() > 1 && (this.modTime.timingEnabled() || this.modLangParse.outputCount())) {
                long totalMillis = 0L;
                long totalTriples = 0L;
                long totalQuads = 0L;
                long totalTuples = 0L;
                long totalErrors = 0L;
                long totalWarnings = 0L;
                boolean allSuccessful = true;
                for (ParseRecord pRec : this.outcomes) {
                    if (pRec.timeMillis >= 0L) {
                        totalMillis += pRec.timeMillis;
                    }
                    totalTriples += pRec.triples;
                    totalQuads += pRec.quads;
                    totalTuples += pRec.tuples;
                    totalErrors += pRec.errHandler.getErrorCount();
                    totalWarnings += pRec.errHandler.getWarningCount();
                    allSuccessful &= pRec.success;
                }
                this.output("Total", true, totalTriples, totalQuads, totalTuples, totalMillis, totalErrors, totalWarnings);
            }
        }
        finally {
            if (this.outputWrite != System.out) {
                IO.close(this.outputWrite);
            } else {
                IO.flush(this.outputWrite);
            }
            System.err.flush();
        }
        for (ParseRecord pr : this.outcomes) {
            if (pr.success && !pr.errHandler.hadIssues()) continue;
            throw new CmdException();
        }
    }

    public void outcome(ParseRecord rtn) {
        if (this.modLangParse.outputCount()) {
            System.err.printf("%-15s", rtn.filename);
            if (rtn.triples > 0L) {
                System.err.printf(" : Triples = %,d", rtn.triples);
            }
            if (rtn.quads > 0L) {
                System.err.printf(" : Quads = %,d", rtn.quads);
            }
            System.err.println();
        }
        this.outcomes.add(rtn);
        if (this.modTime.timingEnabled()) {
            this.output(rtn);
        }
    }

    public ParseRecord parseFile(String filename) {
        String baseParserIRI = this.parserBaseIRI;
        RDFParserBuilder builder = RDFParser.create();
        if (baseParserIRI != null) {
            builder.base(baseParserIRI);
        }
        if (this.modLangParse.getLang() != null) {
            builder.forceLang(this.modLangParse.getLang());
        } else {
            Lang lang = this.dftLang();
            if (lang == null) {
                lang = Lang.NQUADS;
            }
            builder.lang(lang);
        }
        if (filename.equals("-")) {
            if (baseParserIRI == null) {
                baseParserIRI = "http://base/";
                builder.base(baseParserIRI);
            }
            filename = "stdin";
            builder.source(System.in);
        } else {
            filename = IRILib.filenameToIRI(filename);
            builder.source(filename);
        }
        return this.parseRIOT(builder, filename);
    }

    protected abstract Lang dftLang();

    protected ParseRecord parseRIOT(RDFParserBuilder builder, String filename) {
        boolean checking = true;
        if (this.modLangParse.explicitChecking()) {
            checking = true;
        }
        if (this.modLangParse.explicitNoChecking()) {
            checking = false;
        }
        builder.checking(checking);
        if (checking) {
            builder.strict(true);
        }
        ErrorHandlerFactory.ErrorHandlerTracking errHandler = ErrorHandlerFactory.errorHandlerTracking(ErrorHandlerFactory.stdLogger, true, this.modLangParse.stopOnWarnings());
        builder.errorHandler(errHandler);
        boolean labelsAsGiven = false;
        StreamRDF s = this.outputStream;
        if (this.setup != null) {
            s = RDFSFactory.streamRDFS(s, this.setup);
        }
        StreamRDFCounting sink = StreamRDFLib.count(s);
        s = null;
        boolean successful = true;
        this.modTime.startTimer();
        RDFParser parser = builder.build();
        try {
            sink.start();
            parser.parse(sink);
            successful = true;
        }
        catch (RiotNotFoundException ex) {
            errHandler.error(ex.getMessage(), -1L, -1L);
            successful = false;
        }
        catch (RiotException ex) {
            successful = false;
        }
        catch (IRIException ex) {
            successful = false;
        }
        sink.finish();
        long x = this.modTime.endTimer();
        ParseRecord outcome = new ParseRecord(filename, successful, x, sink.countTriples(), sink.countQuads(), errHandler);
        return outcome;
    }

    protected StreamRDF createStreamSink() {
        if (this.modLangParse.toBitBucket()) {
            return StreamRDFLib.sinkNull();
        }
        RDFFormat fmt = this.modLangOutput.getOutputStreamFormat();
        if (fmt == null) {
            return null;
        }
        return StreamRDFWriter.getWriterStream(this.outputWrite, fmt, RIOT.getContext());
    }

    protected Pair<StreamRDF, PostParseHandler> createAccumulateSink() {
        DatasetGraph dsg = DatasetGraphFactory.create();
        StreamRDF sink = StreamRDFLib.dataset(dsg);
        RDFFormat fmt = this.modLangOutput.getOutputFormatted();
        PostParseHandler handler = () -> {
            RDFWriterBuilder builder = RDFWriter.create();
            builder.format(fmt);
            if (RDFLanguages.isQuads(fmt.getLang())) {
                builder.source(dsg);
            } else {
                builder.source(dsg.getDefaultGraph());
            }
            String baseURI = this.writerBaseIRI;
            if (baseURI != null) {
                builder.base(baseURI);
            }
            builder.output(this.outputWrite);
        };
        return Pair.create(sink, handler);
    }

    protected Tokenizer makeTokenizer(InputStream in) {
        Tokenizer tokenizer = TokenizerText.create().source(in).build();
        return tokenizer;
    }

    protected void output(ParseRecord rtn) {
        this.output(rtn.filename, rtn.success, rtn.triples, rtn.quads, rtn.tuples, rtn.timeMillis, rtn.errHandler.getErrorCount(), rtn.errHandler.getWarningCount());
    }

    protected void output(String label, boolean success, long numberTriples, long numberQuads, long numberTuples, long timeMillis, long errorCount, long warningCount) {
        double timeSec = (double)timeMillis / 1000.0;
        long total = numberTriples + numberQuads + numberTuples;
        StringBuilder sb = new StringBuilder();
        if (total > 0L) {
            sb.append(String.format("%-15s", label));
            if (success) {
                this.appendFmt(sb, " : %,4.2f sec", timeSec);
            }
            this.appendCount(sb, numberTriples, "Triple", "Triples", "TPS");
            this.appendCount(sb, numberQuads, "Quad", "Quads", "QPS");
            this.appendCount(sb, numberTuples, "Tuple", "Tuples", "TPS");
            if (success && timeMillis > 0L) {
                this.appendFmt(sb, " : %,.2f %s", (double)total / timeSec, "per second");
            }
        } else {
            this.appendFmt(sb, "%s :  (No Output)", label);
        }
        if (errorCount > 0L || warningCount > 0L) {
            this.appendFmt(sb, " : %,d %s", errorCount, "errors");
            this.appendFmt(sb, " : %,d %s", warningCount, "warnings");
        }
        System.err.println(sb.toString());
    }

    private void appendFmt(StringBuilder sb, String fmt, Object ... args) {
        sb.append(String.format(fmt, args));
    }

    private void appendCount(StringBuilder sb, long number, String itemName, String itemsName, String rateName) {
        if (number > 0L) {
            String str2 = itemName;
            if (number > 1L) {
                str2 = itemsName;
            }
            sb.append(String.format(" : %,d %s", number, str2));
        }
    }

    protected void output(String label) {
        System.err.printf("%s : \n", label);
    }

    static {
        JenaSystem.init();
    }

    protected static interface PostParseHandler {
        public void postParse();
    }

    static class ParseRecord {
        final String filename;
        final boolean success;
        final long timeMillis;
        final long triples;
        final long quads;
        final long tuples = 0L;
        final ErrorHandlerFactory.ErrorHandlerTracking errHandler;

        public ParseRecord(String filename, boolean successful, long timeMillis, long countTriples, long countQuads, ErrorHandlerFactory.ErrorHandlerTracking errHandler) {
            this.filename = filename;
            this.success = successful;
            this.timeMillis = timeMillis;
            this.triples = countTriples;
            this.quads = countQuads;
            this.errHandler = errHandler;
        }
    }
}

