/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb2.sys;

import java.util.Iterator;
import org.apache.jena.atlas.lib.Pair;
import org.apache.jena.graph.Node;
import org.apache.jena.riot.out.NodeFmtLib;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.tdb2.store.DatasetGraphTDB;
import org.apache.jena.tdb2.store.NodeId;
import org.apache.jena.tdb2.store.nodetable.NodeTable;
import org.apache.jena.tdb2.sys.TDBInternal;

public class NodeTableLib {
    public static void printNodeTable(DatasetGraph dsg, long limit) {
        dsg.executeRead(() -> {
            DatasetGraphTDB dsgtdb = TDBInternal.getDatasetGraphTDB(dsg);
            NodeTable nodeTable = dsgtdb.getTripleTable().getNodeTupleTable().getNodeTable();
            int x = 0;
            Iterator<Pair<NodeId, Node>> iter = nodeTable.all();
            while (iter.hasNext()) {
                Pair<NodeId, Node> pair = iter.next();
                if ((long)(++x) > limit) {
                    return;
                }
                NodeId nid = pair.getLeft();
                Node n = pair.getRight();
                System.out.printf("%s %s\n", nid, NodeFmtLib.strNT(n));
            }
            System.out.println("Node table length: " + x);
        });
    }
}

