/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.pfunction.library;

import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.ARQInternalErrorException;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.pfunction.library.ListBase1;
import org.apache.jena.sparql.util.IterLib;
import org.apache.jena.sparql.util.NodeFactoryExtra;
import org.apache.jena.sparql.util.graph.GNode;
import org.apache.jena.sparql.util.graph.GraphList;

public class listLength
extends ListBase1 {
    @Override
    public QueryIterator execOneList(Binding binding, Node listNode, Node predicate, Node length, ExecutionContext execCxt) {
        Graph graph = execCxt.getActiveGraph();
        if (Var.isVar(listNode)) {
            throw new ARQInternalErrorException("listLength: Subject is a variable");
        }
        if (Var.isVar(length)) {
            return this.length(binding, graph, listNode, Var.alloc(length), execCxt);
        }
        return this.verify(binding, graph, listNode, length, execCxt);
    }

    private QueryIterator length(Binding binding, Graph graph, Node listNode, Var varLength, ExecutionContext execCxt) {
        int x = GraphList.length(new GNode(graph, listNode));
        if (x < 0) {
            return IterLib.noResults(execCxt);
        }
        Node n = NodeFactoryExtra.intToNode(x);
        return IterLib.oneResult(binding, varLength, n, execCxt);
    }

    private QueryIterator verify(Binding binding, Graph graph, Node listNode, Node length, ExecutionContext execCxt) {
        int len;
        int x = GraphList.length(new GNode(graph, listNode));
        if (x == (len = NodeFactoryExtra.nodeToInt(length))) {
            return IterLib.result(binding, execCxt);
        }
        return IterLib.noResults(execCxt);
    }

    @Override
    protected QueryIterator execObjectBound(Binding binding, Var listVar, Node predicate, Node length, ExecutionContext execCxt) {
        Graph graph = execCxt.getActiveGraph();
        return this.length(binding, graph, listVar, Var.alloc(length), execCxt);
    }
}

