/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.pfunction;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.query.ARQ;
import org.apache.jena.sparql.ARQConstants;
import org.apache.jena.sparql.pfunction.PropertyFunction;
import org.apache.jena.sparql.pfunction.PropertyFunctionFactory;
import org.apache.jena.sparql.pfunction.PropertyFunctionFactoryAuto;
import org.apache.jena.sparql.pfunction.StandardPropertyFunctions;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.sparql.util.MappedLoader;

public class PropertyFunctionRegistry {
    static PropertyFunctionRegistry globalRegistry = null;
    Map<String, PropertyFunctionFactory> registry = new HashMap<String, PropertyFunctionFactory>();
    Set<String> attemptedLoads = new HashSet<String>();

    public static PropertyFunctionRegistry standardRegistry() {
        PropertyFunctionRegistry reg = PropertyFunctionRegistry.get(ARQ.getContext());
        return reg;
    }

    public static void init() {
        PropertyFunctionRegistry reg = new PropertyFunctionRegistry();
        StandardPropertyFunctions.loadStdDefs(reg);
        PropertyFunctionRegistry.set(ARQ.getContext(), reg);
    }

    public static PropertyFunctionRegistry get(Context context2) {
        if (context2 == null) {
            return null;
        }
        return (PropertyFunctionRegistry)context2.get(ARQConstants.registryPropertyFunctions);
    }

    public static PropertyFunctionRegistry chooseRegistry(Context context2) {
        PropertyFunctionRegistry registry = PropertyFunctionRegistry.get(context2);
        if (registry == null) {
            registry = PropertyFunctionRegistry.get();
        }
        return registry;
    }

    public static void set(Context context2, PropertyFunctionRegistry reg) {
        context2.set(ARQConstants.registryPropertyFunctions, reg);
    }

    public static synchronized PropertyFunctionRegistry get() {
        PropertyFunctionRegistry reg = PropertyFunctionRegistry.get(ARQ.getContext());
        if (reg == null) {
            reg = PropertyFunctionRegistry.standardRegistry();
            PropertyFunctionRegistry.set(ARQ.getContext(), reg);
        }
        return reg;
    }

    public void put(String uri, Class<?> extClass) {
        if (!PropertyFunction.class.isAssignableFrom(extClass)) {
            Log.warn(this, "Class " + extClass.getName() + " is not an PropertyFunction");
            return;
        }
        this.put(uri, new PropertyFunctionFactoryAuto(extClass));
    }

    public void put(String uri, PropertyFunctionFactory factory) {
        this.registry.put(uri, factory);
    }

    public boolean manages(String uri) {
        if (this.registry.containsKey(uri)) {
            return true;
        }
        return MappedLoader.isPossibleDynamicURI(uri, PropertyFunction.class);
    }

    public PropertyFunctionFactory get(String uri) {
        PropertyFunctionFactory factory;
        String mappedUri = MappedLoader.mapDynamicURI(uri);
        if (mappedUri != null) {
            uri = mappedUri;
        }
        if ((factory = this.registry.get(uri)) != null) {
            return factory;
        }
        if (this.attemptedLoads.contains(uri)) {
            return null;
        }
        Class<?> extClass = MappedLoader.loadClass(uri, PropertyFunction.class);
        if (extClass == null) {
            return null;
        }
        this.put(mappedUri, extClass);
        this.attemptedLoads.add(uri);
        return this.registry.get(uri);
    }

    public boolean isRegistered(String uri) {
        return this.registry.containsKey(uri);
    }

    public PropertyFunctionFactory remove(String uri) {
        return this.registry.remove(uri);
    }

    public Iterator<String> keys() {
        return this.registry.keySet().iterator();
    }
}

