/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.system;

import java.io.OutputStream;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.riot.out.NodeFormatter;
import org.apache.jena.riot.out.NodeFormatterTTL;
import org.apache.jena.riot.system.PrefixMap;
import org.apache.jena.riot.system.PrefixMapFactory;
import org.apache.jena.riot.writer.WriterStreamRDFPlain;

public class PrintingStreamRDF
extends WriterStreamRDFPlain {
    private PrefixMap prefixMap = PrefixMapFactory.create();
    private NodeFormatter pretty = new NodeFormatterTTL(null, this.prefixMap);

    public PrintingStreamRDF(OutputStream out) {
        super(IO.wrapUTF8(out));
    }

    @Override
    protected NodeFormatter getFmt() {
        return this.pretty;
    }

    @Override
    public void base(String base) {
        this.out.print("BASE");
        this.out.print("    ");
        this.getFmt().formatURI(this.out, base);
        this.out.println();
        this.pretty = new NodeFormatterTTL(base, this.prefixMap);
    }

    @Override
    public void prefix(String prefix, String iri2) {
        this.out.print("PREFIX");
        this.out.print("  ");
        this.out.print(prefix);
        this.out.print(":  ");
        this.getFmt().formatURI(this.out, iri2);
        this.out.println();
        this.prefixMap.add(prefix, iri2);
    }
}

