/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.http.auth;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.jena.http.auth.AuthChallenge;
import org.apache.jena.http.auth.AuthStringException;

class AuthStringTokenizer {
    private static String regex = "(\"[^\"=]*\"|,|=|[^=, \"]+)";
    private static Pattern pattern = Pattern.compile(regex);
    private static String nullString = "";

    AuthStringTokenizer() {
    }

    static Map<String, String> parse(String string) {
        try {
            return AuthStringTokenizer.parse$(string);
        }
        catch (AuthStringException ex) {
            return null;
        }
    }

    private static Map<String, String> parse$(String string) {
        List<String> tokens2 = AuthStringTokenizer.tokenize(string);
        HashMap<String, String> map = new HashMap<String, String>();
        if (!tokens2.isEmpty()) {
            String s = tokens2.get(0);
            if ("Digest".equalsIgnoreCase(s)) {
                map.put(AuthChallenge.SCHEME, s);
            }
            if ("Basic".equalsIgnoreCase(s)) {
                map.put(AuthChallenge.SCHEME, s);
            }
        }
        String word1 = null;
        boolean seenEquals = false;
        for (String s : tokens2) {
            if (s == null) continue;
            if (s.equals(",")) {
                if (word1 != null) {
                    AuthStringTokenizer.record(map, word1, null);
                }
                word1 = null;
                continue;
            }
            if (s.equals("=")) {
                seenEquals = true;
                continue;
            }
            if (word1 == null) {
                if (seenEquals) {
                    throw new AuthStringException();
                }
                word1 = s;
                continue;
            }
            if (!seenEquals) {
                AuthStringTokenizer.record(map, word1, null);
                word1 = s;
                continue;
            }
            AuthStringTokenizer.record(map, word1, s);
            word1 = null;
            seenEquals = false;
        }
        if (word1 != null) {
            AuthStringTokenizer.record(map, word1, null);
        }
        return map;
    }

    static List<String> tokenize(String string) {
        ArrayList<String> list = new ArrayList<String>();
        Matcher m = pattern.matcher(string);
        block0: while (m.find()) {
            for (int i = 1; i <= m.groupCount(); ++i) {
                if (m.group(i) == null) continue;
                list.add(m.group(i));
                continue block0;
            }
        }
        return list;
    }

    private static boolean isQuoted(String string) {
        return string.startsWith("\"") && string.endsWith("\"");
    }

    private static boolean maybeQuoted(String string) {
        return string.startsWith("\"") || string.endsWith("\"");
    }

    private static void record(Map<String, String> map, String word1, String word2) {
        if (word1 == null || word1.isEmpty() || AuthStringTokenizer.maybeQuoted(word1)) {
            throw new AuthStringException();
        }
        word1 = word1.toLowerCase();
        if (word2 == null) {
            word2 = nullString;
        } else if (AuthStringTokenizer.isQuoted(word2)) {
            word2 = word2.substring(1, word2.length() - 1);
        }
        map.put(word1, word2);
    }
}

