/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb2.solver;

import java.util.function.Predicate;
import org.apache.jena.atlas.lib.tuple.Tuple;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.ARQInternalErrorException;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.op.OpBGP;
import org.apache.jena.sparql.algebra.op.OpDatasetNames;
import org.apache.jena.sparql.algebra.op.OpDistinct;
import org.apache.jena.sparql.algebra.op.OpFilter;
import org.apache.jena.sparql.algebra.op.OpGraph;
import org.apache.jena.sparql.algebra.op.OpQuadPattern;
import org.apache.jena.sparql.algebra.op.OpReduced;
import org.apache.jena.sparql.algebra.optimize.TransformFilterPlacement;
import org.apache.jena.sparql.core.BasicPattern;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.core.Substitute;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.iterator.QueryIterPeek;
import org.apache.jena.sparql.engine.main.OpExecutor;
import org.apache.jena.sparql.engine.main.OpExecutorFactory;
import org.apache.jena.sparql.engine.main.QC;
import org.apache.jena.sparql.engine.main.iterator.QueryIterGraph;
import org.apache.jena.sparql.engine.optimizer.reorder.ReorderProc;
import org.apache.jena.sparql.engine.optimizer.reorder.ReorderTransformation;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.mgt.Explain;
import org.apache.jena.tdb2.solver.PatternMatchTDB2;
import org.apache.jena.tdb2.solver.QC2;
import org.apache.jena.tdb2.solver.SolverLibTDB;
import org.apache.jena.tdb2.store.DatasetGraphTDB;
import org.apache.jena.tdb2.store.GraphTDB;
import org.apache.jena.tdb2.store.NodeId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpExecutorTDB2
extends OpExecutor {
    private static final Logger log = LoggerFactory.getLogger(OpExecutorTDB2.class);
    public static final OpExecutorFactory OpExecFactoryTDB = new OpExecutorFactory(){

        @Override
        public OpExecutor create(ExecutionContext execCxt) {
            return new OpExecutorTDB2(execCxt);
        }
    };
    private final boolean isForTDB;
    private static OpExecutorFactory plainFactory = new OpExecutorPlainFactoryTDB();

    public OpExecutorTDB2(ExecutionContext execCxt) {
        super(execCxt);
        this.isForTDB = execCxt.getActiveGraph() instanceof GraphTDB;
    }

    @Override
    protected QueryIterator exec(Op op, QueryIterator input) {
        if (this.level < 0) {
            Explain.explain("TDB2", op, this.execCxt.getContext());
        }
        return super.exec(op, input);
    }

    @Override
    protected QueryIterator execute(OpDistinct opDistinct, QueryIterator input) {
        return super.execute(opDistinct, input);
    }

    @Override
    protected QueryIterator execute(OpReduced opReduced, QueryIterator input) {
        return super.execute(opReduced, input);
    }

    @Override
    protected QueryIterator execute(OpFilter opFilter, QueryIterator input) {
        if (!this.isForTDB) {
            return super.execute(opFilter, input);
        }
        if (OpBGP.isBGP(opFilter.getSubOp())) {
            GraphTDB graph = (GraphTDB)this.execCxt.getActiveGraph();
            OpBGP opBGP = (OpBGP)opFilter.getSubOp();
            return OpExecutorTDB2.executeBGP(graph, opBGP, input, opFilter.getExprs(), this.execCxt);
        }
        if (opFilter.getSubOp() instanceof OpQuadPattern) {
            OpQuadPattern quadPattern = (OpQuadPattern)opFilter.getSubOp();
            DatasetGraphTDB ds = (DatasetGraphTDB)this.execCxt.getDataset();
            return OpExecutorTDB2.optimizeExecuteQuads(ds, input, quadPattern.getGraphNode(), quadPattern.getBasicPattern(), opFilter.getExprs(), this.execCxt);
        }
        return super.execute(opFilter, input);
    }

    @Override
    protected QueryIterator execute(OpBGP opBGP, QueryIterator input) {
        if (!this.isForTDB) {
            return super.execute(opBGP, input);
        }
        GraphTDB graph = (GraphTDB)this.execCxt.getActiveGraph();
        return OpExecutorTDB2.executeBGP(graph, opBGP, input, null, this.execCxt);
    }

    @Override
    protected QueryIterator execute(OpQuadPattern quadPattern, QueryIterator input) {
        if (!this.isForTDB) {
            return super.execute(quadPattern, input);
        }
        DatasetGraphTDB ds = (DatasetGraphTDB)this.execCxt.getDataset();
        BasicPattern bgp = quadPattern.getBasicPattern();
        Node gn = quadPattern.getGraphNode();
        return OpExecutorTDB2.optimizeExecuteQuads(ds, input, gn, bgp, null, this.execCxt);
    }

    @Override
    protected QueryIterator execute(OpGraph opGraph, QueryIterator input) {
        return new QueryIterGraph(input, opGraph, this.execCxt);
    }

    private static QueryIterator executeBGP(GraphTDB graph, OpBGP opBGP, QueryIterator input, ExprList exprs, ExecutionContext execCxt) {
        DatasetGraphTDB dsgtdb = graph.getDSG();
        if (!OpExecutorTDB2.isDefaultGraphStorage(graph.getGraphName())) {
            return OpExecutorTDB2.optimizeExecuteQuads(dsgtdb, input, graph.getGraphName(), opBGP.getPattern(), exprs, execCxt);
        }
        return OpExecutorTDB2.optimizeExecuteTriples(dsgtdb, input, opBGP.getPattern(), exprs, execCxt);
    }

    private static QueryIterator optimizeExecuteTriples(DatasetGraphTDB dsgtdb, QueryIterator input, BasicPattern pattern, ExprList exprs, ExecutionContext execCxt) {
        ReorderTransformation transform;
        if (!input.hasNext()) {
            return input;
        }
        if (pattern.size() >= 2 && (transform = dsgtdb.getReorderTransform()) != null) {
            QueryIterPeek peek = QueryIterPeek.create(input, execCxt);
            input = peek;
            pattern = OpExecutorTDB2.reorder(pattern, peek, transform);
        }
        if (exprs == null) {
            Explain.explain("Execute", pattern, execCxt.getContext());
            Predicate<Tuple<NodeId>> filter = QC2.getFilter(execCxt.getContext());
            return PatternMatchTDB2.execute(dsgtdb, Quad.defaultGraphNodeGenerated, pattern, input, filter, execCxt);
        }
        Op op = TransformFilterPlacement.transform(exprs, pattern);
        return OpExecutorTDB2.plainExecute(op, input, execCxt);
    }

    private static QueryIterator optimizeExecuteQuads(DatasetGraphTDB dsgtdb, QueryIterator input, Node gn, BasicPattern bgp, ExprList exprs, ExecutionContext execCxt) {
        ReorderTransformation transform;
        if (!input.hasNext()) {
            return input;
        }
        if ((gn = OpExecutorTDB2.decideGraphNode(gn, execCxt)) == null) {
            return OpExecutorTDB2.optimizeExecuteTriples(dsgtdb, input, bgp, exprs, execCxt);
        }
        if (bgp.size() >= 2 && (transform = dsgtdb.getReorderTransform()) != null) {
            QueryIterPeek peek = QueryIterPeek.create(input, execCxt);
            input = peek;
            bgp = OpExecutorTDB2.reorder(bgp, peek, transform);
        }
        if (exprs == null) {
            Explain.explain("Execute", bgp, execCxt.getContext());
            Predicate<Tuple<NodeId>> filter = QC2.getFilter(execCxt.getContext());
            return PatternMatchTDB2.execute(dsgtdb, gn, bgp, input, filter, execCxt);
        }
        Op op = TransformFilterPlacement.transform(exprs, gn, bgp);
        return OpExecutorTDB2.plainExecute(op, input, execCxt);
    }

    private static QueryIterator plainExecute(Op op, QueryIterator input, ExecutionContext execCxt) {
        ExecutionContext ec2 = new ExecutionContext(execCxt);
        ec2.setExecutor(plainFactory);
        return QC.execute(op, input, ec2);
    }

    private static BasicPattern reorder(BasicPattern pattern, QueryIterPeek peek, ReorderTransformation transform) {
        if (transform != null) {
            if (!peek.hasNext()) {
                throw new ARQInternalErrorException("Peek iterator is already empty");
            }
            BasicPattern pattern2 = Substitute.substitute(pattern, peek.peek());
            ReorderProc proc = transform.reorderIndexes(pattern2);
            pattern = proc.reorder(pattern);
        }
        return pattern;
    }

    public static Node decideGraphNode(Node gn, ExecutionContext execCxt) {
        if (OpExecutorTDB2.isDefaultGraphStorage(gn)) {
            return null;
        }
        if (Quad.isUnionGraph(gn)) {
            return Node.ANY;
        }
        boolean doingUnion = false;
        return gn;
    }

    private static boolean isDefaultGraphStorage(Node gn) {
        if (gn == null) {
            return true;
        }
        return Quad.isDefaultGraph(gn);
    }

    @Override
    protected QueryIterator execute(OpDatasetNames dsNames, QueryIterator input) {
        DatasetGraphTDB ds = (DatasetGraphTDB)this.execCxt.getDataset();
        Predicate<Tuple<NodeId>> filter = QC2.getFilter(this.execCxt.getContext());
        Node gn = dsNames.getGraphNode();
        if (Var.isVar(gn)) {
            return SolverLibTDB.graphNames(ds, dsNames.getGraphNode(), input, filter, this.execCxt);
        }
        return SolverLibTDB.testForGraphName(ds, dsNames.getGraphNode(), input, filter, this.execCxt);
    }

    private static class OpExecutorPlainFactoryTDB
    implements OpExecutorFactory {
        private OpExecutorPlainFactoryTDB() {
        }

        @Override
        public OpExecutor create(ExecutionContext execCxt) {
            return new OpExecutorPlainTDB(execCxt);
        }
    }

    private static class OpExecutorPlainTDB
    extends OpExecutor {
        Predicate<Tuple<NodeId>> filter = null;

        public OpExecutorPlainTDB(ExecutionContext execCxt) {
            super(execCxt);
            this.filter = QC2.getFilter(execCxt.getContext());
        }

        @Override
        public QueryIterator execute(OpBGP opBGP, QueryIterator input) {
            Graph g = this.execCxt.getActiveGraph();
            if (g instanceof GraphTDB) {
                BasicPattern bgp = opBGP.getPattern();
                Explain.explain("Execute", bgp, this.execCxt.getContext());
                GraphTDB gtdb = (GraphTDB)g;
                Node gn = OpExecutorTDB2.decideGraphNode(gtdb.getGraphName(), this.execCxt);
                return PatternMatchTDB2.execute(gtdb.getDSG(), gn, bgp, input, this.filter, this.execCxt);
            }
            Log.warn(this, "Non-GraphTDB passed to OpExecutorPlainTDB: " + g.getClass().getSimpleName());
            return super.execute(opBGP, input);
        }

        @Override
        public QueryIterator execute(OpQuadPattern opQuadPattern, QueryIterator input) {
            Node gn = opQuadPattern.getGraphNode();
            gn = OpExecutorTDB2.decideGraphNode(gn, this.execCxt);
            if (this.execCxt.getDataset() instanceof DatasetGraphTDB) {
                DatasetGraphTDB ds = (DatasetGraphTDB)this.execCxt.getDataset();
                Explain.explain("Execute", opQuadPattern.getPattern(), this.execCxt.getContext());
                BasicPattern bgp = opQuadPattern.getBasicPattern();
                return PatternMatchTDB2.execute(ds, gn, bgp, input, this.filter, this.execCxt);
            }
            Graph g = this.execCxt.getActiveGraph();
            if (g instanceof GraphTDB) {
                BasicPattern bgp = opQuadPattern.getBasicPattern();
                Explain.explain("Execute", bgp, this.execCxt.getContext());
                return PatternMatchTDB2.execute(((GraphTDB)g).getDSG(), gn, bgp, input, this.filter, this.execCxt);
            }
            Log.warn(this, "Non-DatasetGraphTDB passed to OpExecutorPlainTDB");
            return super.execute(opQuadPattern, input);
        }
    }
}

