/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.shex.sys;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import org.apache.jena.atlas.lib.InternalErrorException;
import org.apache.jena.atlas.lib.Pair;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.shex.ShexRecord;
import org.apache.jena.shex.ShexReport;
import org.apache.jena.shex.ShexSchema;
import org.apache.jena.shex.ShexShape;
import org.apache.jena.shex.ShexStatus;
import org.apache.jena.shex.expressions.TripleExpression;
import org.apache.jena.shex.sys.ReportItem;

public class ValidationContext {
    private final ShexSchema shapes;
    private final Graph data;
    private boolean verbose = false;
    private boolean seenReportEntry = false;
    private Deque<Pair<Node, ShexShape>> inProgress = new ArrayDeque<Pair<Node, ShexShape>>();
    private final ShexReport.Builder reportBuilder = ShexReport.create();

    public static ValidationContext create(ValidationContext vCxt) {
        return new ValidationContext(vCxt.data, vCxt.shapes, vCxt.inProgress);
    }

    public ValidationContext(Graph data, ShexSchema shapes) {
        this(data, shapes, null);
    }

    private ValidationContext(Graph data, ShexSchema shapes, Deque<Pair<Node, ShexShape>> progress) {
        this.data = data;
        this.shapes = shapes;
        if (progress != null) {
            this.inProgress.addAll(progress);
        }
    }

    public TripleExpression getTripleExpression(Node label) {
        return this.shapes.getTripleExpression(label);
    }

    public ShexSchema getShapes() {
        return this.shapes;
    }

    public ShexShape getShape(Node label) {
        return this.shapes.get(label);
    }

    public Graph getData() {
        return this.data;
    }

    public void startValidate(ShexShape shape, Node data) {
        this.inProgress.push(Pair.create(data, shape));
    }

    public boolean cycle(ShexShape shape, Node data) {
        return this.inProgress.stream().anyMatch(p -> p.equalElts(data, shape));
    }

    public void finishValidate(ShexShape shape, Node data) {
        Pair<Node, ShexShape> x = this.inProgress.pop();
        if (x.equalElts(data, shape)) {
            return;
        }
        throw new InternalErrorException("Eval stack error");
    }

    public boolean hasEntries() {
        return this.reportBuilder.hasEntries();
    }

    public void copyInto(ValidationContext other) {
        this.reportBuilder.getItems().forEach(item -> other.reportEntry((ReportItem)item));
        this.reportBuilder.getReports().forEach(reportLine -> other.shexReport((ShexRecord)reportLine));
    }

    private void shexReport(ShexRecord reportLine) {
        this.reportBuilder.shexReport(reportLine);
    }

    public List<ReportItem> getReportItems() {
        return this.reportBuilder.getItems();
    }

    public List<ShexRecord> getShexReportItems() {
        return this.reportBuilder.getReports();
    }

    public void reportEntry(ReportItem item) {
        this.reportBuilder.addReportItem(item);
    }

    public void shexReport(ShexRecord entry, Node focusNode, ShexStatus result, String reason) {
        this.reportBuilder.shexReport(entry, focusNode, result, reason);
    }

    public ShexReport generateReport() {
        return this.reportBuilder.build();
    }
}

