/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.resultset.rw;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.apache.jena.atlas.csv.CSVParser;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.logging.FmtLog;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.query.ResultSet;
import org.apache.jena.riot.resultset.ResultSetLang;
import org.apache.jena.riot.resultset.ResultSetReader;
import org.apache.jena.riot.resultset.ResultSetReaderFactory;
import org.apache.jena.sparql.ARQException;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.ResultSetStream;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingBuilder;
import org.apache.jena.sparql.resultset.ResultSetException;
import org.apache.jena.sparql.resultset.SPARQLResult;
import org.apache.jena.sparql.util.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class ResultSetReaderCSV
implements ResultSetReader {
    private static Logger log = LoggerFactory.getLogger(ResultSetReaderCSV.class);
    public static final ResultSetReaderFactory factory = lang -> {
        if (!Objects.equals(lang, ResultSetLang.RS_CSV)) {
            throw new ResultSetException("ResulResultSetReadertSet for CSV asked for a " + lang);
        }
        return new ResultSetReaderCSV();
    };

    private ResultSetReaderCSV() {
    }

    @Override
    public SPARQLResult readAny(InputStream in, Context context2) {
        return ResultSetReaderCSV.csvResult(in);
    }

    @Override
    public ResultSet read(InputStream in, Context context2) {
        return ResultSetReaderCSV.resultSetFromCSV(in);
    }

    private static SPARQLResult csvResult(InputStream in) {
        CSVParser parser = CSVParser.create(in);
        List<Var> vars = ResultSetReaderCSV.vars(parser);
        if (ResultSetReaderCSV.isBooleanResult(vars)) {
            boolean booleanResult = ResultSetReaderCSV.booleanFromCSV(parser);
            return new SPARQLResult(booleanResult);
        }
        ResultSet resultSet = ResultSetReaderCSV.resultSetFromCSV(vars, parser);
        return new SPARQLResult(resultSet);
    }

    private static ResultSet resultSetFromCSV(InputStream in) {
        CSVParser parser = CSVParser.create(in);
        List<Var> vars = ResultSetReaderCSV.vars(parser);
        return ResultSetReaderCSV.resultSetFromCSV(vars, parser);
    }

    private static ResultSet resultSetFromCSV(final List<Var> vars, CSVParser parser) {
        final BindingBuilder builder = Binding.builder();
        Function<List<String>, Binding> transform = new Function<List<String>, Binding>(){
            private int count = 1;

            @Override
            public Binding apply(List<String> row) {
                if (row.size() != vars.size()) {
                    FmtLog.warn(log, "Row %d: Length=%d: expected=%d", this.count, row.size(), vars.size());
                }
                builder.reset();
                for (int i = 0; i < vars.size(); ++i) {
                    Var v = (Var)vars.get(i);
                    String field = i < row.size() ? row.get(i) : "";
                    Node n = NodeFactory.createLiteral(field);
                    builder.add(v, n);
                }
                ++this.count;
                return builder.build();
            }
        };
        Iterator<Binding> bindings2 = Iter.map(parser.iterator(), transform);
        return ResultSetStream.create(vars, bindings2);
    }

    private static List<Var> vars(CSVParser parser) {
        ArrayList<Var> vars = new ArrayList<Var>();
        List<String> varNames = parser.parse1();
        if (varNames == null) {
            throw new ARQException("SPARQL CSV Results malformed, input is empty");
        }
        for (String vn : varNames) {
            vars.add(Var.alloc(vn));
        }
        return vars;
    }

    private static boolean isBooleanResult(List<Var> vars) {
        if (vars.size() != 1) {
            return false;
        }
        return vars.get(0).getName().equals("_askResult");
    }

    private static boolean booleanFromCSV(CSVParser parser) {
        boolean b;
        List<String> line = parser.parse1();
        if (line.size() != 1) {
            throw new ARQException("CSV Boolean Results malformed: data line='" + line + "'");
        }
        String str2 = line.get(0);
        if (str2.equalsIgnoreCase("true") || str2.equalsIgnoreCase("yes")) {
            b = true;
        } else if (str2.equalsIgnoreCase("false") || str2.equalsIgnoreCase("no")) {
            b = false;
        } else {
            throw new ARQException("CSV Boolean Results malformed, expected one of - true yes false no - but got " + str2);
        }
        List<String> line2 = parser.parse1();
        if (line2 != null) {
            FmtLog.warn(log, "Extra rows: first is " + line2, new Object[0]);
        }
        return b;
    }
}

