/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.ctl;

import java.io.IOException;
import java.util.Iterator;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.fuseki.ctl.ActionCtl;
import org.apache.jena.fuseki.server.CounterName;
import org.apache.jena.fuseki.server.DataAccessPoint;
import org.apache.jena.fuseki.server.DataAccessPointRegistry;
import org.apache.jena.fuseki.server.DataService;
import org.apache.jena.fuseki.server.Endpoint;
import org.apache.jena.fuseki.server.Operation;
import org.apache.jena.fuseki.servlets.HttpAction;
import org.apache.jena.fuseki.servlets.ServletOps;

public class ActionStatsText
extends ActionCtl {
    @Override
    public void validate(HttpAction action) {
        switch (action.getMethod()) {
            case "GET": 
            case "POST": {
                return;
            }
        }
        ServletOps.errorMethodNotAllowed(action.getMethod());
    }

    @Override
    public void execute(HttpAction action) {
        try {
            this.statsTxt(action.getResponse(), action.getDataAccessPointRegistry());
        }
        catch (IOException ex) {
            IO.exception(ex);
        }
    }

    private void statsTxt(HttpServletResponse resp, DataAccessPointRegistry registry) throws IOException {
        ServletOps.setNoCache(resp);
        resp.setContentType("text/plain");
        resp.setCharacterEncoding("utf-8");
        ServletOutputStream out = resp.getOutputStream();
        Iterator iter = registry.keys().iterator();
        while (iter.hasNext()) {
            String ds = (String)iter.next();
            DataAccessPoint desc = registry.get(ds);
            this.statsTxt(out, desc);
            if (!iter.hasNext()) continue;
            out.println();
        }
        out.flush();
    }

    private void statsTxt(ServletOutputStream out, DataAccessPoint desc) throws IOException {
        DataService dSrv = desc.getDataService();
        out.println("Dataset: " + desc.getName());
        out.println("    Requests      = " + dSrv.getCounters().value(CounterName.Requests));
        out.println("    Good          = " + dSrv.getCounters().value(CounterName.RequestsGood));
        out.println("    Bad           = " + dSrv.getCounters().value(CounterName.RequestsBad));
        if (dSrv.getOperations().contains(Operation.Query)) {
            out.println("  SPARQL Query:");
            out.println("    Request       = " + this.counter(dSrv, Operation.Query, CounterName.Requests));
            out.println("    Good          = " + this.counter(dSrv, Operation.Query, CounterName.RequestsGood));
            out.println("    Bad requests  = " + this.counter(dSrv, Operation.Query, CounterName.RequestsBad));
        }
        if (dSrv.getOperations().contains(Operation.Update)) {
            out.println("  SPARQL Update:");
            out.println("    Request       = " + this.counter(dSrv, Operation.Update, CounterName.Requests));
            out.println("    Good          = " + this.counter(dSrv, Operation.Update, CounterName.RequestsGood));
            out.println("    Bad requests  = " + this.counter(dSrv, Operation.Update, CounterName.RequestsBad));
        }
        if (dSrv.getOperations().contains(Operation.GSP_R) || dSrv.getOperations().contains(Operation.GSP_RW)) {
            out.println("  SPARQL Graph Store Protocol:");
            if (dSrv.getOperations().contains(Operation.GSP_R)) {
                out.println("    GETs          = " + this.counter(dSrv, Operation.GSP_R, CounterName.Requests) + " (good=" + this.counter(dSrv, Operation.GSP_R, CounterName.RequestsGood) + "/bad=" + this.counter(dSrv, Operation.GSP_R, CounterName.RequestsBad) + ")");
            }
            if (dSrv.getOperations().contains(Operation.GSP_RW)) {
                out.println("    Writes        = " + this.counter(dSrv, Operation.GSP_RW, CounterName.Requests) + " (good=" + this.counter(dSrv, Operation.GSP_RW, CounterName.RequestsGood) + "/bad=" + this.counter(dSrv, Operation.GSP_RW, CounterName.RequestsBad) + ")");
            }
        }
    }

    private long counter(DataService dSrv, Operation operation, CounterName cName) {
        long x = 0L;
        for (Endpoint ep : dSrv.getEndpoints(operation)) {
            System.out.println(cName.toString());
            System.out.println(ep.getCounters());
            x += ep.getCounters().value(cName);
        }
        return x;
    }
}

